/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#include "StatusCacheTest.h"

// cppunit
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>

// sc
#include "subcommander/WcStatusCache.h"
#include "subcommander/WcStatusInfo.h"
#include "util/String.h"


void StatusCacheTest::setUp()
{
}

void StatusCacheTest::tearDown()
{
}

void StatusCacheTest::testSet()
{
  WcStatusCache cache;

  svn::WcStatuss statuss;
  WcStatusInfo insert1( sc::String("1"), apr_time_now(), statuss );
  WcStatusInfo insert2( sc::String("2"), apr_time_now(), statuss );
  cache.set( insert1 );
  cache.set( insert2 );

  WcStatusInfo cached1 = cache.get( sc::String("1") );
  CPPUNIT_ASSERT( cached1 == insert1 );

  WcStatusInfo cached2 = cache.get( sc::String("2") );
  CPPUNIT_ASSERT( cached2 == insert2 );
}

void StatusCacheTest::testUpdate()
{
  WcStatusCache cache;

  svn::WcStatuss statuss;
  WcStatusInfo insert1( sc::String("1"), apr_time_now(), statuss );
  cache.set( insert1 );

  WcStatusInfo cached1 = cache.get( insert1.getPath() );
  CPPUNIT_ASSERT( cached1 == insert1 );

  WcStatusInfo insert2( insert1.getPath(), apr_time_now(), statuss );
  cache.set( insert2 );

  WcStatusInfo cached2 = cache.get( insert2.getPath() );
  CPPUNIT_ASSERT( cached2 == insert2 );
}

void StatusCacheTest::testGetEmpty()
{
  WcStatusCache cache;

  WcStatusInfo info = cache.get( sc::String("1") );

  CPPUNIT_ASSERT( info.isEmpty() );
}