/* ====================================================================
 * Copyright (c) 2007,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_MERGEVIEWMODEL_H
#define _SC_MERGEVIEWMODEL_H

// sc
#include "sublib/TargetId.h"
#include "svn/ClientTypes.h"
#include "svn/Revision.h"
#include "util/String.h"
class ScModel;
class MergeParam;
namespace sc {
  class Error;
}

// qt
#include <QtCore/QObject>


class MergeViewModel : public QObject, public TargetId
{
  typedef QObject super;
   Q_OBJECT;

public:
  MergeViewModel( bool changePathOrUrl1, bool changePathOrUrl2,
    bool changeType, bool pegMerge, ScModel* model );
  ~MergeViewModel();

  // QObject
  bool event( QEvent* e );

public:
  void merge();
  void dryrun();
  void mergeResult( MergeParam*, const sc::Error* );

  const sc::String& getPathOrUrl1();
  const sc::String& getPathOrUrl2();
  const svn::RevisionPtr getRevisionPeg();
  const svn::RevisionPtr getRevision1();
  const svn::RevisionPtr getRevision2();
  bool getRecursive();
  bool getCopies();
  bool getForce();
  const sc::String& getDefaultTarget();
  const sc::String& getTarget();
  const svn::Paths& getTargets();

  bool getChangePathOrUrl1();
  bool getChangePathOrUrl2();
  bool getChangeType();
  bool getPegMerge();

public slots:
  void setPathOrUrl1( const sc::String& Url1 );
  void setPathOrUrl2( const sc::String& Url2 );
  void setRevisionPeg( svn::RevisionPtr );
  void setRevision1( svn::RevisionPtr );
  void setRevision2( svn::RevisionPtr );
  void setRecursive( bool );
  void setCopies( bool );
  void setForce( bool );
  void setPegMerge( bool );
  void setDefaultTarget( const sc::String& );
  void setTarget( const sc::String& );
  void addTarget( const sc::String& );

private:
  svn::RevisionPtr calcPegRev();

  ScModel*            _model;
  bool                _changePathOrUrl1;
  bool                _changePathOrUrl2;
  bool                _changeType;

  // state
  sc::String          _pathOrUrl1;
  sc::String          _pathOrUrl2;
  svn::RevisionPtr    _revPeg;
  svn::RevisionPtr    _rev1;
  svn::RevisionPtr    _rev2;
  bool                _recursive;
  bool                _copies;
  bool                _force;
  bool                _pegMerge;
  svn::Paths          _targets;
  sc::String          _target;
  sc::String          _targetDefault;
};

#endif // _SC_MERGEVIEWMODEL_H
