/* ====================================================================
 * Copyright (c) 2009       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _ASSERTIONTRAIT_QMODELINDEX_H
#define _ASSERTIONTRAIT_QMODELINDEX_H

// sc
#include "util/uuid.h"
#include "util/String.h"

// qt
#include <QtCore/QModelIndex>


/** This adds QModelIndex support to CPPUNIT_ASSERT_EQUALS. */
template<> struct CPPUNIT_NS::assertion_traits<QModelIndex>
{
  static bool equal( const QModelIndex& x, const QModelIndex& y )
  {
    return x == y;
  }

  static std::string toString( const QModelIndex& idx )
  {
    OStringStream ost;
    ost << "\"";
    if(idx.isValid()) {
      ost << "r(" << idx.row() << ")/c(" << idx.column() << ")";
    }
    else {
      ost << "<invalid>";
    }
    ost << "\"";
    return ost.str();
  }
};


#endif // _ASSERTIONTRAIT_QMODELINDEX_H
