#include <gio/gio.h>

#if defined (__ELF__) && ( __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 6))
# define SECTION __attribute__ ((section (".gresource.thunar"), aligned (8)))
#else
# define SECTION
#endif

static const SECTION union { const guint8 data[759]; const double alignment; void * const ptr;}  thunar_resource_data = { {
  0x47, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x18, 0x00, 0x00, 0x00, 0xac, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x28, 0x05, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
  0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
  0x04, 0x00, 0x00, 0x00, 0xa1, 0x19, 0x28, 0xae, 
  0x03, 0x00, 0x00, 0x00, 0xac, 0x00, 0x00, 0x00, 
  0x07, 0x00, 0x4c, 0x00, 0xb4, 0x00, 0x00, 0x00, 
  0xb8, 0x00, 0x00, 0x00, 0xd4, 0xb5, 0x02, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xb8, 0x00, 0x00, 0x00, 
  0x01, 0x00, 0x4c, 0x00, 0xbc, 0x00, 0x00, 0x00, 
  0xc0, 0x00, 0x00, 0x00, 0x4b, 0x50, 0x90, 0x0b, 
  0x01, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 
  0x04, 0x00, 0x4c, 0x00, 0xc4, 0x00, 0x00, 0x00, 
  0xc8, 0x00, 0x00, 0x00, 0xa0, 0x54, 0xea, 0x19, 
  0x02, 0x00, 0x00, 0x00, 0xc8, 0x00, 0x00, 0x00, 
  0x05, 0x00, 0x4c, 0x00, 0xd0, 0x00, 0x00, 0x00, 
  0xd4, 0x00, 0x00, 0x00, 0xb0, 0xdd, 0x71, 0x77, 
  0x00, 0x00, 0x00, 0x00, 0xd4, 0x00, 0x00, 0x00, 
  0x13, 0x00, 0x76, 0x00, 0xe8, 0x00, 0x00, 0x00, 
  0xf7, 0x02, 0x00, 0x00, 0x74, 0x68, 0x75, 0x6e, 
  0x61, 0x72, 0x2f, 0x00, 0x04, 0x00, 0x00, 0x00, 
  0x2f, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
  0x6f, 0x72, 0x67, 0x2f, 0x03, 0x00, 0x00, 0x00, 
  0x78, 0x66, 0x63, 0x65, 0x2f, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x74, 0x68, 0x75, 0x6d, 
  0x62, 0x6e, 0x61, 0x69, 0x6c, 0x2d, 0x66, 0x72, 
  0x61, 0x6d, 0x65, 0x2e, 0x70, 0x6e, 0x67, 0x00, 
  0x4d, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
  0x78, 0xda, 0xeb, 0x0c, 0xf0, 0x73, 0xe7, 0xe5, 
  0x92, 0xe2, 0x62, 0x60, 0x60, 0xe0, 0xf5, 0xf4, 
  0x70, 0x09, 0x02, 0xd2, 0x0e, 0x20, 0xcc, 0xc1, 
  0x0c, 0x24, 0xe7, 0x6e, 0x6f, 0x7c, 0x03, 0xa4, 
  0x38, 0x0b, 0x3c, 0x22, 0x8b, 0x19, 0x18, 0xb8, 
  0x85, 0x41, 0x98, 0x91, 0x61, 0xd6, 0x1c, 0x09, 
  0xa0, 0x20, 0x7b, 0x89, 0xa7, 0xaf, 0x2b, 0xfb, 
  0x1d, 0x1e, 0x71, 0x46, 0x16, 0xd9, 0xe5, 0xfb, 
  0xcc, 0x2d, 0x81, 0x42, 0x1e, 0x01, 0x3e, 0x21, 
  0xae, 0x0c, 0x94, 0x81, 0xf0, 0x08, 0xff, 0x07, 
  0x0f, 0xaf, 0xfc, 0xff, 0xff, 0x5f, 0xd9, 0x7f, 
  0xc2, 0x37, 0x20, 0x5f, 0xb4, 0x24, 0xc8, 0x2f, 
  0x98, 0x81, 0x91, 0x89, 0x99, 0x85, 0x8d, 0x9b, 
  0x8f, 0x5f, 0x50, 0x48, 0x5a, 0x49, 0x45, 0x43, 
  0x53, 0x4b, 0xcf, 0xd6, 0xd5, 0xc3, 0xfa, 0x88, 
  0xb1, 0x0a, 0x50, 0x01, 0x63, 0x92, 0xb7, 0xbb, 
  0x8b, 0x38, 0xf7, 0xb5, 0x19, 0xfd, 0x40, 0x4e, 
  0x96, 0xa7, 0x8b, 0x63, 0x48, 0xc4, 0xe1, 0xb7, 
  0xd7, 0xad, 0xc5, 0x1a, 0x14, 0x78, 0x5c, 0x2e, 
  0x6a, 0x08, 0x1c, 0xf8, 0x20, 0x18, 0xf0, 0x7d, 
  0x7f, 0x88, 0x74, 0xff, 0xde, 0x85, 0x1b, 0x67, 
  0x6c, 0x6f, 0xa8, 0x5e, 0x26, 0xbb, 0xe8, 0xa7, 
  0x5f, 0x2d, 0x7f, 0x41, 0x66, 0x35, 0xe3, 0xd3, 
  0x12, 0x54, 0xab, 0x3f, 0xd4, 0x37, 0xa4, 0x3e, 
  0x32, 0xe7, 0x8a, 0xfe, 0x94, 0xf9, 0x68, 0xa7, 
  0x5a, 0x7e, 0xe7, 0xd2, 0xaf, 0x85, 0x19, 0x52, 
  0x7b, 0x39, 0xa5, 0x8b, 0x1c, 0x8b, 0x56, 0xfe, 
  0xfe, 0x9e, 0x75, 0x52, 0xe8, 0x8e, 0xd7, 0xb1, 
  0xc2, 0x8e, 0xd9, 0xcb, 0x24, 0x6e, 0xcc, 0x6c, 
  0x4d, 0xdb, 0xcd, 0xb8, 0xe2, 0xa1, 0x61, 0xa8, 
  0xa3, 0x46, 0xc4, 0x7c, 0x90, 0x4e, 0x4f, 0x57, 
  0x3f, 0x97, 0x75, 0x4e, 0x09, 0x4d, 0x00, 0x0a, 
  0xc1, 0x53, 0xbc, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x28, 0x75, 0x75, 0x61, 0x79, 0x29
} };

static GStaticResource static_resource = { thunar_resource_data.data, sizeof (thunar_resource_data.data), NULL, NULL, NULL };
extern GResource *thunar_get_resource (void);
GResource *thunar_get_resource (void)
{
  return g_static_resource_get_resource (&static_resource);
}
/*
  If G_HAS_CONSTRUCTORS is true then the compiler support *both* constructors and
  destructors, in a sane way, including e.g. on library unload. If not you're on
  your own.

  Some compilers need #pragma to handle this, which does not work with macros,
  so the way you need to use this is (for constructors):

  #ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
  #pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(my_constructor)
  #endif
  G_DEFINE_CONSTRUCTOR(my_constructor)
  static void my_constructor(void) {
   ...
  }

*/

#ifndef __GTK_DOC_IGNORE__

#if  __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 7)

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR(_func) static void __attribute__((constructor)) _func (void);
#define G_DEFINE_DESTRUCTOR(_func) static void __attribute__((destructor)) _func (void);

#elif defined (_MSC_VER) && (_MSC_VER >= 1500)
/* Visual studio 2008 and later has _Pragma */

#define G_HAS_CONSTRUCTORS 1

/* We do some weird things to avoid the constructors being optimized
 * away on VS2015 if WholeProgramOptimization is enabled. First we
 * make a reference to the array from the wrapper to make sure its
 * references. Then we use a pragma to make sure the wrapper function
 * symbol is always included at the link stage. Also, the symbols
 * need to be extern (but not dllexport), even though they are not
 * really used from another object file.
 */

/* We need to account for differences between the mangling of symbols
 * for Win32 (x86) and x64 programs, as symbols on Win32 are prefixed
 * with an underscore but symbols on x64 are not.
 */
#ifdef _WIN64
#define G_MSVC_SYMBOL_PREFIX ""
#else
#define G_MSVC_SYMBOL_PREFIX "_"
#endif

#define G_DEFINE_CONSTRUCTOR(_func) G_MSVC_CTOR (_func, G_MSVC_SYMBOL_PREFIX)
#define G_DEFINE_DESTRUCTOR(_func) G_MSVC_DTOR (_func, G_MSVC_SYMBOL_PREFIX)

#define G_MSVC_CTOR(_func,_sym_prefix) \
  static void _func(void); \
  extern int (* _array ## _func)(void);              \
  int _func ## _wrapper(void) { _func(); g_slist_find (NULL,  _array ## _func); return 0; } \
  __pragma(comment(linker,"/include:" _sym_prefix # _func "_wrapper")) \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) int (* _array ## _func)(void) = _func ## _wrapper;

#define G_MSVC_DTOR(_func,_sym_prefix) \
  static void _func(void); \
  extern int (* _array ## _func)(void);              \
  int _func ## _constructor(void) { atexit (_func); g_slist_find (NULL,  _array ## _func); return 0; } \
   __pragma(comment(linker,"/include:" _sym_prefix # _func "_constructor")) \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) int (* _array ## _func)(void) = _func ## _constructor;

#elif defined (_MSC_VER)

#define G_HAS_CONSTRUCTORS 1

/* Pre Visual studio 2008 must use #pragma section */
#define G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA 1
#define G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA 1

#define G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(_func) \
  section(".CRT$XCU",read)
#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void); \
  static int _func ## _wrapper(void) { _func(); return 0; } \
  __declspec(allocate(".CRT$XCU")) static int (*p)(void) = _func ## _wrapper;

#define G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(_func) \
  section(".CRT$XCU",read)
#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void); \
  static int _func ## _constructor(void) { atexit (_func); return 0; } \
  __declspec(allocate(".CRT$XCU")) static int (* _array ## _func)(void) = _func ## _constructor;

#elif defined(__SUNPRO_C)

/* This is not tested, but i believe it should work, based on:
 * http://opensource.apple.com/source/OpenSSL098/OpenSSL098-35/src/fips/fips_premain.c
 */

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA 1
#define G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA 1

#define G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(_func) \
  init(_func)
#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void);

#define G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(_func) \
  fini(_func)
#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void);

#else

/* constructors not supported for this compiler */

#endif

#endif /* __GTK_DOC_IGNORE__ */

#ifdef G_HAS_CONSTRUCTORS

#ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(resource_constructor)
#endif
G_DEFINE_CONSTRUCTOR(resource_constructor)
#ifdef G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(resource_destructor)
#endif
G_DEFINE_DESTRUCTOR(resource_destructor)

#else
#warning "Constructor not supported on this compiler, linking in resources will not work"
#endif

static void resource_constructor (void)
{
  g_static_resource_init (&static_resource);
}

static void resource_destructor (void)
{
  g_static_resource_fini (&static_resource);
}
