/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the XMPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * XMPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: nodeslist.cc,v 1.5 2003/08/23 13:45:02 jsquyres Exp $
 *
 *	Function:	- retrieve hostnames from LAM nx nomenclature
 */

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <args.h>
#include <dl_inet.h>
#include <portable.h>
#include <priority.h>
#include <terror.h>
#include <rreq.h>

#include <string>

#include "xmpi/xmpi_error.h"
#include "xmpi/xmpi_sys.h"

using namespace std;

/*
 * Local variables
 */
static char		name[1024];
static int4		nlinks;
static struct dolink	*links;

extern int local_initialize();

static void
nodename(int node, int want_name)
{
    struct hostent *hent;

    if (node < 0 || node >= nlinks
	    || links[node].dol_link == NOTLINKID) {
	strcpy(name, "invalid node");
    } else {
	hent = gethostbyaddr((char *)&links[node].dol_addr.sin_addr,
			sizeof(struct in_addr), AF_INET);
	if (hent && want_name)
	    strncpy(name, hent->h_name, sizeof(name));
	else
	    sprintf(name, "%s", inet_ntoa(links[node].dol_addr.sin_addr));
    }

    endhostent();
}


int
get_node_names(char ***nodes_list, int *nodes_list_length)
{
  int4 node;
  int *pnodes;
  struct route r;
  int count = 0;
  
  if( local_initialize())
    return LAMERROR;

  if (ldogetlinks(&links, &nlinks))
    lamfail((char*)"lamnodes (ldogetlinks)");
  
  pnodes = (int4 *) malloc((unsigned) (nlinks * sizeof(int4)));
  if (pnodes == 0) 
    lamfail((char*)"lamnodes (malloc)");
  
  if (getnodes(pnodes, nlinks, 0, NT_CAST)) 
    lamfail((char*)"lamnodes (getnodes)");
  
  // This may have to get larger.  Start with the base, which is the
  // number of nodes we have...
  *nodes_list = (char **) malloc(nlinks * sizeof(char*));
  if (*nodes_list == 0)
    lamfail((char*)"lamnodes (malloc)");
  *nodes_list_length = nlinks;
  
  for (node = 0; node < nlinks; node++) {
    nodename(node, 1);
    r.r_nodeid = getnodeid();
    getrent(&r);
    
    // If r_ncpus is greater than 1, we need more space ;-(
    if (r.r_ncpus > 1) {
      *nodes_list_length = *nodes_list_length + r.r_ncpus - 1;
      *nodes_list = (char **) realloc((void *) *nodes_list, 
				      *nodes_list_length * sizeof(char*));
      if (*nodes_list == 0)
	lamfail((char*)"nodelist (realloc)");
    }

    // time to grab some memory for the name stuff....
    // 5 -> number, 1 -> p, 1-> \0, 3 -> spaces 5-> (cpu numb)
    for (int i = 0 ; i < r.r_ncpus ; ++i) {
      (*nodes_list)[count] = (char*) malloc(sizeof(char) * 
					    (strlen(name) + 15 +
					     sizeof(int) * 8));
      
      if ((*nodes_list)[count] == 0)
	lamfail((char*)"lamnodes (malloc)");
      
      sprintf((*nodes_list)[count], "c%-3d %s (cpu %d)", count, name, i);
    ++count;
    }
  }
  
  free(pnodes);
  
  return 0;
}


int 
get_nodes_list(xmpi_node* nodes, int nodes_length, char** output)
{
  if (nodes_length < 2)
    return LAMERROR;

  // special cases...  The ALL NODES or LOCAL NODES is selected...
  if (nodes[0].selected != 0) {
    *output = strdup("C");
    return 0;
  }
  if (nodes[1].selected != 0) {
    *output = strdup("h");
    return 0;
  }

  // now build up the fun nodes...
  string tmp;
  // STUPID G++ NOT HAVING STRING STREAMS
  char* number;
  number = (char*) malloc(sizeof(char) * (sizeof(int) * 8 + 1));
  if (number == 0) {
    return LAMERROR;
  }

  int j;
  for (int i = 2 ; i < nodes_length ; ++i) {
    if (nodes[i].selected != 0) {
      sprintf(number, "%d", i - 2);
      tmp = tmp + "c" + number;
      for (j = i + 1 ; j < nodes_length && nodes[j].selected != 0 ; ++j);
      if (i + 1 == j)
	tmp = tmp + " ";
      else {
	sprintf(number, "%d", j - 3);
	tmp = tmp + "-" + number + " ";
	i = j;
      }
    }
  }

  // it is possible that there will be a trailing space.  Remove.
  if (*(tmp.end()) == ' ')
    tmp.erase(tmp.end());

  *output = (char*) malloc(sizeof(char) * (tmp.size() + 1));
  if (*output == 0) {
    return LAMERROR;
  }
  strcpy(*output, tmp.c_str());

  return 0;
}


// fill_nodes()
// 
// DESCRIPTION: takes a list of nodes from the aschema and filles in
// the xmpi_nodes structure.
//
// INPUT: nodes_list  a LIST from the aschema struct of all nodes that
//                    should be selected.
// 
// OUTPUT: nodes        xmpi_node list of all nodes lambooted
//         nodes_length number of structs in the xmpi_node array
// 
// RETURNS 0 -> SUCCESS
//         LAMERROR -> failure
//
int
fill_nodes(LIST* nodes_list, xmpi_node** nodes, int* nodes_length)
{
  ndi* node_desc;

  // clear all the nodes...
  for (int i = 0 ; i < *nodes_length ; ++i)
    (*nodes)[i].selected = 0;

  for (node_desc = (struct ndi*) al_top(nodes_list); 
       node_desc; 
       node_desc = (struct ndi*) al_next(nodes_list, node_desc)) {
    if (node_desc->ndi_node == LOCAL) {
      (*nodes)[1].selected = 1;
      return 0;
    } else if (node_desc->ndi_node == LAM_HOST2COMP) {
      (*nodes)[0].selected = 1;
      return 0;
    } else
      (*nodes)[node_desc->ndi_node+2].selected = 1;
  }
  
  return 0;
}
