/*
   wml-tools 

   Copyright (C) 1999 Thomas Neill (tneill@pwot.co.uk)

   This file is part of the wml-tools package and it's usage is subject
   to the terms and conditions as given in the license. See the file
   LICENSE in the root directory of the distribution for details.
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <tree.h>
#include <parser.h>

#ifdef CGI_BIN
void wmlError(char *error)
{
	puts("<?xml version=\"1.0\"?>");
	puts("<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\" \"http://www.wapforum.org/DTD/wml_1.1.xml\">");
	puts("<wml>");
	puts("  <template>");
	puts("    <do type=\"accept\" label=\"Back\">");
	puts("      <prev/>");
	puts("    </do>");
	puts("  </template>");
	puts("  <card id=\"init\" title=\"Error\">");
	printf("    <p>%s</p>\n", error);
	puts("  </card>");
	puts("</wml>");
}
#endif /* CGI_BIN */

void outputString(char *str)
{
	while(*str != '\0') {
		switch(*str) {
			case '$':
				printf("$$");
				break;
			case '<':
				printf("&lt;");
				break;
			case '>':
				printf("&gt;");
				break;
			default:
				putchar(*str);
				break;
		}
		str++;
	}
}

void parseChannel(xmlNodePtr channel)
{
	xmlNodePtr node, on;

	for(node = channel; node != NULL; node = node->next) {
		if(strcasecmp("title", node->name) == 0) {
			on = node->childs;
			if(strcasecmp("text", on->name) == 0)
				printf("    <p><b>%s</b></p>\n", on->content);
		}
	}
}

void parseHeadline(xmlNodePtr item)
{
	xmlNodePtr node, on;

	for(node = item; node != NULL; node = node->next) {
		if(strcasecmp("title", node->name) == 0) {
			on = node->childs;
			if(strcasecmp("text", on->name) == 0)
				printf("    <p align=\"center\">----</p>\n");
				printf("    <p>");
				outputString(on->content);
				printf("</p>\n");
		}
	}

}

void parseRdf(xmlNodePtr rdf)
{
	xmlNodePtr node;

	puts("<?xml version=\"1.0\"?>");
	puts("<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\" \"http://www.wapforum.org/DTD/wml_1.1.xml\">");
	puts("<wml>");
	puts("  <template>");
	puts("    <do type=\"accept\" label=\"Back\">");
	puts("      <prev/>");
	puts("    </do>");
	puts("  </template>");
	puts("  <card id=\"init\" title=\"Headlines\">");

	for(node = rdf->childs; node != NULL; node = node->next) {
		if(strcasecmp("channel", node->name) == 0)
			parseChannel(node->childs);
		else if(strcasecmp("item", node->name) == 0)
			parseHeadline(node->childs);
	}

	puts("  </card>");
	puts("</wml>");
}

int main(int argc, char **argv)
{
	xmlDocPtr rdf;
	char *filename;
#ifdef CGI_BIN

	printf("Content-type: text/vnd.wap.wml\n\n");

	if(!(filename = getenv("QUERY_STRING"))) {
		wmlError("No channel file requested.");
		exit(0);
	}

	if(strchr(filename, '/') || strchr(filename, '%')) {
		wmlError("No channel file requested.");
		exit(0);
	}
#else
	if(argc != 2) {
		fprintf(stderr, "Usage: %s file.rdf\n", argv[0]);
		exit(1);
	}

	filename = argv[1];
#endif /* CGI_BIN */

	rdf = xmlParseFile(filename);
	if(!rdf) {
#ifdef CGI_BIN
		wmlError("Error parsing channel file.");
		exit(0);
#else
		fprintf(stderr, "Couldn't parse %s as a valid XML document\n", argv[1]);
		exit(1);
#endif /* CGI_BIN */
	}

	parseRdf(rdf->root);

	exit(0);
}
