"use strict";

exports.__esModule = true;
exports.keyMap = exports.getNodeType = void 0;
var _apidomCore = require("@swagger-api/apidom-core");
// getNodeType :: Node -> String
const getNodeType = element => {
  if (!(0, _apidomCore.isElement)(element)) {
    return undefined;
  }
  return `${element.element.charAt(0).toUpperCase() + element.element.slice(1)}Element`;
};

/**
 * Workflows Specification 1.0.0
 */
exports.getNodeType = getNodeType;
const keyMap = exports.keyMap = {
  WorkflowsSpecification1Element: ['content'],
  InfoElement: ['content'],
  SourceDescriptionElement: ['content'],
  WorkflowElement: ['content'],
  StepElement: ['content'],
  ParameterElement: ['content'],
  SuccessActionElement: ['content'],
  FailureActionElement: ['content'],
  ComponentsElement: ['content'],
  CriterionElement: ['content'],
  ReferenceElement: ['content'],
  JSONSchemaDraft202012Element: ['content'],
  ..._apidomCore.keyMap
};