// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package prefilter

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	stderrors "errors"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/cilium/cilium/api/v1/models"
)

// GetPrefilterReader is a Reader for the GetPrefilter structure.
type GetPrefilterReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetPrefilterReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (any, error) {
	switch response.Code() {
	case 200:
		result := NewGetPrefilterOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 500:
		result := NewGetPrefilterFailure()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /prefilter] GetPrefilter", response, response.Code())
	}
}

// NewGetPrefilterOK creates a GetPrefilterOK with default headers values
func NewGetPrefilterOK() *GetPrefilterOK {
	return &GetPrefilterOK{}
}

/*
GetPrefilterOK describes a response with status code 200, with default header values.

Success
*/
type GetPrefilterOK struct {
	Payload *models.Prefilter
}

// IsSuccess returns true when this get prefilter o k response has a 2xx status code
func (o *GetPrefilterOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get prefilter o k response has a 3xx status code
func (o *GetPrefilterOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get prefilter o k response has a 4xx status code
func (o *GetPrefilterOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get prefilter o k response has a 5xx status code
func (o *GetPrefilterOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get prefilter o k response a status code equal to that given
func (o *GetPrefilterOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get prefilter o k response
func (o *GetPrefilterOK) Code() int {
	return 200
}

func (o *GetPrefilterOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /prefilter][%d] getPrefilterOK %s", 200, payload)
}

func (o *GetPrefilterOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /prefilter][%d] getPrefilterOK %s", 200, payload)
}

func (o *GetPrefilterOK) GetPayload() *models.Prefilter {
	return o.Payload
}

func (o *GetPrefilterOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Prefilter)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && !stderrors.Is(err, io.EOF) {
		return err
	}

	return nil
}

// NewGetPrefilterFailure creates a GetPrefilterFailure with default headers values
func NewGetPrefilterFailure() *GetPrefilterFailure {
	return &GetPrefilterFailure{}
}

/*
GetPrefilterFailure describes a response with status code 500, with default header values.

Prefilter get failed
*/
type GetPrefilterFailure struct {
	Payload models.Error
}

// IsSuccess returns true when this get prefilter failure response has a 2xx status code
func (o *GetPrefilterFailure) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get prefilter failure response has a 3xx status code
func (o *GetPrefilterFailure) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get prefilter failure response has a 4xx status code
func (o *GetPrefilterFailure) IsClientError() bool {
	return false
}

// IsServerError returns true when this get prefilter failure response has a 5xx status code
func (o *GetPrefilterFailure) IsServerError() bool {
	return true
}

// IsCode returns true when this get prefilter failure response a status code equal to that given
func (o *GetPrefilterFailure) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get prefilter failure response
func (o *GetPrefilterFailure) Code() int {
	return 500
}

func (o *GetPrefilterFailure) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /prefilter][%d] getPrefilterFailure %s", 500, payload)
}

func (o *GetPrefilterFailure) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /prefilter][%d] getPrefilterFailure %s", 500, payload)
}

func (o *GetPrefilterFailure) GetPayload() models.Error {
	return o.Payload
}

func (o *GetPrefilterFailure) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && !stderrors.Is(err, io.EOF) {
		return err
	}

	return nil
}
