/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha2

import (
	context "context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	apisv1alpha2 "sigs.k8s.io/network-policy-api/apis/v1alpha2"
	applyconfigurationapisv1alpha2 "sigs.k8s.io/network-policy-api/pkg/client/applyconfiguration/apis/v1alpha2"
	scheme "sigs.k8s.io/network-policy-api/pkg/client/clientset/versioned/scheme"
)

// ClusterNetworkPoliciesGetter has a method to return a ClusterNetworkPolicyInterface.
// A group's client should implement this interface.
type ClusterNetworkPoliciesGetter interface {
	ClusterNetworkPolicies() ClusterNetworkPolicyInterface
}

// ClusterNetworkPolicyInterface has methods to work with ClusterNetworkPolicy resources.
type ClusterNetworkPolicyInterface interface {
	Create(ctx context.Context, clusterNetworkPolicy *apisv1alpha2.ClusterNetworkPolicy, opts v1.CreateOptions) (*apisv1alpha2.ClusterNetworkPolicy, error)
	Update(ctx context.Context, clusterNetworkPolicy *apisv1alpha2.ClusterNetworkPolicy, opts v1.UpdateOptions) (*apisv1alpha2.ClusterNetworkPolicy, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, clusterNetworkPolicy *apisv1alpha2.ClusterNetworkPolicy, opts v1.UpdateOptions) (*apisv1alpha2.ClusterNetworkPolicy, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*apisv1alpha2.ClusterNetworkPolicy, error)
	List(ctx context.Context, opts v1.ListOptions) (*apisv1alpha2.ClusterNetworkPolicyList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *apisv1alpha2.ClusterNetworkPolicy, err error)
	Apply(ctx context.Context, clusterNetworkPolicy *applyconfigurationapisv1alpha2.ClusterNetworkPolicyApplyConfiguration, opts v1.ApplyOptions) (result *apisv1alpha2.ClusterNetworkPolicy, err error)
	// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
	ApplyStatus(ctx context.Context, clusterNetworkPolicy *applyconfigurationapisv1alpha2.ClusterNetworkPolicyApplyConfiguration, opts v1.ApplyOptions) (result *apisv1alpha2.ClusterNetworkPolicy, err error)
	ClusterNetworkPolicyExpansion
}

// clusterNetworkPolicies implements ClusterNetworkPolicyInterface
type clusterNetworkPolicies struct {
	*gentype.ClientWithListAndApply[*apisv1alpha2.ClusterNetworkPolicy, *apisv1alpha2.ClusterNetworkPolicyList, *applyconfigurationapisv1alpha2.ClusterNetworkPolicyApplyConfiguration]
}

// newClusterNetworkPolicies returns a ClusterNetworkPolicies
func newClusterNetworkPolicies(c *PolicyV1alpha2Client) *clusterNetworkPolicies {
	return &clusterNetworkPolicies{
		gentype.NewClientWithListAndApply[*apisv1alpha2.ClusterNetworkPolicy, *apisv1alpha2.ClusterNetworkPolicyList, *applyconfigurationapisv1alpha2.ClusterNetworkPolicyApplyConfiguration](
			"clusternetworkpolicies",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *apisv1alpha2.ClusterNetworkPolicy { return &apisv1alpha2.ClusterNetworkPolicy{} },
			func() *apisv1alpha2.ClusterNetworkPolicyList { return &apisv1alpha2.ClusterNetworkPolicyList{} },
		),
	}
}
