#include "gtest/gtest.h"

#include <ciphey/swig.hpp>
#include "common.hpp"

struct xorcrypt_test_elem {
  ciphey::bytes_t ctext, ptext;
  ciphey::xorcrypt::key_t key;
};

static std::vector<xorcrypt_test_elem> xorcrypt_tests {
  {
    {
      0x0a, 0x1d, 0x54, 0x0e, 0x02, 0x1a, 0x54, 0x0d, 0x0b, 0x0c, 0x54, 0x1d,
      0x0c, 0x1f, 0x11, 0x0b, 0x43, 0x1b, 0x1b, 0x18, 0x07, 0x49, 0x00, 0x11,
      0x02, 0x1d, 0x54, 0x15, 0x02, 0x10, 0x58, 0x59, 0x0c, 0x07, 0x54, 0x18,
      0x43, 0x0f, 0x06, 0x10, 0x07, 0x08, 0x0d, 0x59, 0x0d, 0x00, 0x13, 0x11,
      0x17, 0x49, 0x18, 0x18, 0x17, 0x0c, 0x54, 0x10, 0x0d, 0x49, 0x1a, 0x16,
      0x15, 0x0c, 0x19, 0x1b, 0x06, 0x1b, 0x58, 0x59, 0x01, 0x0c, 0x12, 0x16,
      0x11, 0x0c, 0x54, 0x0d, 0x0b, 0x0c, 0x54, 0x1f, 0x0a, 0x1b, 0x07, 0x0d,
      0x43, 0x06, 0x12, 0x59, 0x17, 0x01, 0x11, 0x59, 0x13, 0x0c, 0x06, 0x0a,
      0x0c, 0x07, 0x07, 0x59, 0x14, 0x00, 0x00, 0x11, 0x43, 0x1e, 0x1c, 0x16,
      0x0e, 0x49, 0x00, 0x11, 0x0a, 0x1a, 0x54, 0x11, 0x0a, 0x1a, 0x00, 0x16,
      0x11, 0x10, 0x54, 0x11, 0x02, 0x1a, 0x54, 0x1b, 0x16, 0x1a, 0x1d, 0x17,
      0x06, 0x1a, 0x07, 0x57
    },
    {
      0x69, 0x74, 0x20, 0x77, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x64,
      0x6f, 0x76, 0x65, 0x72, 0x20, 0x72, 0x6f, 0x61, 0x64, 0x20, 0x74, 0x68,
      0x61, 0x74, 0x20, 0x6c, 0x61, 0x79, 0x2c, 0x20, 0x6f, 0x6e, 0x20, 0x61,
      0x20, 0x66, 0x72, 0x69, 0x64, 0x61, 0x79, 0x20, 0x6e, 0x69, 0x67, 0x68,
      0x74, 0x20, 0x6c, 0x61, 0x74, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x6e, 0x6f,
      0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x2c, 0x20, 0x62, 0x65, 0x66, 0x6f,
      0x72, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x66, 0x69, 0x72, 0x73, 0x74,
      0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x65, 0x72, 0x73,
      0x6f, 0x6e, 0x73, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x77, 0x68, 0x6f,
      0x6d, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x68, 0x69, 0x73, 0x74, 0x6f,
      0x72, 0x79, 0x20, 0x68, 0x61, 0x73, 0x20, 0x62, 0x75, 0x73, 0x69, 0x6e,
      0x65, 0x73, 0x73, 0x2e
    },
    {'c', 'i', 't', 'y'}
  },
  {
    {
      0x1d, 0x42, 0x1f, 0x4d, 0x0b, 0x0f, 0x02, 0x1f, 0x4f, 0x13, 0x4e, 0x3c,
      0x1a, 0x69, 0x65, 0x1f, 0x49, 0x1c, 0x0e, 0x4e, 0x13, 0x01, 0x0b, 0x07,
      0x4e, 0x1b, 0x01, 0x16, 0x45, 0x36, 0x00, 0x1e, 0x01, 0x49, 0x64, 0x20,
      0x54, 0x1d, 0x1d, 0x43, 0x33, 0x53, 0x4e, 0x65, 0x52, 0x06, 0x00, 0x47,
      0x54, 0x1c, 0x0d, 0x45, 0x4d, 0x07, 0x04, 0x0c, 0x53, 0x12, 0x3c, 0x0c,
      0x1e, 0x08, 0x49, 0x1a, 0x09, 0x11, 0x4f, 0x14, 0x4c, 0x21, 0x1a, 0x47,
      0x2b, 0x00, 0x05, 0x1d, 0x47, 0x59, 0x11, 0x04, 0x09, 0x00, 0x64, 0x26,
      0x07, 0x53, 0x00, 0x37, 0x16, 0x06, 0x0c, 0x1a, 0x17, 0x41, 0x1d, 0x01,
      0x52, 0x54, 0x30, 0x5f, 0x00, 0x20, 0x13, 0x0a, 0x05, 0x47, 0x4f, 0x12,
      0x48, 0x08, 0x45, 0x4e, 0x65, 0x3e, 0x16, 0x09, 0x38, 0x45, 0x06, 0x05,
      0x08, 0x1a, 0x46, 0x07, 0x4f, 0x1f, 0x59, 0x78, 0x7e, 0x6a, 0x62, 0x36,
      0x0c, 0x1d, 0x0f, 0x41, 0x0d, 0x48, 0x06, 0x55, 0x1a, 0x1b, 0x00, 0x1d,
      0x42, 0x74, 0x04, 0x1e, 0x01, 0x49, 0x1a, 0x09, 0x11, 0x02, 0x52, 0x7a,
      0x7f, 0x49, 0x00, 0x48, 0x3a, 0x00, 0x1a, 0x13, 0x49, 0x1a, 0x4f, 0x45,
      0x48, 0x0f, 0x1d, 0x0d, 0x53, 0x04, 0x3a, 0x01, 0x52, 0x19, 0x01, 0x0b,
      0x41, 0x13, 0x06, 0x00, 0x4c, 0x31, 0x5f, 0x53, 0x62, 0x15, 0x06, 0x07,
      0x09, 0x07, 0x54, 0x0b, 0x17, 0x41, 0x14, 0x16, 0x49, 0x79, 0x33, 0x35,
      0x0b, 0x1b, 0x01, 0x05, 0x0f, 0x46, 0x07, 0x4f, 0x1d, 0x4e, 0x78, 0x4e,
      0x48, 0x27, 0x52, 0x04, 0x07, 0x0c, 0x45, 0x58, 0x48, 0x08, 0x41, 0x00,
      0x4f, 0x20, 0x54, 0x08, 0x74, 0x0b, 0x1d, 0x19, 0x49, 0x02, 0x00, 0x0e,
      0x16, 0x5c, 0x00, 0x52, 0x30, 0x69, 0x65, 0x1f, 0x49, 0x02, 0x02, 0x54,
      0x00, 0x01, 0x0b, 0x07, 0x4e, 0x02, 0x10, 0x53, 0x01, 0x26, 0x10, 0x15,
      0x4d, 0x02, 0x07, 0x02, 0x1f, 0x4f, 0x1b, 0x4e, 0x78, 0x30, 0x69, 0x36,
      0x52, 0x0a, 0x01, 0x09, 0x54, 0x06, 0x07, 0x09, 0x53, 0x4e, 0x02, 0x10,
      0x53, 0x08, 0x3b, 0x10, 0x06, 0x05, 0x49, 0x0f, 0x0f, 0x10, 0x4f, 0x3b,
      0x00, 0x3a, 0x5f, 0x47, 0x2b, 0x1c, 0x49, 0x64, 0x33, 0x4f, 0x54, 0x02,
      0x10, 0x53, 0x1a, 0x4f, 0x05, 0x16, 0x11, 0x74, 0x0c, 0x06, 0x4d, 0x0f,
      0x02, 0x0e, 0x03, 0x43, 0x52, 0x4c, 0x3d, 0x4e, 0x00, 0x2f, 0x0b, 0x49,
      0x0d, 0x08, 0x4e, 0x17, 0x0d, 0x15, 0x54, 0x1d, 0x4f, 0x0e, 0x1c, 0x45,
      0x5e, 0x28, 0x0b, 0x4d, 0x19, 0x01, 0x12, 0x07, 0x0a, 0x55, 0x53, 0x78,
      0x4e, 0x4f, 0x62, 0x06, 0x01, 0x0b, 0x47, 0x53, 0x1d, 0x0c, 0x00, 0x00,
      0x17, 0x0a, 0x05, 0x1f, 0x0c, 0x3a, 0x42, 0x5e, 0x4d, 0x2e, 0x01, 0x41,
      0x22, 0x0e, 0x1c, 0x49, 0x34, 0x56, 0x41, 0x62, 0x35, 0x06, 0x4f, 0x47,
      0x2a, 0x7e, 0x3b, 0x08, 0x4f, 0x01, 0x1b, 0x01, 0x53, 0x42, 0x37, 0x04,
      0x07, 0x1e, 0x0c, 0x4e, 0x15, 0x1c, 0x0e, 0x06, 0x07, 0x2b, 0x1a, 0x54,
      0x2a, 0x17, 0x49, 0x19, 0x06, 0x59, 0x54, 0x21, 0x45, 0x57, 0x07, 0x03,
      0x05, 0x53, 0x07, 0x31, 0x45, 0x78, 0x2c, 0x07, 0x0a, 0x41, 0x1d, 0x09,
      0x52, 0x59, 0x37, 0x4f, 0x00, 0x26, 0x1d, 0x07, 0x49, 0x13, 0x00, 0x13,
      0x01, 0x13, 0x45, 0x4e, 0x0e, 0x49, 0x17, 0x04, 0x39, 0x0b, 0x5e, 0x4d,
      0x1d, 0x06, 0x04, 0x1a, 0x4f, 0x78, 0x77, 0x30, 0x43, 0x00, 0x3b, 0x1d,
      0x1c, 0x4e, 0x14, 0x54, 0x15, 0x1a, 0x0c, 0x4e, 0x49, 0x4f, 0x08, 0x07,
      0x45, 0x39, 0x00, 0x52, 0x67, 0x3a, 0x01, 0x41, 0x13, 0x0a, 0x06, 0x00,
      0x37, 0x5c, 0x46, 0x62, 0x55, 0x0a, 0x0f, 0x12, 0x53, 0x11, 0x48, 0x2c,
      0x00, 0x0d, 0x00, 0x07, 0x07, 0x17, 0x3b, 0x09, 0x52, 0x19, 0x01, 0x0b,
      0x41, 0x07, 0x1b, 0x13, 0x47, 0x3d, 0x1a, 0x2a, 0x16, 0x1a, 0x0c, 0x1c,
      0x02, 0x07, 0x07, 0x48, 0x0b, 0x4f, 0x4e, 0x0b, 0x00, 0x00, 0x16, 0x3d,
      0x0b, 0x55, 0x4d, 0x08, 0x02, 0x0d, 0x1b, 0x18, 0x17, 0x44, 0x78, 0x30,
      0x69, 0x65, 0x1f, 0x49, 0x07, 0x09, 0x00, 0x19, 0x11, 0x45, 0x4f, 0x19,
      0x01, 0x49, 0x03, 0x0d, 0x35, 0x16, 0x17, 0x4d, 0x63, 0x3a, 0x09, 0x11,
      0x4f, 0x15, 0x49, 0x2a, 0x56, 0x49, 0x27, 0x01, 0x49, 0x1d, 0x06, 0x00,
      0x0d, 0x48, 0x11, 0x48, 0x0b, 0x16, 0x49, 0x1f, 0x0a, 0x22, 0x00, 0x52,
      0x00, 0x0c, 0x4e, 0x00, 0x1a, 0x0b, 0x52, 0x54, 0x30, 0x5b, 0x54, 0x62,
      0x1b, 0x1a, 0x4e, 0x08, 0x4b, 0x54, 0x62, 0x24, 0x4e, 0x0a, 0x4f, 0x20,
      0x53, 0x06, 0x35, 0x0b, 0x52, 0x09, 0x08, 0x00, 0x02, 0x11, 0x4f, 0x10,
      0x45, 0x2c, 0x4e, 0x45, 0x30, 0x52, 0x1d, 0x06, 0x06, 0x4e, 0x54, 0x09,
      0x0b, 0x59, 0x4e, 0x04, 0x00, 0x17, 0x45, 0x3a, 0x42, 0x52, 0x1d, 0x05,
      0x0f, 0x18, 0x54, 0x65, 0x78, 0x73, 0x2c, 0x5b, 0x47, 0x27, 0x52, 0x5b,
      0x4e, 0x4a, 0x0d, 0x54, 0x31, 0x00, 0x41, 0x4e, 0x1b, 0x01, 0x16, 0x45,
      0x3b, 0x0b, 0x17, 0x4d, 0x10, 0x0f, 0x46, 0x54, 0x18, 0x13, 0x4e, 0x36,
      0x5b, 0x00, 0x2e, 0x1b, 0x1a, 0x1a, 0x02, 0x4e, 0x54, 0x1c, 0x0a, 0x00,
      0x64, 0x26, 0x1d, 0x54, 0x16, 0x74, 0x0a, 0x14, 0x0b, 0x49, 0x03, 0x18,
      0x54, 0x07, 0x17, 0x41, 0x3c, 0x1a, 0x53, 0x2d, 0x52, 0x05, 0x0b, 0x13,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0a, 0x08, 0x07, 0x45, 0x24, 0x09,
      0x13, 0x14, 0x49, 0x1a, 0x09, 0x06, 0x00, 0x07, 0x47, 0x30, 0x1a, 0x2a,
      0x11, 0x1d, 0x49, 0x27, 0x47, 0x43, 0x15, 0x06, 0x45, 0x46, 0x1b, 0x01,
      0x02, 0x53, 0x0c, 0x20, 0x45, 0x07, 0x1d, 0x49, 0x0f, 0x0f, 0x10, 0x4f,
      0x1f, 0x41, 0x33, 0x5f, 0x00, 0x2b, 0x06, 0x49, 0x1d, 0x08, 0x55, 0x1a,
      0x0c, 0x45, 0x47, 0x01, 0x00, 0x0d, 0x53, 0x6f, 0x65, 0x48, 0x40, 0x40,
      0x5a, 0x4e, 0x38, 0x1b, 0x4f, 0x5f, 0x0d, 0x78, 0x71, 0x4e, 0x2d, 0x11,
      0x02, 0x4e, 0x08, 0x4e, 0x54, 0x1b, 0x0a, 0x4d, 0x0b, 0x4f, 0x1e, 0x1c,
      0x0a, 0x30, 0x45, 0x78, 0x2b, 0x06, 0x1c, 0x41, 0x13, 0x00, 0x1d, 0x44,
      0x78, 0x56, 0x55, 0x21, 0x19, 0x45, 0x4e, 0x2e, 0x00, 0x18, 0x01, 0x0e,
      0x45, 0x4e, 0x02, 0x10, 0x53, 0x17, 0x3c, 0x1c, 0x1f, 0x08, 0x1a, 0x4e,
      0x00, 0x00, 0x1d, 0x1d, 0x43, 0x31, 0x55, 0x55, 0x31, 0x52, 0x63, 0x3d,
      0x12, 0x50, 0x11, 0x1a, 0x06, 0x41, 0x02, 0x0e, 0x0f, 0x01, 0x04, 0x33,
      0x0c, 0x1e, 0x04, 0x1a, 0x1a, 0x08, 0x17, 0x0a, 0x0a, 0x50, 0x31, 0x5b,
      0x4c, 0x2b, 0x16, 0x06, 0x0d, 0x0e, 0x4f, 0x01, 0x1b, 0x45, 0x2a, 0x27,
      0x48, 0x04, 0x53, 0x04, 0x3a, 0x45, 0x17, 0x0b, 0x0f, 0x0b, 0x02, 0x00,
      0x4f, 0x13, 0x4e, 0x3c, 0x1a, 0x54, 0x2a, 0x13, 0x1d, 0x4e, 0x1e, 0x4f,
      0x01, 0x48, 0x06, 0x41, 0x00, 0x4f, 0x0b, 0x16, 0x11, 0x74, 0x6f, 0x3b,
      0x4d, 0x0a, 0x0f, 0x0f, 0x54, 0x1b, 0x13, 0x4b, 0x3d, 0x1a, 0x41, 0x62,
      0x14, 0x05, 0x17, 0x47, 0x47, 0x1d, 0x1a, 0x09, 0x00, 0x0f, 0x01, 0x0d,
      0x53, 0x08, 0x35, 0x0e, 0x17, 0x4d, 0x01, 0x0b, 0x13, 0x54, 0x18, 0x17,
      0x54, 0x76, 0x1a, 0x2a, 0x48, 0x3b, 0x4e, 0x03, 0x47, 0x4c, 0x1d, 0x03,
      0x00, 0x00, 0x3d, 0x0e, 0x04, 0x00, 0x0a, 0x3a, 0x45, 0x5f, 0x40, 0x49,
      0x3d, 0x00, 0x19, 0x1c, 0x1d, 0x4e, 0x78, 0x4e, 0x4f, 0x62, 0x36, 0x0c,
      0x02, 0x0e, 0x4c, 0x15, 0x00, 0x45, 0x2a, 0x3a, 0x07, 0x0c, 0x01, 0x00,
      0x73, 0x16, 0x52, 0x03, 0x06, 0x4e, 0x05, 0x11, 0x01, 0x0b, 0x49, 0x36,
      0x1d, 0x0c, 0x62, 0x2b, 0x06, 0x1b, 0x47, 0x43, 0x15, 0x06, 0x45, 0x54,
      0x1c, 0x16, 0x49, 0x07, 0x0a, 0x74, 0x0d, 0x13, 0x03, 0x0e, 0x4e, 0x6b,
      0x36, 0x1a, 0x06, 0x00, 0x21, 0x55, 0x55, 0x65, 0x1e, 0x05, 0x4e, 0x0c,
      0x45, 0x11, 0x18, 0x45, 0x54, 0x1c, 0x16, 0x00, 0x1d, 0x42, 0x74, 0x11,
      0x1d, 0x4d, 0x0e, 0x0b, 0x15, 0x54, 0x02, 0x0b, 0x00, 0x2b, 0x4e, 0x59,
      0x2e, 0x17, 0x49, 0x64, 0x28, 0x56, 0x11, 0x1a, 0x45, 0x41, 0x00, 0x0b,
      0x49, 0x1c, 0x13, 0x31, 0x17, 0x5e, 0x4d, 0x19, 0x1c, 0x00, 0x17, 0x1b,
      0x1b, 0x43, 0x3d, 0x1a, 0x4d, 0x23, 0x19, 0x0c, 0x1d, 0x47, 0x50, 0x11,
      0x1a, 0x03, 0x45, 0x0d, 0x1b, 0x49, 0x79, 0x27, 0x21, 0x11, 0x52, 0x03,
      0x06, 0x1a, 0x41, 0x1d, 0x09, 0x52, 0x59, 0x37, 0x4f, 0x07, 0x30, 0x17,
      0x49, 0x0f, 0x47, 0x4c, 0x1b, 0x09, 0x03, 0x45, 0x1c, 0x41, 0x49, 0x79,
      0x6f, 0x0d, 0x0a, 0x07, 0x4a, 0x05, 0x02, 0x41, 0x13, 0x0a, 0x06, 0x00,
      0x36, 0x55, 0x57, 0x2a, 0x17, 0x1b, 0x0b, 0x4b, 0x00, 0x1a, 0x07, 0x45,
      0x50, 0x02, 0x0e, 0x0a, 0x16, 0x49, 0x74, 0x0b, 0x1d, 0x4d, 0x1d, 0x07,
      0x0c, 0x11, 0x43, 0x52, 0x4e, 0x37, 0x1a, 0x47, 0x2b, 0x00, 0x05, 0x1d,
      0x47, 0x2a, 0x27, 0x07, 0x0a, 0x4e, 0x4e, 0x42, 0x44, 0x53, 0x2a, 0x3c,
      0x45, 0x1f, 0x14, 0x49, 0x29, 0x0e, 0x10, 0x43, 0x52, 0x48, 0x37, 0x57,
      0x45, 0x20, 0x1d, 0x0d, 0x17, 0x4b, 0x00, 0x0d, 0x07, 0x10, 0x00, 0x1e,
      0x1d, 0x06, 0x11, 0x04, 0x36, 0x09, 0x0b, 0x4d, 0x0c, 0x0f, 0x15, 0x54,
      0x65, 0x21, 0x50, 0x39, 0x5d, 0x48, 0x27, 0x06, 0x1d, 0x07, 0x47, 0x57,
      0x1d, 0x1c, 0x0d, 0x00, 0x0f, 0x4f, 0x1a, 0x03, 0x0a, 0x3b, 0x0b, 0x53,
      0x4d, 0x2a, 0x01, 0x0c, 0x11, 0x4f, 0x1d, 0x4e, 0x78, 0x5b, 0x4e, 0x26,
      0x52, 0x1a, 0x0f, 0x1e, 0x00, 0x1d, 0x1c, 0x44, 0x00, 0x64, 0x65, 0x3f,
      0x3a, 0x35, 0x7a, 0x45, 0x24, 0x0c, 0x07, 0x07, 0x0d, 0x18, 0x0e, 0x52,
      0x69, 0x3b, 0x5f, 0x00, 0x3b, 0x17, 0x19, 0x42, 0x47, 0x59, 0x11, 0x18,
      0x49, 0x00, 0x27, 0x48, 0x04, 0x53, 0x06, 0x3b, 0x08, 0x1b, 0x03, 0x4e,
      0x4e, 0x09, 0x15, 0x1d, 0x16, 0x00, 0x34, 0x53, 0x4b, 0x27, 0x52, 0x08,
      0x4e, 0x15, 0x48, 0x1d, 0x06, 0x0a, 0x00, 0x64, 0x26, 0x07, 0x07, 0x0a,
      0x2c, 0x0c, 0x11, 0x0c, 0x1d, 0x07, 0x0f, 0x13, 0x4f, 0x01, 0x4f, 0x78,
      0x43, 0x4f, 0x37, 0x52, 0x1a, 0x1a, 0x06, 0x47, 0x13, 0x0d, 0x17, 0x00,
      0x02, 0x06, 0x02, 0x16, 0x45, 0x35, 0x45, 0x05, 0x04, 0x07, 0x01, 0x41,
      0x7e, 0x3c, 0x1d, 0x00, 0x28, 0x4f, 0x4e, 0x29, 0x01, 0x49, 0x1d, 0x13,
      0x4f, 0x04, 0x48, 0x11, 0x52, 0x17, 0x06, 0x07, 0x14, 0x45, 0x35, 0x0b,
      0x16, 0x4d, 0x0e, 0x07, 0x13, 0x18, 0x4f, 0x01, 0x54, 0x37, 0x4a, 0x00,
      0x21, 0x00, 0x10, 0x07, 0x09, 0x07, 0x54, 0x62, 0x33, 0x41, 0x00, 0x06,
      0x05, 0x1f, 0x04, 0x74, 0x2c, 0x11, 0x08, 0x49, 0x07, 0x12, 0x54, 0x1c,
      0x17, 0x4c, 0x34, 0x53, 0x4e, 0x65, 0x52, 0x08, 0x00, 0x03, 0x00, 0x0d,
      0x07, 0x10, 0x00, 0x1e, 0x0a, 0x06, 0x03, 0x09, 0x31, 0x45, 0x13, 0x1f,
      0x0c, 0x4e, 0x03, 0x01, 0x16, 0x1b, 0x4e, 0x7f, 0x1a, 0x2a, 0x65, 0x31,
      0x08, 0x1b, 0x14, 0x45, 0x54, 0x1f, 0x0d, 0x59, 0x4e, 0x1b, 0x01, 0x16,
      0x45, 0x32, 0x17, 0x17, 0x0c, 0x02, 0x1d, 0x41, 0x15, 0x1d, 0x17, 0x00,
      0x32, 0x55, 0x43, 0x29, 0x1b, 0x07, 0x49, 0x47, 0x4c, 0x1d, 0x03, 0x00,
      0x00, 0x2d, 0x1d, 0x08, 0x09, 0x1c, 0x74, 0x22, 0x1e, 0x18, 0x0c, 0x4e,
      0x6b, 0x39, 0x00, 0x04, 0x49, 0x36, 0x1d, 0x00, 0x23, 0x1c, 0x0d, 0x4e,
      0x00, 0x52, 0x1b, 0x07, 0x13, 0x49, 0x00, 0x48, 0x49, 0x07, 0x17, 0x2d,
      0x0c, 0x1c, 0x0a, 0x49, 0x1a, 0x0e, 0x54, 0x1c, 0x1b, 0x4e, 0x3f, 0x1a,
      0x41, 0x2e, 0x1d, 0x07, 0x09, 0x47, 0x2a, 0x35, 0x04, 0x09, 0x00, 0x1a,
      0x07, 0x1b, 0x1c, 0x10, 0x33, 0x0d, 0x52, 0x19, 0x01, 0x0b, 0x41, 0x13,
      0x07, 0x17, 0x54, 0x2c, 0x55, 0x00, 0x25, 0x00, 0x06, 0x01, 0x11, 0x49,
      0x1a, 0x4f, 0x45, 0x54, 0x06, 0x06, 0x1a, 0x53, 0x0d, 0x31, 0x17, 0x17,
      0x4d, 0x1a, 0x01, 0x0f, 0x13, 0x4f, 0x78, 0x6e, 0x37, 0x4d, 0x00, 0x3b,
      0x1d, 0x1c, 0x49, 0x15, 0x45, 0x54, 0x09, 0x08, 0x41, 0x14, 0x0a, 0x0d,
      0x53, 0x07, 0x2d, 0x45, 0x06, 0x05, 0x0c, 0x4e, 0x37, 0x3d, 0x3f, 0x52,
      0x50, 0x37, 0x49, 0x53, 0x27, 0x5c, 0x49, 0x64, 0x6d, 0x73, 0x00, 0x0d,
      0x15, 0x50, 0x07, 0x01, 0x4e, 0x53, 0x16, 0x3b, 0x45, 0x1a, 0x0c, 0x1b,
      0x0a, 0x41, 0x18, 0x06, 0x19, 0x45, 0x78, 0x5b, 0x00, 0x05, 0x17, 0x1b,
      0x03, 0x06, 0x4e, 0x54, 0x26, 0x04, 0x5a, 0x07, 0x4f, 0x63, 0x20, 0x11,
      0x35, 0x17, 0x06, 0x01, 0x0c, 0x0a, 0x41, 0x16, 0x16, 0x52, 0x54, 0x30,
      0x5f, 0x00, 0x20, 0x13, 0x1a, 0x0b, 0x14, 0x00, 0x1c, 0x01, 0x11, 0x54,
      0x07, 0x01, 0x4e, 0x53, 0x02, 0x26, 0x0a, 0x07, 0x03, 0x0d, 0x4e, 0x6b,
      0x20, 0x07, 0x17, 0x52, 0x3d, 0x1d, 0x53, 0x62, 0x1c, 0x06, 0x4e, 0x13,
      0x52, 0x1d, 0x18, 0x15, 0x49, 0x00, 0x48, 0x49, 0x1c, 0x0b, 0x74, 0x08,
      0x1b, 0x03, 0x0c, 0x42, 0x41, 0x3d, 0x48, 0x1f, 0x00, 0x32, 0x4f, 0x53,
      0x36, 0x52, 0x0e, 0x0b, 0x13, 0x54, 0x1d, 0x06, 0x42, 0x00, 0x0a, 0x00,
      0x1e, 0x1d, 0x45, 0x5e, 0x36, 0x02, 0x0c, 0x1b, 0x05, 0x00, 0x19, 0x0e,
      0x06, 0x49, 0x3b, 0x16, 0x00, 0x0b, 0x55, 0x04, 0x4e, 0x0f, 0x41, 0x1a,
      0x0f, 0x0c, 0x4e, 0x49, 0x4f, 0x1d, 0x1a, 0x02, 0x3c, 0x11, 0x52, 0x01,
      0x00, 0x05, 0x04, 0x54, 0x0e, 0x52, 0x46, 0x39, 0x54, 0x41, 0x36, 0x1b,
      0x0a, 0x4e, 0x6d, 0x79, 0x1b, 0x1d, 0x45, 0x54, 0x1c, 0x0e, 0x19, 0x03,
      0x00, 0x30, 0x45, 0x1f, 0x08, 0x49, 0x01, 0x0f, 0x17, 0x0a, 0x52, 0x41,
      0x36, 0x5e, 0x00, 0x0b, 0x52, 0x1d, 0x06, 0x08, 0x55, 0x13, 0x00, 0x11,
      0x00, 0x1a, 0x07, 0x08, 0x07, 0x45, 0x5e, 0x3c, 0x1d, 0x18, 0x49, 0x03,
      0x08, 0x13, 0x07, 0x06, 0x00, 0x30, 0x5b, 0x56, 0x27, 0x52, 0x00, 0x1a,
      0x47, 0x2a, 0x27, 0x07, 0x45, 0x53, 0x1a, 0x0a, 0x19, 0x53, 0x01, 0x3b,
      0x12, 0x1c, 0x4d, 0x08, 0x00, 0x05, 0x54, 0x03, 0x17, 0x4e, 0x3c, 0x1a,
      0x4d, 0x27, 0x52, 0x10, 0x01, 0x12, 0x52, 0x54, 0x0d, 0x04, 0x52, 0x4e,
      0x65, 0x4e, 0x4b, 0x5c, 0x74, 0x0c, 0x1c, 0x4d, 0x04, 0x17, 0x41, 0x00,
      0x06, 0x1f, 0x45, 0x79, 0x1a, 0x79, 0x2d, 0x07, 0x45, 0x4e, 0x40, 0x19,
      0x44, 0x48, 0x0c, 0x53, 0x4e, 0x02, 0x10, 0x53, 0x1c, 0x31, 0x04, 0x00,
      0x43, 0x49, 0x64, 0x6b, 0x2d, 0x00, 0x07, 0x07, 0x2a, 0x5f, 0x00, 0x35,
      0x17, 0x08, 0x05, 0x02, 0x4e, 0x1d, 0x06, 0x42, 0x00, 0x08, 0x0e, 0x1a,
      0x07, 0x49, 0x74, 0x3c, 0x3d, 0x4c, 0x49, 0x0f, 0x0f, 0x10, 0x4f, 0x3b,
      0x00, 0x3b, 0x5b, 0x4e, 0x62, 0x06, 0x0c, 0x02, 0x0b, 0x00, 0x1d, 0x1c,
      0x45, 0x2a, 0x37, 0x00, 0x1c, 0x01, 0x45, 0x36, 0x0a, 0x16, 0x14, 0x4e,
      0x1d, 0x41, 0x13, 0x0a, 0x06, 0x54, 0x31, 0x54, 0x07, 0x62, 0x1a, 0x06,
      0x1a, 0x4b, 0x00, 0x07, 0x07, 0x49, 0x00, 0x1d, 0x00, 0x49, 0x3a, 0x45,
      0x37, 0x04, 0x1c, 0x4d, 0x1a, 0x03, 0x04, 0x18, 0x03, 0x52, 0x49, 0x2c,
      0x1a, 0x2a, 0x11, 0x1d, 0x49, 0x0a, 0x08, 0x4e, 0x53, 0x1c, 0x45, 0x42,
      0x0b, 0x4f, 0x04, 0x12, 0x01, 0x74, 0x04, 0x1c, 0x09, 0x49, 0x0a, 0x0e,
      0x1a, 0x48, 0x06, 0x00, 0x3a, 0x5f, 0x00, 0x31, 0x13, 0x0d, 0x4e, 0x6d,
      0x07, 0x37, 0x09, 0x10, 0x53, 0x0b, 0x4f, 0x1d, 0x1b, 0x00, 0x74, 0x09,
      0x0b, 0x1f, 0x00, 0x0d, 0x12, 0x54, 0x0d, 0x17, 0x4c, 0x37, 0x54, 0x47,
      0x62, 0x06, 0x06, 0x4e, 0x2e, 0x63, 0x31, 0x44, 0x45, 0x79, 0x01, 0x1a,
      0x49, 0x10, 0x04, 0x3a, 0x45, 0x11, 0x0c, 0x05, 0x02, 0x41, 0x19, 0x0a,
      0x52, 0x64, 0x39, 0x5e, 0x00, 0x48, 0x2b, 0x06, 0x1b, 0x40, 0x52, 0x11,
      0x48, 0x15, 0x49, 0x1a, 0x0c, 0x01, 0x1a, 0x0b, 0x73, 0x45, 0x13, 0x4d,
      0x0f, 0x07, 0x15, 0x58, 0x4f, 0x01, 0x4f, 0x78, 0x49, 0x54, 0x27, 0x02,
      0x49, 0x0c, 0x06, 0x43, 0x1f, 0x48, 0x04, 0x4e, 0x0a, 0x4f, 0x0c, 0x1d,
      0x01, 0x21, 0x17, 0x17, 0x4d, 0x63, 0x22, 0x04, 0x00, 0x4f, 0x06, 0x48,
      0x3d, 0x1a, 0x57, 0x2b, 0x06, 0x0a, 0x06, 0x47, 0x44, 0x1b, 0x0b, 0x11,
      0x4f, 0x1c, 0x43, 0x49, 0x3a, 0x06, 0x31, 0x49, 0x52, 0x09, 0x06, 0x4e,
      0x15, 0x1c, 0x0a, 0x52, 0x44, 0x39, 0x54, 0x43, 0x27, 0x52, 0x1d, 0x01,
      0x47, 0x43, 0x01, 0x1a, 0x00, 0x00, 0x64, 0x3c, 0x06, 0x53, 0x06, 0x3b,
      0x08, 0x17, 0x4d, 0x1c, 0x1e, 0x41, 0x17, 0x03, 0x1d, 0x53, 0x3d, 0x1a,
      0x41, 0x2c, 0x16, 0x49, 0x0a, 0x08, 0x4e, 0x53, 0x1c, 0x45, 0x42, 0x0b,
      0x4f, 0x1a, 0x02, 0x10, 0x35, 0x17, 0x17, 0x4d, 0x63, 0x37, 0x0e, 0x01,
      0x4f, 0x05, 0x41, 0x36, 0x54, 0x41, 0x62, 0x10, 0x08, 0x1a, 0x13, 0x4c,
      0x11, 0x48, 0x08, 0x45, 0x4e, 0x42, 0x44, 0x53, 0x24, 0x3a, 0x1c, 0x06,
      0x04, 0x04, 0x0b, 0x4d, 0x54, 0x0e, 0x1c, 0x59, 0x2f, 0x52, 0x45, 0x30,
      0x17, 0x49, 0x64, 0x6d, 0x79, 0x1b, 0x1d, 0x45, 0x54, 0x06, 0x00, 0x1c,
      0x14, 0x0d, 0x20, 0x45, 0x06, 0x05, 0x08, 0x1a, 0x41, 0x3d, 0x4f, 0x05,
      0x41, 0x2b, 0x1a, 0x57, 0x27, 0x13, 0x02, 0x42, 0x47, 0x62, 0x1b, 0x11,
      0x49, 0x00, 0x17, 0x00, 0x1c, 0x54, 0x17, 0x31, 0x45, 0x16, 0x08, 0x08,
      0x0a, 0x41, 0x03, 0x1d, 0x1d, 0x4e, 0x3f, 0x1a, 0x2a, 0x11, 0x1d, 0x49,
      0x0d, 0x08, 0x4d, 0x11, 0x48, 0x0a, 0x4e, 0x42, 0x4f, 0x0c, 0x05, 0x00,
      0x26, 0x1c, 0x10, 0x02, 0x0d, 0x17, 0x41, 0x15, 0x01, 0x16, 0x00, 0x2b,
      0x53, 0x4e, 0x25, 0x52, 0x1d, 0x06, 0x0e, 0x53, 0x54, 0x1b, 0x0a, 0x4e,
      0x09, 0x4f, 0x63, 0x79, 0x36, 0x35, 0x1c, 0x52, 0x40, 0x44, 0x4e, 0x31,
      0x18, 0x0e, 0x0b, 0x00, 0x2c, 0x52, 0x41, 0x36, 0x52, 0x0f, 0x1b, 0x09,
      0x4b, 0x0d, 0x48, 0x08, 0x55, 0x1d, 0x06, 0x0a, 0x53, 0x36, 0x35, 0x1c,
      0x5e, 0x4d, 0x0e, 0x01, 0x41, 0x03, 0x07, 0x1b, 0x54, 0x3d, 0x1a, 0x42,
      0x2d, 0x0b, 0x45, 0x4e, 0x00, 0x4f, 0x54, 0x1f, 0x0d, 0x49, 0x1a, 0x0a,
      0x49, 0x11, 0x0a, 0x2d, 0x45, 0x15, 0x02, 0x49, 0x64, 0x11, 0x18, 0x0e,
      0x0b, 0x00, 0x2c, 0x52, 0x41, 0x36, 0x52, 0x0f, 0x1b, 0x09, 0x4b, 0x0d,
      0x48, 0x08, 0x55, 0x1d, 0x06, 0x0a, 0x53, 0x22, 0x3b, 0x45, 0x05, 0x05,
      0x00, 0x1a, 0x04, 0x54, 0x0d, 0x1d, 0x59, 0x74, 0x1a, 0x47, 0x2d, 0x52,
      0x1e, 0x06, 0x0e, 0x54, 0x11, 0x48, 0x07, 0x4f, 0x17, 0x43, 0x49, 0x14,
      0x0a, 0x74, 0x6f, 0x3e, 0x0c, 0x10, 0x4e, 0x05, 0x1b, 0x18, 0x1c, 0x00,
      0x39, 0x54, 0x44, 0x62, 0x10, 0x06, 0x01, 0x00, 0x49, 0x11, 0x48, 0x04,
      0x4e, 0x0a, 0x4f, 0x19, 0x1f, 0x04, 0x2d, 0x45, 0x06, 0x05, 0x08, 0x1a,
      0x41, 0x12, 0x1a, 0x1c, 0x4b, 0x21, 0x1a, 0x4d, 0x37, 0x01, 0x00, 0x0d,
      0x47, 0x54, 0x1d, 0x04, 0x09, 0x00, 0x17, 0x00, 0x1c, 0x53, 0x01, 0x3d,
      0x00, 0x5c, 0x4d, 0x63, 0x64, 0x31, 0x18, 0x0e, 0x0b, 0x00, 0x2c, 0x52,
      0x41, 0x36, 0x52, 0x0f, 0x1b, 0x09, 0x4b, 0x0d, 0x48, 0x08, 0x55, 0x1d,
      0x06, 0x0a, 0x53, 0x26, 0x3b, 0x08, 0x17, 0x4d, 0x06, 0x00, 0x4d, 0x54,
      0x2c, 0x1d, 0x4d, 0x3d, 0x1a, 0x4f, 0x2c, 0x5e, 0x49, 0x02, 0x02, 0x54,
      0x54, 0x05, 0x00, 0x00, 0x06, 0x0a, 0x08, 0x01, 0x45, 0x5e, 0x35, 0x1e,
      0x0c, 0x10, 0x4e, 0x15, 0x1c, 0x0e, 0x06, 0x00, 0x3e, 0x4f, 0x4e, 0x29,
      0x0b, 0x49, 0x03, 0x12, 0x53, 0x1d, 0x0b, 0x45, 0x57, 0x06, 0x06, 0x1d,
      0x16, 0x45, 0x36, 0x0a, 0x0b, 0x4d, 0x10, 0x01, 0x14, 0x54, 0x1c, 0x13,
      0x59, 0x78, 0x53, 0x54, 0x6e, 0x52, 0x1a, 0x0f, 0x1e, 0x00, 0x1d, 0x1c,
      0x45, 0x2a, 0x3e, 0x03, 0x08, 0x0a, 0x45, 0x20, 0x0d, 0x13, 0x19, 0x49,
      0x08, 0x14, 0x1a, 0x04, 0x0b, 0x00, 0x35, 0x4f, 0x53, 0x2b, 0x11, 0x49,
      0x2f, 0x47, 0x4c, 0x1d, 0x1c, 0x11, 0x4c, 0x0b, 0x4f, 0x05, 0x1c, 0x10,
      0x30, 0x00, 0x00, 0x4d, 0x07, 0x01, 0x16, 0x54, 0x65, 0x22, 0x4c, 0x39,
      0x43, 0x00, 0x36, 0x1a, 0x08, 0x1a, 0x47, 0x46, 0x01, 0x06, 0x0e, 0x59,
      0x4e, 0x02, 0x1c, 0x00, 0x0c, 0x37, 0x49, 0x52, 0x1a, 0x01, 0x07, 0x15,
      0x11, 0x4f, 0x10, 0x4f, 0x21, 0x1a, 0x63, 0x2d, 0x1f, 0x0c, 0x4e, 0x08,
      0x4e, 0x58, 0x48, 0x26, 0x4f, 0x03, 0x0a, 0x49, 0x1c, 0x0b, 0x78, 0x45,
      0x31, 0x02, 0x04, 0x0b, 0x41, 0x1b, 0x01, 0x52, 0x2a, 0x08, 0x56, 0x41,
      0x3b, 0x52, 0x1d, 0x06, 0x06, 0x54, 0x54, 0x0e, 0x10, 0x4e, 0x05, 0x16,
      0x49, 0x1e, 0x10, 0x27, 0x0c, 0x11, 0x4d, 0x63
    },
    {
      0x49, 0x27, 0x6d, 0x20, 0x62, 0x61, 0x63, 0x6b, 0x20, 0x61, 0x6e, 0x64,
      0x20, 0x49, 0x27, 0x6d, 0x20, 0x72, 0x69, 0x6e, 0x67, 0x69, 0x6e, 0x27,
      0x20, 0x74, 0x68, 0x65, 0x20, 0x62, 0x65, 0x6c, 0x6c, 0x20, 0x0a, 0x41,
      0x20, 0x72, 0x6f, 0x63, 0x6b, 0x69, 0x6e, 0x27, 0x20, 0x6f, 0x6e, 0x20,
      0x74, 0x68, 0x65, 0x20, 0x6d, 0x69, 0x6b, 0x65, 0x20, 0x77, 0x68, 0x69,
      0x6c, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x66, 0x6c, 0x79, 0x20, 0x67,
      0x69, 0x72, 0x6c, 0x73, 0x20, 0x79, 0x65, 0x6c, 0x6c, 0x20, 0x0a, 0x49,
      0x6e, 0x20, 0x65, 0x63, 0x73, 0x74, 0x61, 0x73, 0x79, 0x20, 0x69, 0x6e,
      0x20, 0x74, 0x68, 0x65, 0x20, 0x62, 0x61, 0x63, 0x6b, 0x20, 0x6f, 0x66,
      0x20, 0x6d, 0x65, 0x20, 0x0a, 0x57, 0x65, 0x6c, 0x6c, 0x20, 0x74, 0x68,
      0x61, 0x74, 0x27, 0x73, 0x20, 0x6d, 0x79, 0x20, 0x44, 0x4a, 0x20, 0x44,
      0x65, 0x73, 0x68, 0x61, 0x79, 0x20, 0x63, 0x75, 0x74, 0x74, 0x69, 0x6e,
      0x27, 0x20, 0x61, 0x6c, 0x6c, 0x20, 0x74, 0x68, 0x65, 0x6d, 0x20, 0x5a,
      0x27, 0x73, 0x20, 0x0a, 0x48, 0x69, 0x74, 0x74, 0x69, 0x6e, 0x27, 0x20,
      0x68, 0x61, 0x72, 0x64, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x65,
      0x20, 0x67, 0x69, 0x72, 0x6c, 0x69, 0x65, 0x73, 0x20, 0x67, 0x6f, 0x69,
      0x6e, 0x27, 0x20, 0x63, 0x72, 0x61, 0x7a, 0x79, 0x20, 0x0a, 0x56, 0x61,
      0x6e, 0x69, 0x6c, 0x6c, 0x61, 0x27, 0x73, 0x20, 0x6f, 0x6e, 0x20, 0x74,
      0x68, 0x65, 0x20, 0x6d, 0x69, 0x6b, 0x65, 0x2c, 0x20, 0x6d, 0x61, 0x6e,
      0x20, 0x49, 0x27, 0x6d, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x6c, 0x61, 0x7a,
      0x79, 0x2e, 0x20, 0x0a, 0x0a, 0x49, 0x27, 0x6d, 0x20, 0x6c, 0x65, 0x74,
      0x74, 0x69, 0x6e, 0x27, 0x20, 0x6d, 0x79, 0x20, 0x64, 0x72, 0x75, 0x67,
      0x20, 0x6b, 0x69, 0x63, 0x6b, 0x20, 0x69, 0x6e, 0x20, 0x0a, 0x49, 0x74,
      0x20, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x20, 0x6d, 0x79,
      0x20, 0x6d, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x49,
      0x20, 0x62, 0x65, 0x67, 0x69, 0x6e, 0x20, 0x0a, 0x54, 0x6f, 0x20, 0x6a,
      0x75, 0x73, 0x74, 0x20, 0x6c, 0x65, 0x74, 0x20, 0x69, 0x74, 0x20, 0x66,
      0x6c, 0x6f, 0x77, 0x2c, 0x20, 0x6c, 0x65, 0x74, 0x20, 0x6d, 0x79, 0x20,
      0x63, 0x6f, 0x6e, 0x63, 0x65, 0x70, 0x74, 0x73, 0x20, 0x67, 0x6f, 0x20,
      0x0a, 0x4d, 0x79, 0x20, 0x70, 0x6f, 0x73, 0x73, 0x65, 0x27, 0x73, 0x20,
      0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x69, 0x64, 0x65, 0x20,
      0x79, 0x65, 0x6c, 0x6c, 0x69, 0x6e, 0x27, 0x2c, 0x20, 0x47, 0x6f, 0x20,
      0x56, 0x61, 0x6e, 0x69, 0x6c, 0x6c, 0x61, 0x20, 0x47, 0x6f, 0x21, 0x20,
      0x0a, 0x0a, 0x53, 0x6d, 0x6f, 0x6f, 0x74, 0x68, 0x20, 0x27, 0x63, 0x61,
      0x75, 0x73, 0x65, 0x20, 0x74, 0x68, 0x61, 0x74, 0x27, 0x73, 0x20, 0x74,
      0x68, 0x65, 0x20, 0x77, 0x61, 0x79, 0x20, 0x49, 0x20, 0x77, 0x69, 0x6c,
      0x6c, 0x20, 0x62, 0x65, 0x20, 0x0a, 0x41, 0x6e, 0x64, 0x20, 0x69, 0x66,
      0x20, 0x79, 0x6f, 0x75, 0x20, 0x64, 0x6f, 0x6e, 0x27, 0x74, 0x20, 0x67,
      0x69, 0x76, 0x65, 0x20, 0x61, 0x20, 0x64, 0x61, 0x6d, 0x6e, 0x2c, 0x20,
      0x74, 0x68, 0x65, 0x6e, 0x20, 0x0a, 0x57, 0x68, 0x79, 0x20, 0x79, 0x6f,
      0x75, 0x20, 0x73, 0x74, 0x61, 0x72, 0x69, 0x6e, 0x27, 0x20, 0x61, 0x74,
      0x20, 0x6d, 0x65, 0x20, 0x0a, 0x53, 0x6f, 0x20, 0x67, 0x65, 0x74, 0x20,
      0x6f, 0x66, 0x66, 0x20, 0x27, 0x63, 0x61, 0x75, 0x73, 0x65, 0x20, 0x49,
      0x20, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x20, 0x74, 0x68, 0x65,
      0x20, 0x73, 0x74, 0x61, 0x67, 0x65, 0x20, 0x0a, 0x54, 0x68, 0x65, 0x72,
      0x65, 0x27, 0x73, 0x20, 0x6e, 0x6f, 0x20, 0x64, 0x69, 0x73, 0x73, 0x69,
      0x6e, 0x27, 0x20, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x20, 0x0a,
      0x49, 0x27, 0x6d, 0x20, 0x69, 0x6e, 0x20, 0x6d, 0x79, 0x20, 0x6f, 0x77,
      0x6e, 0x20, 0x70, 0x68, 0x61, 0x73, 0x65, 0x20, 0x0a, 0x54, 0x68, 0x65,
      0x20, 0x67, 0x69, 0x72, 0x6c, 0x69, 0x65, 0x73, 0x20, 0x73, 0x61, 0x20,
      0x79, 0x20, 0x74, 0x68, 0x65, 0x79, 0x20, 0x6c, 0x6f, 0x76, 0x65, 0x20,
      0x6d, 0x65, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20,
      0x69, 0x73, 0x20, 0x6f, 0x6b, 0x20, 0x0a, 0x41, 0x6e, 0x64, 0x20, 0x49,
      0x20, 0x63, 0x61, 0x6e, 0x20, 0x64, 0x61, 0x6e, 0x63, 0x65, 0x20, 0x62,
      0x65, 0x74, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x61,
      0x6e, 0x79, 0x20, 0x6b, 0x69, 0x64, 0x20, 0x6e, 0x27, 0x20, 0x70, 0x6c,
      0x61, 0x79, 0x20, 0x0a, 0x0a, 0x53, 0x74, 0x61, 0x67, 0x65, 0x20, 0x32,
      0x20, 0x2d, 0x2d, 0x20, 0x59, 0x65, 0x61, 0x20, 0x74, 0x68, 0x65, 0x20,
      0x6f, 0x6e, 0x65, 0x20, 0x79, 0x61, 0x27, 0x20, 0x77, 0x61, 0x6e, 0x6e,
      0x61, 0x20, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x20, 0x74, 0x6f, 0x20,
      0x0a, 0x49, 0x74, 0x27, 0x73, 0x20, 0x6f, 0x66, 0x66, 0x20, 0x6d, 0x79,
      0x20, 0x68, 0x65, 0x61, 0x64, 0x20, 0x73, 0x6f, 0x20, 0x6c, 0x65, 0x74,
      0x20, 0x74, 0x68, 0x65, 0x20, 0x62, 0x65, 0x61, 0x74, 0x20, 0x70, 0x6c,
      0x61, 0x79, 0x20, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x20, 0x0a,
      0x53, 0x6f, 0x20, 0x49, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x66, 0x75, 0x6e,
      0x6b, 0x20, 0x69, 0x74, 0x20, 0x75, 0x70, 0x20, 0x61, 0x6e, 0x64, 0x20,
      0x6d, 0x61, 0x6b, 0x65, 0x20, 0x69, 0x74, 0x20, 0x73, 0x6f, 0x75, 0x6e,
      0x64, 0x20, 0x67, 0x6f, 0x6f, 0x64, 0x20, 0x0a, 0x31, 0x2d, 0x32, 0x2d,
      0x33, 0x20, 0x59, 0x6f, 0x20, 0x2d, 0x2d, 0x20, 0x4b, 0x6e, 0x6f, 0x63,
      0x6b, 0x20, 0x6f, 0x6e, 0x20, 0x73, 0x6f, 0x6d, 0x65, 0x20, 0x77, 0x6f,
      0x6f, 0x64, 0x20, 0x0a, 0x46, 0x6f, 0x72, 0x20, 0x67, 0x6f, 0x6f, 0x64,
      0x20, 0x6c, 0x75, 0x63, 0x6b, 0x2c, 0x20, 0x49, 0x20, 0x6c, 0x69, 0x6b,
      0x65, 0x20, 0x6d, 0x79, 0x20, 0x72, 0x68, 0x79, 0x6d, 0x65, 0x73, 0x20,
      0x61, 0x74, 0x72, 0x6f, 0x63, 0x69, 0x6f, 0x75, 0x73, 0x20, 0x0a, 0x53,
      0x75, 0x70, 0x65, 0x72, 0x63, 0x61, 0x6c, 0x61, 0x66, 0x72, 0x61, 0x67,
      0x69, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x63, 0x65, 0x78, 0x70, 0x69, 0x61,
      0x6c, 0x69, 0x64, 0x6f, 0x63, 0x69, 0x6f, 0x75, 0x73, 0x20, 0x0a, 0x49,
      0x27, 0x6d, 0x20, 0x61, 0x6e, 0x20, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74,
      0x20, 0x61, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x79, 0x6f,
      0x75, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x74, 0x20, 0x0a, 0x49,
      0x20, 0x63, 0x61, 0x6e, 0x20, 0x74, 0x61, 0x6b, 0x65, 0x20, 0x61, 0x20,
      0x66, 0x6c, 0x79, 0x20, 0x67, 0x69, 0x72, 0x6c, 0x20, 0x61, 0x6e, 0x64,
      0x20, 0x6d, 0x61, 0x6b, 0x65, 0x20, 0x68, 0x65, 0x72, 0x20, 0x77, 0x65,
      0x74, 0x2e, 0x20, 0x0a, 0x0a, 0x49, 0x27, 0x6d, 0x20, 0x6c, 0x69, 0x6b,
      0x65, 0x20, 0x53, 0x61, 0x6d, 0x73, 0x6f, 0x6e, 0x20, 0x2d, 0x2d, 0x20,
      0x53, 0x61, 0x6d, 0x73, 0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x20, 0x44, 0x65,
      0x6c, 0x69, 0x6c, 0x61, 0x68, 0x20, 0x0a, 0x54, 0x68, 0x65, 0x72, 0x65,
      0x27, 0x73, 0x20, 0x6e, 0x6f, 0x20, 0x64, 0x65, 0x6e, 0x79, 0x69, 0x6e,
      0x27, 0x2c, 0x20, 0x59, 0x6f, 0x75, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x74,
      0x72, 0x79, 0x20, 0x74, 0x6f, 0x20, 0x68, 0x61, 0x6e, 0x67, 0x20, 0x0a,
      0x42, 0x75, 0x74, 0x20, 0x79, 0x6f, 0x75, 0x27, 0x6c, 0x6c, 0x20, 0x6b,
      0x65, 0x65, 0x70, 0x20, 0x74, 0x72, 0x79, 0x69, 0x6e, 0x27, 0x20, 0x74,
      0x6f, 0x20, 0x67, 0x65, 0x74, 0x20, 0x6d, 0x79, 0x20, 0x73, 0x74, 0x79,
      0x6c, 0x65, 0x20, 0x0a, 0x4f, 0x76, 0x65, 0x72, 0x20, 0x61, 0x6e, 0x64,
      0x20, 0x6f, 0x76, 0x65, 0x72, 0x2c, 0x20, 0x70, 0x72, 0x61, 0x63, 0x74,
      0x69, 0x63, 0x65, 0x20, 0x6d, 0x61, 0x6b, 0x65, 0x73, 0x20, 0x70, 0x65,
      0x72, 0x66, 0x65, 0x63, 0x74, 0x20, 0x0a, 0x42, 0x75, 0x74, 0x20, 0x6e,
      0x6f, 0x74, 0x20, 0x69, 0x66, 0x20, 0x79, 0x6f, 0x75, 0x27, 0x72, 0x65,
      0x20, 0x61, 0x20, 0x6c, 0x6f, 0x61, 0x66, 0x65, 0x72, 0x2e, 0x20, 0x0a,
      0x0a, 0x59, 0x6f, 0x75, 0x27, 0x6c, 0x6c, 0x20, 0x67, 0x65, 0x74, 0x20,
      0x6e, 0x6f, 0x77, 0x68, 0x65, 0x72, 0x65, 0x2c, 0x20, 0x6e, 0x6f, 0x20,
      0x70, 0x6c, 0x61, 0x63, 0x65, 0x2c, 0x20, 0x6e, 0x6f, 0x20, 0x74, 0x69,
      0x6d, 0x65, 0x2c, 0x20, 0x6e, 0x6f, 0x20, 0x67, 0x69, 0x72, 0x6c, 0x73,
      0x20, 0x0a, 0x53, 0x6f, 0x6f, 0x6e, 0x20, 0x2d, 0x2d, 0x20, 0x4f, 0x68,
      0x20, 0x6d, 0x79, 0x20, 0x47, 0x6f, 0x64, 0x2c, 0x20, 0x68, 0x6f, 0x6d,
      0x65, 0x62, 0x6f, 0x64, 0x79, 0x2c, 0x20, 0x79, 0x6f, 0x75, 0x20, 0x70,
      0x72, 0x6f, 0x62, 0x61, 0x62, 0x6c, 0x79, 0x20, 0x65, 0x61, 0x74, 0x20,
      0x0a, 0x53, 0x70, 0x61, 0x67, 0x68, 0x65, 0x74, 0x74, 0x69, 0x20, 0x77,
      0x69, 0x74, 0x68, 0x20, 0x61, 0x20, 0x73, 0x70, 0x6f, 0x6f, 0x6e, 0x21,
      0x20, 0x43, 0x6f, 0x6d, 0x65, 0x20, 0x6f, 0x6e, 0x20, 0x61, 0x6e, 0x64,
      0x20, 0x73, 0x61, 0x79, 0x20, 0x69, 0x74, 0x21, 0x20, 0x0a, 0x0a, 0x56,
      0x49, 0x50, 0x2e, 0x20, 0x56, 0x61, 0x6e, 0x69, 0x6c, 0x6c, 0x61, 0x20,
      0x49, 0x63, 0x65, 0x20, 0x79, 0x65, 0x70, 0x2c, 0x20, 0x79, 0x65, 0x70,
      0x2c, 0x20, 0x49, 0x27, 0x6d, 0x20, 0x63, 0x6f, 0x6d, 0x69, 0x6e, 0x27,
      0x20, 0x68, 0x61, 0x72, 0x64, 0x20, 0x6c, 0x69, 0x6b, 0x65, 0x20, 0x61,
      0x20, 0x72, 0x68, 0x69, 0x6e, 0x6f, 0x20, 0x0a, 0x49, 0x6e, 0x74, 0x6f,
      0x78, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x73, 0x6f, 0x20,
      0x79, 0x6f, 0x75, 0x20, 0x73, 0x74, 0x61, 0x67, 0x67, 0x65, 0x72, 0x20,
      0x6c, 0x69, 0x6b, 0x65, 0x20, 0x61, 0x20, 0x77, 0x69, 0x6e, 0x6f, 0x20,
      0x0a, 0x53, 0x6f, 0x20, 0x70, 0x75, 0x6e, 0x6b, 0x73, 0x20, 0x73, 0x74,
      0x6f, 0x70, 0x20, 0x74, 0x72, 0x79, 0x69, 0x6e, 0x67, 0x20, 0x61, 0x6e,
      0x64, 0x20, 0x67, 0x69, 0x72, 0x6c, 0x20, 0x73, 0x74, 0x6f, 0x70, 0x20,
      0x63, 0x72, 0x79, 0x69, 0x6e, 0x27, 0x20, 0x0a, 0x56, 0x61, 0x6e, 0x69,
      0x6c, 0x6c, 0x61, 0x20, 0x49, 0x63, 0x65, 0x20, 0x69, 0x73, 0x20, 0x73,
      0x65, 0x6c, 0x6c, 0x69, 0x6e, 0x27, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x79,
      0x6f, 0x75, 0x20, 0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x20, 0x61, 0x72,
      0x65, 0x20, 0x62, 0x75, 0x79, 0x69, 0x6e, 0x27, 0x20, 0x0a, 0x27, 0x43,
      0x61, 0x75, 0x73, 0x65, 0x20, 0x77, 0x68, 0x79, 0x20, 0x74, 0x68, 0x65,
      0x20, 0x66, 0x72, 0x65, 0x61, 0x6b, 0x73, 0x20, 0x61, 0x72, 0x65, 0x20,
      0x6a, 0x6f, 0x63, 0x6b, 0x69, 0x6e, 0x27, 0x20, 0x6c, 0x69, 0x6b, 0x65,
      0x20, 0x43, 0x72, 0x61, 0x7a, 0x79, 0x20, 0x47, 0x6c, 0x75, 0x65, 0x20,
      0x0a, 0x4d, 0x6f, 0x76, 0x69, 0x6e, 0x27, 0x20, 0x61, 0x6e, 0x64, 0x20,
      0x67, 0x72, 0x6f, 0x6f, 0x76, 0x69, 0x6e, 0x27, 0x20, 0x74, 0x72, 0x79,
      0x69, 0x6e, 0x67, 0x20, 0x74, 0x6f, 0x20, 0x73, 0x69, 0x6e, 0x67, 0x20,
      0x61, 0x6c, 0x6f, 0x6e, 0x67, 0x20, 0x0a, 0x41, 0x6c, 0x6c, 0x20, 0x74,
      0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x20, 0x74, 0x68, 0x65, 0x20, 0x67,
      0x68, 0x65, 0x74, 0x74, 0x6f, 0x20, 0x67, 0x72, 0x6f, 0x6f, 0x76, 0x69,
      0x6e, 0x27, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x68, 0x65, 0x72, 0x65,
      0x20, 0x73, 0x6f, 0x6e, 0x67, 0x20, 0x0a, 0x4e, 0x6f, 0x77, 0x20, 0x79,
      0x6f, 0x75, 0x27, 0x72, 0x65, 0x20, 0x61, 0x6d, 0x61, 0x7a, 0x65, 0x64,
      0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x56, 0x49, 0x50, 0x20,
      0x70, 0x6f, 0x73, 0x73, 0x65, 0x2e, 0x20, 0x0a, 0x0a, 0x53, 0x74, 0x65,
      0x70, 0x70, 0x69, 0x6e, 0x27, 0x20, 0x73, 0x6f, 0x20, 0x68, 0x61, 0x72,
      0x64, 0x20, 0x6c, 0x69, 0x6b, 0x65, 0x20, 0x61, 0x20, 0x47, 0x65, 0x72,
      0x6d, 0x61, 0x6e, 0x20, 0x4e, 0x61, 0x7a, 0x69, 0x20, 0x0a, 0x53, 0x74,
      0x61, 0x72, 0x74, 0x6c, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68,
      0x65, 0x20, 0x62, 0x61, 0x73, 0x65, 0x73, 0x20, 0x68, 0x69, 0x74, 0x74,
      0x69, 0x6e, 0x27, 0x20, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x20, 0x0a,
      0x54, 0x68, 0x65, 0x72, 0x65, 0x27, 0x73, 0x20, 0x6e, 0x6f, 0x20, 0x74,
      0x72, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x27, 0x20, 0x6f, 0x6e, 0x20, 0x6d,
      0x69, 0x6e, 0x65, 0x2c, 0x20, 0x49, 0x27, 0x6d, 0x20, 0x6a, 0x75, 0x73,
      0x74, 0x20, 0x67, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x27, 0x20, 0x64, 0x6f,
      0x77, 0x6e, 0x20, 0x0a, 0x53, 0x70, 0x61, 0x72, 0x6b, 0x61, 0x6d, 0x61,
      0x74, 0x69, 0x63, 0x2c, 0x20, 0x49, 0x27, 0x6d, 0x20, 0x68, 0x61, 0x6e,
      0x67, 0x69, 0x6e, 0x27, 0x20, 0x74, 0x69, 0x67, 0x68, 0x74, 0x20, 0x6c,
      0x69, 0x6b, 0x65, 0x20, 0x61, 0x20, 0x66, 0x61, 0x6e, 0x61, 0x74, 0x69,
      0x63, 0x20, 0x0a, 0x59, 0x6f, 0x75, 0x20, 0x74, 0x72, 0x61, 0x70, 0x70,
      0x65, 0x64, 0x20, 0x6d, 0x65, 0x20, 0x6f, 0x6e, 0x63, 0x65, 0x20, 0x61,
      0x6e, 0x64, 0x20, 0x49, 0x20, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x74,
      0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x0a, 0x59, 0x6f, 0x75, 0x20, 0x6d,
      0x69, 0x67, 0x68, 0x74, 0x20, 0x68, 0x61, 0x76, 0x65, 0x20, 0x69, 0x74,
      0x20, 0x0a, 0x53, 0x6f, 0x20, 0x73, 0x74, 0x65, 0x70, 0x20, 0x64, 0x6f,
      0x77, 0x6e, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x6e, 0x64, 0x20,
      0x6d, 0x65, 0x20, 0x79, 0x6f, 0x75, 0x72, 0x20, 0x65, 0x61, 0x72, 0x20,
      0x0a, 0x27, 0x38, 0x39, 0x20, 0x69, 0x6e, 0x20, 0x6d, 0x79, 0x20, 0x74,
      0x69, 0x6d, 0x65, 0x21, 0x20, 0x59, 0x6f, 0x75, 0x2c, 0x20, 0x27, 0x39,
      0x30, 0x20, 0x69, 0x73, 0x20, 0x6d, 0x79, 0x20, 0x79, 0x65, 0x61, 0x72,
      0x2e, 0x20, 0x0a, 0x0a, 0x59, 0x6f, 0x75, 0x27, 0x72, 0x65, 0x20, 0x77,
      0x65, 0x61, 0x6b, 0x65, 0x6e, 0x69, 0x6e, 0x27, 0x20, 0x66, 0x61, 0x73,
      0x74, 0x2c, 0x20, 0x59, 0x4f, 0x21, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x49,
      0x20, 0x63, 0x61, 0x6e, 0x20, 0x74, 0x65, 0x6c, 0x6c, 0x20, 0x69, 0x74,
      0x20, 0x0a, 0x59, 0x6f, 0x75, 0x72, 0x20, 0x62, 0x6f, 0x64, 0x79, 0x27,
      0x73, 0x20, 0x67, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x27, 0x20, 0x68, 0x6f,
      0x74, 0x2c, 0x20, 0x73, 0x6f, 0x2c, 0x20, 0x73, 0x6f, 0x20, 0x49, 0x20,
      0x63, 0x61, 0x6e, 0x20, 0x73, 0x6d, 0x65, 0x6c, 0x6c, 0x20, 0x69, 0x74,
      0x20, 0x0a, 0x53, 0x6f, 0x20, 0x64, 0x6f, 0x6e, 0x27, 0x74, 0x20, 0x62,
      0x65, 0x20, 0x6d, 0x61, 0x64, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x64, 0x6f,
      0x6e, 0x27, 0x74, 0x20, 0x62, 0x65, 0x20, 0x73, 0x61, 0x64, 0x20, 0x0a,
      0x27, 0x43, 0x61, 0x75, 0x73, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6c,
      0x79, 0x72, 0x69, 0x63, 0x73, 0x20, 0x62, 0x65, 0x6c, 0x6f, 0x6e, 0x67,
      0x20, 0x74, 0x6f, 0x20, 0x49, 0x43, 0x45, 0x2c, 0x20, 0x59, 0x6f, 0x75,
      0x20, 0x63, 0x61, 0x6e, 0x20, 0x63, 0x61, 0x6c, 0x6c, 0x20, 0x6d, 0x65,
      0x20, 0x44, 0x61, 0x64, 0x20, 0x0a, 0x59, 0x6f, 0x75, 0x27, 0x72, 0x65,
      0x20, 0x70, 0x69, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x27, 0x20, 0x61, 0x20,
      0x66, 0x69, 0x74, 0x2c, 0x20, 0x73, 0x6f, 0x20, 0x73, 0x74, 0x65, 0x70,
      0x20, 0x62, 0x61, 0x63, 0x6b, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x65, 0x6e,
      0x64, 0x75, 0x72, 0x65, 0x20, 0x0a, 0x4c, 0x65, 0x74, 0x20, 0x74, 0x68,
      0x65, 0x20, 0x77, 0x69, 0x74, 0x63, 0x68, 0x20, 0x64, 0x6f, 0x63, 0x74,
      0x6f, 0x72, 0x2c, 0x20, 0x49, 0x63, 0x65, 0x2c, 0x20, 0x64, 0x6f, 0x20,
      0x74, 0x68, 0x65, 0x20, 0x64, 0x61, 0x6e, 0x63, 0x65, 0x20, 0x74, 0x6f,
      0x20, 0x63, 0x75, 0x72, 0x65, 0x20, 0x0a, 0x53, 0x6f, 0x20, 0x63, 0x6f,
      0x6d, 0x65, 0x20, 0x75, 0x70, 0x20, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x20,
      0x61, 0x6e, 0x64, 0x20, 0x64, 0x6f, 0x6e, 0x27, 0x74, 0x20, 0x62, 0x65,
      0x20, 0x73, 0x71, 0x75, 0x61, 0x72, 0x65, 0x20, 0x0a, 0x59, 0x6f, 0x75,
      0x20, 0x77, 0x61, 0x6e, 0x6e, 0x61, 0x20, 0x62, 0x61, 0x74, 0x74, 0x6c,
      0x65, 0x20, 0x6d, 0x65, 0x20, 0x2d, 0x2d, 0x20, 0x41, 0x6e, 0x79, 0x74,
      0x69, 0x6d, 0x65, 0x2c, 0x20, 0x61, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72,
      0x65, 0x20, 0x0a, 0x0a, 0x59, 0x6f, 0x75, 0x20, 0x74, 0x68, 0x6f, 0x75,
      0x67, 0x68, 0x74, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x49, 0x20, 0x77,
      0x61, 0x73, 0x20, 0x77, 0x65, 0x61, 0x6b, 0x2c, 0x20, 0x42, 0x6f, 0x79,
      0x2c, 0x20, 0x79, 0x6f, 0x75, 0x27, 0x72, 0x65, 0x20, 0x64, 0x65, 0x61,
      0x64, 0x20, 0x77, 0x72, 0x6f, 0x6e, 0x67, 0x20, 0x0a, 0x53, 0x6f, 0x20,
      0x63, 0x6f, 0x6d, 0x65, 0x20, 0x6f, 0x6e, 0x2c, 0x20, 0x65, 0x76, 0x65,
      0x72, 0x79, 0x62, 0x6f, 0x64, 0x79, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x73,
      0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x73, 0x6f, 0x6e,
      0x67, 0x20, 0x0a, 0x0a, 0x53, 0x61, 0x79, 0x20, 0x2d, 0x2d, 0x20, 0x50,
      0x6c, 0x61, 0x79, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x66, 0x75, 0x6e,
      0x6b, 0x79, 0x20, 0x6d, 0x75, 0x73, 0x69, 0x63, 0x20, 0x53, 0x61, 0x79,
      0x2c, 0x20, 0x67, 0x6f, 0x20, 0x77, 0x68, 0x69, 0x74, 0x65, 0x20, 0x62,
      0x6f, 0x79, 0x2c, 0x20, 0x67, 0x6f, 0x20, 0x77, 0x68, 0x69, 0x74, 0x65,
      0x20, 0x62, 0x6f, 0x79, 0x20, 0x67, 0x6f, 0x20, 0x0a, 0x70, 0x6c, 0x61,
      0x79, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x66, 0x75, 0x6e, 0x6b, 0x79,
      0x20, 0x6d, 0x75, 0x73, 0x69, 0x63, 0x20, 0x47, 0x6f, 0x20, 0x77, 0x68,
      0x69, 0x74, 0x65, 0x20, 0x62, 0x6f, 0x79, 0x2c, 0x20, 0x67, 0x6f, 0x20,
      0x77, 0x68, 0x69, 0x74, 0x65, 0x20, 0x62, 0x6f, 0x79, 0x2c, 0x20, 0x67,
      0x6f, 0x20, 0x0a, 0x4c, 0x61, 0x79, 0x20, 0x64, 0x6f, 0x77, 0x6e, 0x20,
      0x61, 0x6e, 0x64, 0x20, 0x62, 0x6f, 0x6f, 0x67, 0x69, 0x65, 0x20, 0x61,
      0x6e, 0x64, 0x20, 0x70, 0x6c, 0x61, 0x79, 0x20, 0x74, 0x68, 0x61, 0x74,
      0x20, 0x66, 0x75, 0x6e, 0x6b, 0x79, 0x20, 0x6d, 0x75, 0x73, 0x69, 0x63,
      0x20, 0x74, 0x69, 0x6c, 0x6c, 0x20, 0x79, 0x6f, 0x75, 0x20, 0x64, 0x69,
      0x65, 0x2e, 0x20, 0x0a, 0x0a, 0x50, 0x6c, 0x61, 0x79, 0x20, 0x74, 0x68,
      0x61, 0x74, 0x20, 0x66, 0x75, 0x6e, 0x6b, 0x79, 0x20, 0x6d, 0x75, 0x73,
      0x69, 0x63, 0x20, 0x43, 0x6f, 0x6d, 0x65, 0x20, 0x6f, 0x6e, 0x2c, 0x20,
      0x43, 0x6f, 0x6d, 0x65, 0x20, 0x6f, 0x6e, 0x2c, 0x20, 0x6c, 0x65, 0x74,
      0x20, 0x6d, 0x65, 0x20, 0x68, 0x65, 0x61, 0x72, 0x20, 0x0a, 0x50, 0x6c,
      0x61, 0x79, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x66, 0x75, 0x6e, 0x6b,
      0x79, 0x20, 0x6d, 0x75, 0x73, 0x69, 0x63, 0x20, 0x77, 0x68, 0x69, 0x74,
      0x65, 0x20, 0x62, 0x6f, 0x79, 0x20, 0x79, 0x6f, 0x75, 0x20, 0x73, 0x61,
      0x79, 0x20, 0x69, 0x74, 0x2c, 0x20, 0x73, 0x61, 0x79, 0x20, 0x69, 0x74,
      0x20, 0x0a, 0x50, 0x6c, 0x61, 0x79, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20,
      0x66, 0x75, 0x6e, 0x6b, 0x79, 0x20, 0x6d, 0x75, 0x73, 0x69, 0x63, 0x20,
      0x41, 0x20, 0x6c, 0x69, 0x74, 0x74, 0x6c, 0x65, 0x20, 0x6c, 0x6f, 0x75,
      0x64, 0x65, 0x72, 0x20, 0x6e, 0x6f, 0x77, 0x20, 0x0a, 0x50, 0x6c, 0x61,
      0x79, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x66, 0x75, 0x6e, 0x6b, 0x79,
      0x20, 0x6d, 0x75, 0x73, 0x69, 0x63, 0x2c, 0x20, 0x77, 0x68, 0x69, 0x74,
      0x65, 0x20, 0x62, 0x6f, 0x79, 0x20, 0x43, 0x6f, 0x6d, 0x65, 0x20, 0x6f,
      0x6e, 0x2c, 0x20, 0x43, 0x6f, 0x6d, 0x65, 0x20, 0x6f, 0x6e, 0x2c, 0x20,
      0x43, 0x6f, 0x6d, 0x65, 0x20, 0x6f, 0x6e, 0x20, 0x0a, 0x50, 0x6c, 0x61,
      0x79, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x66, 0x75, 0x6e, 0x6b, 0x79,
      0x20, 0x6d, 0x75, 0x73, 0x69, 0x63, 0x20, 0x0a
    },
    {
      'T', 'e', 'r', 'm', 'i', 'n', 'a', 't', 'o', 'r', ' ', 'X', ':', ' ',
      'B', 'r', 'i', 'n', 'g', ' ', 't', 'h', 'e', ' ', 'n', 'o', 'i', 's', 'e'
    }
  }
};

TEST(cipheyCore, xorcryptLen) {
  for (auto& test : xorcrypt_tests) {
    auto x = ciphey::xorcrypt_guess_len(test.ctext);

    EXPECT_EQ(x, test.key.size());
  }
}

TEST(cipheyCore, xorcryptMetaTest) {
  for (auto& test : xorcrypt_tests) {
    auto res = ciphey::analyse_bytes(test.ptext);
    auto assoc = ciphey::create_assoc_table(ciphey::freq_conv(res->freqs), ciphey::test::expected());
    auto stat = ciphey::gof_test(assoc, test.ptext.size());
    auto p_value = 1 - ciphey::chisq_cdf(assoc.size(), stat);

    EXPECT_GT(p_value, ciphey::default_p_value);
  }
}

TEST(cipheyCore, xorcrypt) {
  for (auto& test : xorcrypt_tests) {
    for (size_t i = 1; i < 16; ++i) {
      if (i == test.key.size())
        continue;
      auto analysis = ciphey::analyse_bytes(test.ctext, i);
      auto res = ciphey::xorcrypt_crack(analysis, ciphey::test::expected());
      if (res.size() != 0)
        std::cerr << "Incorrect key size " << i << " has " << res.size() << " results" << std::endl;
    }

    auto analysis = ciphey::analyse_bytes(test.ctext, test.key.size());

    auto res = ciphey::xorcrypt_crack(analysis, ciphey::test::expected());

    for (size_t i = 0; i < res.size(); ++i) {
      if (std::equal(test.key.begin(), test.key.end(), res[i].key.begin())) {
        std::cerr << "True key had p-value of " << res[i].p_value << " and was position " << i << std::endl;
        goto found;
      }
    }
    EXPECT_TRUE(false) << "Key was not found";
    found:

    auto ptext_res = ciphey::xorcrypt_decrypt(test.ctext, test.key);
    EXPECT_TRUE(std::equal(ptext_res.begin(), ptext_res.end(), test.ptext.begin()));

    ptext_res = ciphey::xorcrypt_encrypt(ptext_res, test.key);
    EXPECT_TRUE(std::equal(ptext_res.begin(), ptext_res.end(), test.ctext.begin()));
  }
//  EXPECT_EQ(analysis, 29);
}

