/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

import { Disposable } from '../../../../../../../base/common/lifecycle.js';
import { Schemas } from '../../../../../../../base/common/network.js';
import { URI } from '../../../../../../../base/common/uri.js';
import { ILanguageService } from '../../../../../../../editor/common/languages/language.js';
import { ITextModel } from '../../../../../../../editor/common/model.js';
import { IModelService } from '../../../../../../../editor/common/services/model.js';
import { ITextModelContentProvider, ITextModelService } from '../../../../../../../editor/common/services/resolverService.js';


export class ChatInputBoxContentProvider extends Disposable implements ITextModelContentProvider {
	constructor(
		@ITextModelService textModelService: ITextModelService,
		@IModelService private readonly modelService: IModelService,
		@ILanguageService private readonly languageService: ILanguageService
	) {
		super();
		this._register(textModelService.registerTextModelContentProvider(Schemas.vscodeChatInput, this));
	}

	async provideTextContent(resource: URI): Promise<ITextModel | null> {
		const existing = this.modelService.getModel(resource);
		if (existing) {
			return existing;
		}
		return this.modelService.createModel('', this.languageService.createById('chatinput'), resource);
	}
}
