#!/usr/bin/env bash

. ./lib

rm -rf temp1 temp2
mkdir temp1 temp2

cd temp2
darcs init

# setup test
cd ../temp1
darcs init
touch foo bar
darcs add foo bar
darcs record -a -m add_foo_bar -A x

# Test that --cc is also printed as recipient in case of success
export SENDMAIL=true
darcs send --mail --author=me -a --to=random@random --cc=foo@example.com ../temp2 >out
grep 'foo@example.com' out

# Test that --cc is also printed as recipient in case of error
export SENDMAIL=false
not darcs send --mail --author=me -a --to=random@random --cc=foo@example.com ../temp2 2>err
grep 'foo@example.com' err

cd ..
