/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.lsm.sql.impl.syntax;

import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerException;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.tree.Tree;
import org.antlr.v4.runtime.tree.Trees;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.lsm.LSMAnalyzerParameters;
import org.jkiss.dbeaver.model.lsm.sql.impl.syntax.SQLStandardLexer;
import org.jkiss.dbeaver.model.lsm.sql.impl.syntax.SQLStandardParser;
import org.jkiss.dbeaver.model.stm.LSMInspections;
import org.jkiss.dbeaver.model.stm.STMErrorListener;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SyntaxParserTest {
    private static final Log log = Log.getLog(SyntaxParserTest.class);

    public static void main(String[] args) throws IOException, XMLStreamException, FactoryConfigurationError, TransformerException {
        String inputText = "SELECT ALL Product.*, \r\n    Product.ProductID AS id,\r\n    Product.Name AS ProductName,\r\n    Product.ProductNumber,\r\n    ProductCategory.Name AS ProductCategory,\r\n    ProductSubCategory.Name AS ProductSubCategory,\r\n    Product.ProductModelID\r\nFROM Production.Product AS Prod(ProductID, Name, ProductNumber), T as A, \r\ns -- ololo\r\n.c -- ololo\r\n.t -- ololo\r\nas x\r\nINNER JOIN Production.ProductSubCategory as A2\r\nINNER JOIN (SELECT column_name FROM sch.table_name INNER JOIN T2 as A22 WHERE id > 3) as A3\r\nON ProductSubCategory.ProductSubcategoryID = Product.ProductSubcategoryID\r\nUNION JOIN Cat.Production.ProductCategory\r\nUSING(ProductCategoryID)\r\nGROUP BY ProductName\r\nORDER BY Product.ModifiedDate DESC";
        CodePointCharStream input = CharStreams.fromString((String)inputText);
        LSMAnalyzerParameters params = new LSMAnalyzerParameters(Map.of("\"", "\""), true, false, '?', List.of(Map.entry(1, Set.of(":"))), true);
        SQLStandardLexer ll = new SQLStandardLexer((CharStream)input, params);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)ll);
        tokens.fill();
        SQLStandardParser pp = new SQLStandardParser((TokenStream)tokens, params);
        pp.addErrorListener(new STMErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException re) {
                String sourceName = recognizer.getInputStream().getSourceName();
                if (!sourceName.isEmpty()) {
                    sourceName = String.format("%s:%d:%d: ", sourceName, line, charPositionInLine);
                }
                System.out.println(sourceName + " line " + line + ":" + charPositionInLine + " " + msg);
            }

            public void reportContextSensitivity(Parser arg0, DFA arg1, int arg2, int arg3, int arg4, ATNConfigSet arg5) {
            }

            public void reportAttemptingFullContext(Parser arg0, DFA arg1, int arg2, int arg3, BitSet arg4, ATNConfigSet arg5) {
            }

            public void reportAmbiguity(Parser arg0, DFA arg1, int arg2, int arg3, boolean arg4, BitSet arg5, ATNConfigSet arg6) {
            }
        });
        SQLStandardParser.SqlQueriesContext tree = pp.sqlQueries();
        String str = tree.getTextContent();
        System.out.println(str);
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        SyntaxParserTest.collect(tree, pp, sb, "");
        System.out.println(sb.toString());
        int pos = 36;
        System.out.println(LSMInspections.prepareTerms(tree));
    }

    public static String collect(STMTreeNode ctx) {
        CodePointCharStream input = CharStreams.fromString((String)"");
        LSMAnalyzerParameters params = new LSMAnalyzerParameters(Map.of("\"", "\""), true, false, '?', List.of(Map.entry(1, Set.of(":"))), true);
        SQLStandardLexer ll = new SQLStandardLexer((CharStream)input, params);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)ll);
        SQLStandardParser pp = new SQLStandardParser((TokenStream)tokens, params);
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        SyntaxParserTest.collect(ctx, pp, sb, "");
        return sb.toString();
    }

    private static void collect(STMTreeNode ctx, Parser pp, StringBuilder sb, String indent) {
        Object object;
        sb.append(indent).append(Trees.getNodeText((Tree)ctx, (Parser)pp));
        while (ctx.getChildCount() == 1 && !(ctx.getChild(0).getPayload() instanceof Token)) {
            ctx = ctx.getChildNode(0);
            sb.append(".").append(Trees.getNodeText((Tree)ctx, (Parser)pp));
        }
        sb.append(" [").append(ctx.getRealInterval()).append("]\n");
        if (ctx.getChildCount() == 1 && (object = ctx.getChild(0).getPayload()) instanceof Token) {
            Token t = (Token)object;
            sb.append(indent).append("    ").append(pp.getVocabulary().getDisplayName(t.getType())).append(" \"").append(Trees.getNodeText((Tree)ctx.getChild(0), (Parser)pp)).append("\" [").append(ctx.getChildNode(0).getRealInterval()).append("]\n");
        } else {
            for (STMTreeNode t : ctx.getChildren()) {
                SyntaxParserTest.collect(t, pp, sb, indent + "    ");
            }
        }
    }
}

