/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDValueRow;

public class ResultSetRow
implements DBDValueRow {
    public static final byte STATE_NORMAL = 1;
    public static final byte STATE_ADDED = 2;
    public static final byte STATE_REMOVED = 3;
    private final Map<DBDAttributeBinding, Object> changes = new HashMap<DBDAttributeBinding, Object>();
    private int rowNumber;
    private int visualNumber;
    @NotNull
    public Object[] values;
    private byte state;
    @Nullable
    public ColorInfo colorInfo;

    ResultSetRow(int rowNumber, @NotNull Object[] values) {
        this.rowNumber = rowNumber;
        this.visualNumber = rowNumber;
        this.values = values;
        this.state = 1;
    }

    @NotNull
    public Object[] getValues() {
        return this.values;
    }

    public boolean isChanged() {
        return !this.changes.isEmpty();
    }

    public boolean isChanged(@Nullable DBDAttributeBinding attr) {
        return attr != null && this.changes.containsKey(attr);
    }

    public int getChangesCount() {
        return this.changes.size();
    }

    @NotNull
    public Collection<DBDAttributeBinding> getChangedAttributes() {
        return this.changes.keySet();
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public void setRowNumber(int rowNumber) {
        this.rowNumber = rowNumber;
    }

    public int getVisualNumber() {
        return this.visualNumber;
    }

    public void setVisualNumber(int visualNumber) {
        this.visualNumber = visualNumber;
    }

    public byte getState() {
        return this.state;
    }

    public void setState(byte state) {
        this.state = state;
    }

    public void addChange(@NotNull DBDAttributeBinding attr, @Nullable Object oldValue) {
        this.changes.put(attr, oldValue);
    }

    @Nullable
    public Object getChange(@NotNull DBDAttributeBinding attr) {
        return this.changes.get(attr);
    }

    @NotNull
    public Iterable<Map.Entry<DBDAttributeBinding, Object>> getChanges() {
        return () -> this.changes.entrySet().iterator();
    }

    public void clearChange(@NotNull DBDAttributeBinding attr) {
        this.changes.remove(attr);
        this.changes.entrySet().removeIf(entry -> attr.equals(entry.getValue()));
    }

    public void clearChanges() {
        this.changes.clear();
    }

    void release() {
        for (Object value : this.values) {
            DBUtils.releaseValue((Object)value);
        }
        for (Object e : this.changes.values()) {
            DBUtils.releaseValue(e);
        }
    }

    public String toString() {
        return String.valueOf(this.rowNumber);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResultSetRow) {
            ResultSetRow row = (ResultSetRow)obj;
            return this.rowNumber == row.rowNumber && this.visualNumber == row.visualNumber;
        }
        return super.equals(obj);
    }

    public static class ColorInfo {
        @Nullable
        public Color rowForeground;
        @Nullable
        public Color rowBackground;
        @Nullable
        public Color[] cellFgColors;
        @Nullable
        public Color[] cellBgColors;
    }
}

