/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBIconComposite;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueDefaultGenerator;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.registry.ApplicationPolicyProvider;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferProducer;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.contentassist.ContentAssistUtils;
import org.jkiss.dbeaver.ui.contentassist.ContentProposalExt;
import org.jkiss.dbeaver.ui.contentassist.SmartTextContentAdapter;
import org.jkiss.dbeaver.ui.controls.StyledTextUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetEditor;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetProvider;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCellLocation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCopySettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetDataContainer;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetDataContainerOptions;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetSaveReport;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetSaveSettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetValueController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.handler.ResultSetHandlerCopyAs;
import org.jkiss.dbeaver.ui.controls.resultset.handler.ResultSetHandlerCopySpecial;
import org.jkiss.dbeaver.ui.controls.resultset.handler.ResultSetHandlerOpenWith;
import org.jkiss.dbeaver.ui.controls.resultset.handler.SaveScriptDialog;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.SpreadsheetPresentation;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.managers.BaseValueManager;
import org.jkiss.dbeaver.ui.editors.MultiPageAbstractEditor;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class ResultSetHandlerMain
extends AbstractHandler
implements IElementUpdater {
    @Nullable
    public static IResultSetController getActiveResultSet(@Nullable IWorkbenchPart activePart) {
        return ResultSetHandlerMain.getActiveResultSet(activePart, false);
    }

    public static IResultSetController getActiveResultSet(@Nullable IWorkbenchPart activePart, boolean underMouseCursor) {
        Shell shell;
        IWorkbenchPartSite site;
        if (activePart != null && (site = activePart.getSite()) != null && site.getPart() != null && PlatformUI.isWorkbenchRunning() && (shell = site.getShell()) != null) {
            Control focusControl;
            Display display = shell.getDisplay();
            Control control = focusControl = underMouseCursor ? display.getCursorControl() : display.getFocusControl();
            while (focusControl != null) {
                ResultSetViewer viewer = (ResultSetViewer)focusControl.getData(ResultSetViewer.CONTROL_ID);
                if (viewer != null) {
                    return viewer;
                }
                focusControl = focusControl.getParent();
            }
        }
        if (activePart instanceof IResultSetProvider) {
            return ((IResultSetProvider)activePart).getResultSetController();
        }
        if (activePart instanceof MultiPageAbstractEditor) {
            return ResultSetHandlerMain.getActiveResultSet((IWorkbenchPart)((MultiPageAbstractEditor)activePart).getActiveEditor());
        }
        if (activePart != null) {
            return (IResultSetController)activePart.getAdapter(IResultSetController.class);
        }
        return null;
    }

    @Nullable
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart == null) {
            return null;
        }
        final ResultSetViewer rsv = (ResultSetViewer)ResultSetHandlerMain.getActiveResultSet(activePart);
        if (rsv == null) {
            return null;
        }
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        String actionId = event.getCommand().getId();
        IResultSetPresentation presentation = rsv.getActivePresentation();
        DBPDataSource dataSource = rsv.getDataSource();
        switch (actionId) {
            case "org.eclipse.ui.file.refresh": {
                rsv.refreshData(null);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.toggleMode": {
                rsv.toggleMode();
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.grid.togglePreview": {
                rsv.showPanels(!rsv.isPanelsVisible(), true, true);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.grid.activatePreview": {
                rsv.togglePanelsFocus();
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.grid.togglePanelMaximize": {
                rsv.togglePanelsMaximize();
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.grid.toggleLayout": {
                rsv.toggleVerticalLayout();
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.focus.filter": {
                rsv.switchFilterFocus();
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.switchPresentation": {
                rsv.switchPresentation();
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.row.previous": 
            case "org.eclipse.ui.edit.text.goto.wordPrevious": {
                presentation.scrollToRow(IResultSetPresentation.RowPosition.PREVIOUS);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.row.next": 
            case "org.eclipse.ui.edit.text.goto.wordNext": {
                presentation.scrollToRow(IResultSetPresentation.RowPosition.NEXT);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.row.first": 
            case "org.eclipse.ui.edit.text.select.wordPrevious": {
                presentation.scrollToRow(IResultSetPresentation.RowPosition.FIRST);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.row.last": 
            case "org.eclipse.ui.edit.text.select.wordNext": {
                presentation.scrollToRow(IResultSetPresentation.RowPosition.LAST);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.fetch.page": {
                rsv.readNextSegment();
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.fetch.all": {
                rsv.readAllData();
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.row.edit": {
                if (!(presentation instanceof IResultSetEditor)) break;
                IResultSetEditor rse = (IResultSetEditor)((Object)presentation);
                rse.openValueEditor(false);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.row.edit.inline": {
                if (!(presentation instanceof IResultSetEditor)) break;
                IResultSetEditor rse = (IResultSetEditor)((Object)presentation);
                rse.openValueEditor(true);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.row.add": 
            case "org.jkiss.dbeaver.core.resultset.row.copy": {
                boolean copy = actionId.equals("org.jkiss.dbeaver.core.resultset.row.copy");
                boolean shiftPressed = event.getTrigger() instanceof Event && (((Event)event.getTrigger()).stateMask & 0x20000) == 131072;
                IResultSetController.RowPlacement placement = rsv.getPreferenceStore().getBoolean("resultset.edit.new.row.after") ^ shiftPressed ? IResultSetController.RowPlacement.AFTER_SELECTION : IResultSetController.RowPlacement.BEFORE_SELECTION;
                rsv.addNewRow(placement, copy, true);
                rsv.getActivePresentation().getControl().setFocus();
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.row.copy.from.above": 
            case "org.jkiss.dbeaver.core.resultset.row.copy.from.below": {
                rsv.copyRowValues(actionId.equals("org.jkiss.dbeaver.core.resultset.row.copy.from.above"), true);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.row.delete": 
            case "org.eclipse.ui.edit.delete": {
                UIUtils.asyncExec(rsv::deleteSelectedRows);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.cell.setNull": 
            case "org.jkiss.dbeaver.core.resultset.cell.setDefault": 
            case "org.jkiss.dbeaver.core.resultset.cell.reset": {
                IResultSetSelection selection = rsv.getSelection();
                for (Object cell : selection.toArray()) {
                    DBDAttributeBinding attr = selection.getElementAttribute(cell);
                    ResultSetRow row = selection.getElementRow(cell);
                    if (row == null || attr == null || DBExecUtils.isAttributeReadOnly((DBDAttributeBinding)attr)) continue;
                    ResultSetValueController valueController = new ResultSetValueController(rsv, new ResultSetCellLocation(attr, row, selection.getElementRowIndexes(cell)), IValueController.EditType.NONE, null);
                    if (actionId.equals("org.jkiss.dbeaver.core.resultset.cell.setNull")) {
                        valueController.updateValue(BaseValueManager.makeNullValue(valueController), false);
                        continue;
                    }
                    if (actionId.equals("org.jkiss.dbeaver.core.resultset.cell.setDefault")) {
                        DBDValueHandler valueHandler = valueController.getValueHandler();
                        if (!(valueHandler instanceof DBDValueDefaultGenerator)) continue;
                        DBDValueDefaultGenerator vdg = (DBDValueDefaultGenerator)valueHandler;
                        if (rsv.getExecutionContext() == null) continue;
                        try (DBCSession session = rsv.getExecutionContext().openSession((DBRProgressMonitor)new VoidProgressMonitor(), DBCExecutionPurpose.UTIL, "Generate default value");){
                            Object defValue = vdg.generateDefaultValue(session, valueController.getValueType());
                            valueController.updateValue(defValue, false);
                            continue;
                        }
                    }
                    rsv.resetCellValue(attr, row, selection.getElementRowIndexes(cell));
                }
                rsv.redrawData(false, false);
                rsv.updatePanelsContent(false);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.applyChanges": 
            case "org.jkiss.dbeaver.core.resultset.applyAndCommitChanges": {
                if (dataSource == null) {
                    return null;
                }
                ResultSetSaveSettings saveSettings = new ResultSetSaveSettings();
                rsv.applyChanges(null, saveSettings);
                if (!actionId.equals("org.jkiss.dbeaver.core.resultset.applyAndCommitChanges")) break;
                ActionUtils.runCommand((String)"org.jkiss.dbeaver.core.commit", (IServiceLocator)rsv.getSite());
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.rejectChanges": {
                rsv.rejectChanges();
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.generateScript": {
                ResultSetSaveReport saveReport = rsv.generateChangesReport();
                if (saveReport == null) {
                    return null;
                }
                ResultSetSaveSettings saveSettings = this.showPreviewScript(rsv, saveReport);
                if (saveSettings == null) break;
                rsv.applyChanges(null, saveSettings);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.toggleConfirmSave": {
                DBPPreferenceStore store = rsv.getPreferenceStore();
                store.setValue("resultset.confirm.beforeSave", !store.getBoolean("resultset.confirm.beforeSave"));
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.grid.copyColumnNames": {
                List<DBDAttributeBinding> attrs;
                StringBuilder buffer = new StringBuilder();
                String columnNames = event.getParameter("columns");
                IResultSetSelection selection = rsv.getSelection();
                List<DBDAttributeBinding> list = attrs = selection.isEmpty() ? rsv.getModel().getVisibleAttributes() : selection.getSelectedAttributes();
                if (!CommonUtils.isEmpty((String)columnNames) && attrs.size() == 1) {
                    attrs = new ArrayList<DBDAttributeBinding>();
                    for (String colName : columnNames.split(",")) {
                        for (DBDAttributeBinding attr : rsv.getModel().getVisibleAttributes()) {
                            if (!colName.equals(attr.getName())) continue;
                            attrs.add(attr);
                        }
                    }
                }
                ResultSetCopySettings settings = new ResultSetCopySettings();
                if (attrs.size() > 1) {
                    ResultSetHandlerCopySpecial.CopyConfigDialog configDialog = new ResultSetHandlerCopySpecial.CopyConfigDialog(activeShell, "CopyGridNamesOptionsDialog");
                    if (configDialog.open() != 0) {
                        return null;
                    }
                    settings = configDialog.copySettings;
                }
                for (DBDAttributeBinding attr : attrs) {
                    String colName;
                    if (!buffer.isEmpty()) {
                        buffer.append(settings.getColumnDelimiter());
                    }
                    if (CommonUtils.isEmpty((String)(colName = attr.getLabel()))) {
                        colName = attr.getName();
                    }
                    if (dataSource == null) {
                        buffer.append(colName);
                        continue;
                    }
                    buffer.append(DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)colName));
                }
                ResultSetUtils.copyToClipboard(buffer.toString());
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.grid.copyRowNames": {
                StringBuilder buffer = new StringBuilder();
                List<ResultSetRow> selectedRows = rsv.getSelection().getSelectedRows();
                ResultSetCopySettings settings = new ResultSetCopySettings();
                if (selectedRows.size() > 1) {
                    Object configDialog = new ResultSetHandlerCopySpecial.CopyConfigDialog(activeShell, "CopyGridNamesOptionsDialog");
                    if (configDialog.open() != 0) {
                        return null;
                    }
                    settings = ((ResultSetHandlerCopySpecial.CopyConfigDialog)((Object)configDialog)).copySettings;
                }
                for (ResultSetRow row : selectedRows) {
                    if (!buffer.isEmpty()) {
                        buffer.append(settings.getRowDelimiter());
                    }
                    buffer.append(row.getVisualNumber() + 1);
                }
                ResultSetUtils.copyToClipboard(buffer.toString());
                break;
            }
            case "org.eclipse.ui.edit.copy": {
                if (ApplicationPolicyProvider.getInstance().isPolicyEnabled("policy.data.copy.disabled")) {
                    UIUtils.showMessageBox((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)UIMessages.dialog_policy_data_copy_title, (String)UIMessages.dialog_policy_data_copy_msg, (int)8);
                    break;
                }
                ResultSetUtils.copyToClipboard(presentation.copySelection(new ResultSetCopySettings(false, false, false, true, false, null, null, null, DBDDisplayFormat.EDIT)));
                break;
            }
            case "org.eclipse.ui.edit.paste": {
                if (!(presentation instanceof IResultSetEditor)) break;
                IResultSetEditor rse = (IResultSetEditor)((Object)presentation);
                rse.pasteFromClipboard(null);
                break;
            }
            case "org.eclipse.ui.edit.cut": {
                ResultSetUtils.copyToClipboard(presentation.copySelection(new ResultSetCopySettings(false, false, true, true, false, null, null, null, DBDDisplayFormat.EDIT)));
                break;
            }
            case "org.eclipse.ui.file.print": {
                presentation.printResultSet();
                break;
            }
            case "org.eclipse.ui.edit.text.smartEnter": {
                if (!(presentation instanceof IResultSetEditor)) break;
                IResultSetEditor rse = (IResultSetEditor)((Object)presentation);
                rse.openValueEditor(false);
                break;
            }
            case "org.eclipse.ui.edit.findReplace": {
                IAction action = StyledTextUtils.createFindReplaceAction((Shell)activeShell, (IFindReplaceTarget)rsv.getAdapter(IFindReplaceTarget.class));
                action.run();
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.navigateLink": {
                final DBDAttributeBinding attr = rsv.getActivePresentation().getCurrentAttribute();
                if (attr == null) break;
                new AbstractJob(this, "Navigate association"){

                    @NotNull
                    protected IStatus run(@NotNull DBRProgressMonitor monitor) {
                        try {
                            rsv.navigateAssociation(monitor, rsv.getModel(), DBExecUtils.getAssociationByAttribute((DBDAttributeBinding)attr), rsv.getSelection().getSelectedRows(), false);
                        }
                        catch (DBException e) {
                            return GeneralUtils.makeExceptionStatus((Throwable)e);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.count": {
                rsv.updateRowCount(true);
                break;
            }
            case "org.eclipse.ui.navigate.backwardHistory": {
                int hp = rsv.getHistoryPosition();
                if (hp <= 0) break;
                rsv.navigateHistory(hp - 1);
                break;
            }
            case "org.eclipse.ui.navigate.forwardHistory": {
                int hp = rsv.getHistoryPosition();
                if (hp >= rsv.getHistorySize() - 1) break;
                rsv.navigateHistory(hp + 1);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.grid.gotoRow": {
                ResultSetRow currentRow = rsv.getCurrentRow();
                int rowCount = rsv.getModel().getRowCount();
                if (rowCount <= 0) break;
                GotoLineDialog d = new GotoLineDialog(activeShell, "Go to Row", "Enter row number (1.." + rowCount + ")", String.valueOf(currentRow == null ? 1 : currentRow.getVisualNumber() + 1), input -> {
                    try {
                        int i = Integer.parseInt(input);
                        if (i <= 0 || rowCount < i) {
                            return "Row number is out of range";
                        }
                    }
                    catch (NumberFormatException x) {
                        return "Not a number";
                    }
                    return null;
                });
                if (d.open() != 0) break;
                int line = Integer.parseInt(d.getValue());
                rsv.setCurrentRow(rsv.getModel().getRow(line - 1));
                rsv.getActivePresentation().scrollToRow(IResultSetPresentation.RowPosition.CURRENT);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.grid.gotoColumn": {
                DBDAttributeBinding currentAttribute = rsv.getActivePresentation().getCurrentAttribute();
                DBDAttributeBinding targetAttribute = ResultSetHandlerMain.askForColumnToGo(activeShell, currentAttribute, rsv.getModel().getAttributes());
                if (targetAttribute == null) break;
                rsv.getActivePresentation().setCurrentAttribute(targetAttribute);
                rsv.getActivePresentation().scrollToRow(IResultSetPresentation.RowPosition.CURRENT);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.filterMenu": {
                rsv.showFiltersMenu();
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.filterMenu.distinct": {
                DBDAttributeBinding curAttribute = rsv.getActivePresentation().getFocusAttribute();
                if (curAttribute == null) break;
                rsv.showFiltersDistinctMenu(curAttribute, true);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.filterSettings": {
                rsv.showFilterSettingsDialog();
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.filterSave": {
                rsv.saveDataFilter();
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.filterClear": {
                rsv.clearDataFilter(true);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.referencesMenu": {
                boolean shiftPressed = event.getTrigger() instanceof Event && (((Event)event.getTrigger()).stateMask & 0x20000) == 131072;
                rsv.showReferencesMenu(shiftPressed);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.export": {
                String defProc;
                if (ApplicationPolicyProvider.getInstance().isPolicyEnabled("policy.data.export.disabled")) {
                    UIUtils.showMessageBox((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)UIMessages.dialog_policy_data_export_title, (String)UIMessages.dialog_policy_data_export_msg, (int)8);
                    break;
                }
                if (event.getParameter("exportWithParameter") != null && !CommonUtils.isEmpty((String)(defProc = ResultSetHandlerOpenWith.getDefaultOpenWithProcessor()))) {
                    ActionUtils.runCommand((String)"org.jkiss.dbeaver.core.resultset.openWith", null, Map.of("processorId", defProc), (IServiceLocator)rsv.getSite());
                    return null;
                }
                ArrayList<Integer> selectedRows = new ArrayList<Integer>();
                for (ResultSetRow selectedRow : rsv.getSelection().getSelectedRows()) {
                    selectedRows.add(selectedRow.getRowNumber());
                }
                ResultSetDataContainerOptions options = new ResultSetDataContainerOptions();
                options.setSelectedRows(selectedRows);
                options.setSelectedColumns(rsv.getSelection().getSelectedAttributes());
                ResultSetDataContainer dataContainer = new ResultSetDataContainer(rsv, options);
                DataTransferWizard.openWizard((IWorkbenchWindow)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event), Collections.singletonList(new DatabaseTransferProducer((DBSDataContainer)dataContainer, rsv.getModel().getDataFilter())), null, (IStructuredSelection)rsv.getSelection(), (boolean)true);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.zoomIn": 
            case "org.jkiss.dbeaver.core.resultset.zoomOut": {
                FontRegistry fontRegistry = UIUtils.getCurrentTheme().getFontRegistry();
                Font font = fontRegistry.get(presentation.getFontId());
                if (font == null) break;
                FontData[] fondData = font.getFontData();
                int zoomFactor = actionId.equals("org.jkiss.dbeaver.core.resultset.zoomIn") ? 1 : -1;
                FontDescriptor fd = this.createFontDescriptor(fondData, zoomFactor);
                fontRegistry.put(presentation.getFontId(), fd.getFontData());
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.toggleOrder": {
                DBDAttributeBinding attr = rsv.getActivePresentation().getFocusAttribute();
                if (attr == null) break;
                rsv.toggleSortOrder(attr, null);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.grid.selectRowColor": {
                ResultSetViewer resultSetViewer = (ResultSetViewer)activePart.getAdapter(ResultSetViewer.class);
                if (!(presentation instanceof SpreadsheetPresentation)) break;
                SpreadsheetPresentation ssp = (SpreadsheetPresentation)presentation;
                UIUtils.asyncExec(() -> {
                    ColorDialog dialog = new ColorDialog(UIUtils.createCenteredShell((Shell)resultSetViewer.getControl().getShell()));
                    RGB color = dialog.open();
                    if (color != null) {
                        DBVEntity vEntity = this.getColorsVirtualEntity(resultSetViewer);
                        DBDAttributeBinding attr = rsv.getActivePresentation().getCurrentAttribute();
                        ResultSetCellLocation cellLocation = ssp.getCurrentCellLocation();
                        Object cellValue = resultSetViewer.getContainer().getResultSetController().getModel().getCellValue(cellLocation);
                        vEntity.setColorOverride(attr, cellValue, null, StringConverter.asString((RGB)color));
                        this.updateColors(resultSetViewer, vEntity, true);
                    }
                });
            }
        }
        return null;
    }

    private ResultSetSaveSettings showPreviewScript(ResultSetViewer rsv, ResultSetSaveReport saveReport) {
        SaveScriptDialog scriptDialog = new SaveScriptDialog(rsv, saveReport);
        if (scriptDialog.open() == 0) {
            return scriptDialog.getSaveSettings();
        }
        return null;
    }

    private FontDescriptor createFontDescriptor(FontData[] initialFontData, int fFontSizeOffset) {
        int destFontSize = initialFontData[0].getHeight() + fFontSizeOffset;
        if (destFontSize <= 0) {
            return FontDescriptor.createFrom((FontData[])initialFontData);
        }
        return FontDescriptor.createFrom((FontData[])initialFontData).setHeight(destFontSize);
    }

    public void updateElement(UIElement element, Map parameters) {
        if (parameters.get("exportWithParameter") != null) {
            String processorId = ResultSetHandlerOpenWith.getDefaultOpenWithProcessor();
            DataTransferProcessorDescriptor descriptor = ResultSetHandlerCopyAs.getActiveProcessor(processorId);
            if (descriptor == null) {
                element.setText(ActionUtils.findCommandName((String)"org.jkiss.dbeaver.core.resultset.export"));
                element.setIcon(ActionUtils.findCommandImage((String)"org.jkiss.dbeaver.core.resultset.export"));
                element.setTooltip(ActionUtils.findCommandDescription((String)"org.jkiss.dbeaver.core.resultset.export", (IServiceLocator)element.getServiceLocator(), (boolean)false));
            } else {
                element.setText(descriptor.getAppName());
                element.setIcon(DBeaverIcons.getImageDescriptor((DBPImage)descriptor.getIcon()));
                element.setTooltip(descriptor.getDescription());
            }
        }
    }

    private void updateColors(ResultSetViewer resultSetViewer, DBVEntity entity, boolean refresh) {
        resultSetViewer.getModel().updateColorMapping(entity, true);
        entity.persistConfiguration();
        if (refresh) {
            resultSetViewer.redrawData(false, false);
        }
    }

    @NotNull
    private DBVEntity getColorsVirtualEntity(ResultSetViewer resultSetViewer) throws IllegalStateException {
        DBSDataContainer dataContainer = resultSetViewer.getDataContainer();
        if (dataContainer == null) {
            throw new IllegalStateException("No data container");
        }
        return DBVUtils.getVirtualEntity((DBSDataContainer)dataContainer, (boolean)true);
    }

    @NotNull
    private static DBPImage obtainAttributeIcon(@NotNull DBDAttributeBinding attr) {
        DBPImage image = DBValueFormatting.getObjectImage((DBPObject)attr.getAttribute());
        if (DBExecUtils.isAttributeReadOnly((DBDAttributeBinding)attr)) {
            image = new DBIconComposite(image, false, null, null, null, (DBPImage)DBIcon.OVER_LOCK);
        }
        return image;
    }

    @Nullable
    private static DBDAttributeBinding askForColumnToGo(@NotNull Shell activeShell, @Nullable DBDAttributeBinding currentAttribute, @NotNull DBDAttributeBinding[] attributes) {
        IContentProposalProvider proposalProvider;
        Map<String, Pair> attrsByName;
        IInputValidator inputValidator;
        String DIALOG_ID = "ResultSetHandlerMain.GotoColumnDialog";
        String initialValue = currentAttribute != null ? currentAttribute.getName() : "";
        InputDialog dialog = new InputDialog(activeShell, ResultSetMessages.results_goto_column_dialog_title, ResultSetMessages.results_goto_column_dialog_message, initialValue, inputValidator = arg_0 -> ResultSetHandlerMain.lambda$askForColumnToGo$5(attrsByName = Arrays.stream(attributes).collect(Collectors.toMap(a -> a.getName().toUpperCase(), a -> new Pair(a, (Object)new ContentProposalExt(a.getName(), a.getLabel(), a.getDescription(), ResultSetHandlerMain.obtainAttributeIcon(a))), (x, y) -> x)), attributes, arg_0), proposalProvider = (contents, position) -> {
            String pattern = contents.substring(0, position).toUpperCase();
            List entries = attrsByName.entrySet().stream().filter(kv -> ((String)kv.getKey()).contains(pattern)).map(kv -> (IContentProposal)((Pair)kv.getValue()).getSecond()).collect(Collectors.toCollection(() -> new ArrayList(attrsByName.size())));
            entries.sort((a, b) -> {
                boolean ys;
                String x = a.getContent();
                String y = b.getContent();
                boolean xs = x.startsWith(pattern);
                return xs ^ (ys = y.startsWith(pattern)) ? (xs ? -1 : 1) : x.compareToIgnoreCase(y);
            });
            return entries.toArray(new IContentProposal[0]);
        }){
            final /* synthetic */ IContentProposalProvider val$proposalProvider;
            {
                this.val$proposalProvider = iContentProposalProvider;
                super(arg0, arg1, arg2, arg3, arg4);
            }

            protected Control createDialogArea(Composite parent) {
                Control result = super.createDialogArea(parent);
                ContentAssistUtils.installContentProposal((Control)this.getText(), (IControlContentAdapter)new SmartTextContentAdapter(), (IContentProposalProvider)this.val$proposalProvider, null, (Boolean)true, (boolean)true);
                return result;
            }

            protected IDialogSettings getDialogBoundsSettings() {
                return UIUtils.getDialogSettings((String)"ResultSetHandlerMain.GotoColumnDialog");
            }
        };
        if (dialog.open() == 0) {
            String value = dialog.getValue();
            Pair selectedByName = attrsByName.get(value.toUpperCase());
            return selectedByName != null ? (DBDAttributeBinding)selectedByName.getFirst() : attributes[Integer.parseInt(value) - 1];
        }
        return null;
    }

    private static /* synthetic */ String lambda$askForColumnToGo$5(Map attrsByName, DBDAttributeBinding[] attributes, String newText) {
        if (attrsByName.containsKey(newText.toUpperCase())) {
            return null;
        }
        try {
            int index = Integer.parseInt(newText);
            if (index >= 1 && index <= attributes.length) {
                return null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "Unknown column name";
    }

    static class GotoLineDialog
    extends InputDialog {
        private static final String DIALOG_ID = "ResultSetHandlerMain.GotoLineDialog";

        public GotoLineDialog(Shell parent, String title, String message, String initialValue, IInputValidator validator) {
            super(parent, title, message, initialValue, validator);
        }

        protected IDialogSettings getDialogBoundsSettings() {
            return UIUtils.getDialogSettings((String)DIALOG_ID);
        }
    }
}

