/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.virtual;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformerDescriptor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.virtual.DBVColorOverride;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityAttribute;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKey;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKeyColumn;
import org.jkiss.dbeaver.model.virtual.DBVTransformSettings;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.controls.resultset.virtual.EditVirtualColumnsPage;
import org.jkiss.dbeaver.ui.dialogs.BaseTitleDialog;
import org.jkiss.dbeaver.ui.dialogs.IDialogPageContainer;
import org.jkiss.dbeaver.ui.editors.object.struct.EditConstraintPage;
import org.jkiss.dbeaver.ui.editors.object.struct.EditDictionaryPage;
import org.jkiss.dbeaver.ui.editors.object.struct.EditForeignKeyPage;
import org.jkiss.utils.CommonUtils;

public class EditVirtualEntityDialog
extends BaseTitleDialog
implements IDialogPageContainer {
    private static final Log log = Log.getLog(EditVirtualEntityDialog.class);
    public static final int ID_CREATE_UNIQUE_KEY = 1000;
    public static final int ID_REMOVE_UNIQUE_KEY = 1001;
    public static final int ID_CREATE_FOREIGN_KEY = 2000;
    public static final int ID_REMOVE_FOREIGN_KEY = 2001;
    private static final String DATA_PAGE = "dialogPage";
    private final ResultSetViewer viewer;
    private final DBSEntity entity;
    private final DBVEntity vEntity;
    private EditDictionaryPage editDictionaryPage;
    private EditConstraintPage editUniqueKeyPage;
    private DBVEntityConstraint uniqueConstraint;
    private InitPage initPage = InitPage.ATTRIBUTES;
    private EditVirtualColumnsPage columnsPage;
    private boolean structChanged = false;
    private Object selectedPage;

    public EditVirtualEntityDialog(@NotNull ResultSetViewer viewer, @Nullable DBSEntity entity, @NotNull DBVEntity vEntity) {
        super(viewer.getControl().getShell(), null);
        this.viewer = viewer;
        this.entity = entity;
        this.vEntity = vEntity;
    }

    public InitPage getInitPage() {
        return this.initPage;
    }

    public void setInitPage(InitPage initPage) {
        this.initPage = initPage;
    }

    protected Composite createDialogArea(Composite parent) {
        parent.getShell().setText(ResultSetMessages.controls_resultset_edit_logical_structure);
        this.setTitle(ResultSetMessages.controls_resultset_edit_logical_structure);
        try {
            UIUtils.runInProgressService(monitor -> {
                for (DBVEntityForeignKey fk : this.vEntity.getForeignKeys()) {
                    try {
                        fk.getRealReferenceConstraint(monitor);
                        fk.getAssociatedEntity(monitor);
                    }
                    catch (DBException e) {
                        log.debug((Object)e);
                    }
                }
            });
        }
        catch (InvocationTargetException e2) {
            log.error((Object)e2.getTargetException());
        }
        catch (InterruptedException e2) {
            // empty catch block
        }
        Composite composite = super.createDialogArea(parent);
        CTabFolder tabFolder = new CTabFolder(composite, 0x800080);
        tabFolder.setLayoutData((Object)new GridData(1808));
        this.createColumnsPage(tabFolder);
        this.createUniqueKeysPage(tabFolder);
        this.createForeignKeysPage(tabFolder);
        this.createDictionaryPage(tabFolder);
        for (CTabItem item : tabFolder.getItems()) {
            if (item.getData() != this.initPage) continue;
            tabFolder.setSelection(item);
            this.selectedPage = item.getData(DATA_PAGE);
            break;
        }
        tabFolder.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.selectedPage = e.item.getData(DATA_PAGE);
        }));
        UIUtils.createInfoLabel((Composite)composite, (String)ResultSetMessages.controls_resultset_virtual_keys_info_label);
        return parent;
    }

    private void createDictionaryPage(CTabFolder tabFolder) {
        if (this.entity != null) {
            this.editDictionaryPage = new EditDictionaryPage(this.entity);
            this.editDictionaryPage.setContainer((IDialogPageContainer)this);
            this.editDictionaryPage.createControl((Composite)tabFolder);
            CTabItem dictItem = new CTabItem(tabFolder, 0);
            dictItem.setText(ResultSetMessages.controls_resultset_virtual_dictionary_page_text);
            dictItem.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_PACKAGE));
            dictItem.setControl(this.editDictionaryPage.getControl());
            dictItem.setData((Object)InitPage.DICTIONARY);
            dictItem.setData(DATA_PAGE, (Object)this.editDictionaryPage);
        }
    }

    private void createColumnsPage(CTabFolder tabFolder) {
        CTabItem attrsItem = new CTabItem(tabFolder, 0);
        attrsItem.setText(ResultSetMessages.controls_resultset_virtual_columns_page_text);
        attrsItem.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_COLUMN));
        attrsItem.setData((Object)InitPage.ATTRIBUTES);
        this.columnsPage = new EditVirtualColumnsPage(this.viewer, this.vEntity);
        attrsItem.setData(DATA_PAGE, (Object)this.columnsPage);
        Composite pageContents = this.columnsPage.createPageContents((Composite)tabFolder);
        attrsItem.setControl((Control)pageContents);
    }

    private void updateColumnItem(TableItem attrItem) {
        DBVTransformSettings transformSettings;
        DBDAttributeBinding attr = (DBDAttributeBinding)attrItem.getData();
        String transformStr = "";
        DBVEntityAttribute vAttr = this.vEntity.getVirtualAttribute(attr, false);
        if (vAttr != null && (transformSettings = vAttr.getTransformSettings()) != null) {
            DBDAttributeTransformerDescriptor td;
            if (!CommonUtils.isEmpty((Collection)transformSettings.getIncludedTransformers())) {
                transformStr = String.join((CharSequence)",", transformSettings.getIncludedTransformers());
            } else if (!CommonUtils.isEmpty((String)transformSettings.getCustomTransformer()) && (td = DBWorkbench.getPlatform().getValueHandlerRegistry().getTransformer(transformSettings.getCustomTransformer())) != null) {
                transformStr = td.getName();
            }
        }
        attrItem.setText(1, transformStr);
        String colorSettings = "";
        List coList = this.vEntity.getColorOverrides(attr.getName());
        if (!coList.isEmpty()) {
            ArrayList<String> coStrings = new ArrayList<String>();
            for (DBVColorOverride co : coList) {
                if (co.getAttributeValues() == null) continue;
                for (Object value : co.getAttributeValues()) {
                    coStrings.add(CommonUtils.toString((Object)value));
                }
            }
            colorSettings = String.join((CharSequence)",", coStrings);
        }
        attrItem.setText(2, colorSettings);
    }

    private void createUniqueKeysPage(CTabFolder tabFolder) {
        this.uniqueConstraint = this.vEntity.getBestIdentifier();
        if (this.uniqueConstraint == null) {
            return;
        }
        CTabItem ukItem = new CTabItem(tabFolder, 0);
        ukItem.setText("Virtual Unique Key");
        ukItem.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_UNIQUE_KEY));
        ukItem.setData((Object)InitPage.UNIQUE_KEY);
        this.editUniqueKeyPage = new EditConstraintPage("Define unique identifier", (DBSEntityReferrer)this.uniqueConstraint){

            protected boolean isColumnsRequired() {
                return EditVirtualEntityDialog.this.initPage == InitPage.UNIQUE_KEY && super.isColumnsRequired();
            }
        };
        this.editUniqueKeyPage.setContainer((IDialogPageContainer)this);
        ukItem.setData(DATA_PAGE, (Object)this.editUniqueKeyPage);
        this.editUniqueKeyPage.createControl((Composite)tabFolder);
        ukItem.setControl(this.editUniqueKeyPage.getControl());
    }

    private void createForeignKeysPage(CTabFolder tabFolder) {
        CTabItem fkItem = new CTabItem(tabFolder, 0);
        fkItem.setText(ResultSetMessages.controls_resultset_virtual_foreignkey_page_text);
        fkItem.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_FOREIGN_KEY));
        fkItem.setData((Object)InitPage.FOREIGN_KEYS);
        Composite panel = new Composite((Composite)tabFolder, 1);
        panel.setLayout((Layout)new GridLayout(1, false));
        fkItem.setControl((Control)panel);
        final Table fkTable = new Table(panel, 67584);
        fkTable.setLayoutData((Object)new GridData(1808));
        fkTable.setHeaderVisible(true);
        UIUtils.executeOnResize((Control)fkTable, () -> UIUtils.packColumns((Table)fkTable, (boolean)true));
        UIUtils.createTableColumn((Table)fkTable, (int)16384, (String)ResultSetMessages.controls_resultset_virtual_foreignkey_page_ref_table);
        UIUtils.createTableColumn((Table)fkTable, (int)16384, (String)ResultSetMessages.controls_resultset_virtual_foreignkey_page_columns);
        UIUtils.createTableColumn((Table)fkTable, (int)16384, (String)ResultSetMessages.controls_resultset_virtual_foreignkey_page_ref_datasource);
        for (DBVEntityForeignKey fk : this.vEntity.getForeignKeys()) {
            this.createForeignKeyItem(fkTable, fk);
        }
        Composite buttonsPanel = UIUtils.createComposite((Composite)panel, (int)2);
        buttonsPanel.setLayoutData((Object)new GridData(32));
        Button btnAdd = this.createButton(buttonsPanel, 2000, ResultSetMessages.controls_resultset_virtual_foreignkey_page_add, false);
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBVEntityForeignKey virtualFK = EditForeignKeyPage.createVirtualForeignKey((DBVEntity)EditVirtualEntityDialog.this.vEntity);
                if (virtualFK != null) {
                    EditVirtualEntityDialog.this.createForeignKeyItem(fkTable, virtualFK);
                    EditVirtualEntityDialog.this.structChanged = true;
                }
            }
        });
        Button btnRemove = this.createButton(buttonsPanel, 2001, ResultSetMessages.controls_resultset_virtual_foreignkey_page_remove, false);
        btnRemove.setEnabled(false);
        btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBVEntityForeignKey virtualFK = (DBVEntityForeignKey)fkTable.getSelection()[0].getData();
                if (!UIUtils.confirmAction((Shell)EditVirtualEntityDialog.this.getShell(), (String)ResultSetMessages.controls_resultset_virtual_foreignkey_page_remove_confirmation_title, (String)NLS.bind((String)ResultSetMessages.controls_resultset_virtual_foreignkey_page_remove_confirmation_question, (Object)virtualFK.getName()))) {
                    return;
                }
                EditVirtualEntityDialog.this.vEntity.removeForeignKey(virtualFK);
                fkTable.remove(fkTable.getSelectionIndices());
                EditVirtualEntityDialog.this.structChanged = true;
            }
        });
        fkTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean hasSelection = fkTable.getSelectionIndex() >= 0;
                EditVirtualEntityDialog.this.getButton(2001).setEnabled(hasSelection);
            }
        });
    }

    private void createForeignKeyItem(Table fkTable, DBVEntityForeignKey fk) {
        DBSEntityConstraint referencedConstraint = fk.getReferencedConstraint();
        if (referencedConstraint == null) {
            log.debug((Object)("No reference constraint for FK " + fk.getName()));
            return;
        }
        TableItem item = new TableItem(fkTable, 0);
        DBSEntity refEntity = referencedConstraint.getParentObject();
        item.setImage(0, DBeaverIcons.getImage((DBPImage)DBIcon.TREE_FOREIGN_KEY));
        if (referencedConstraint != null) {
            item.setText(0, DBUtils.getObjectFullName((DBPNamedObject)refEntity, (DBPEvaluationContext)DBPEvaluationContext.UI));
        }
        String ownAttrNames = fk.getAttributes().stream().map(DBVEntityForeignKeyColumn::getAttributeName).collect(Collectors.joining(","));
        String refAttrNames = fk.getAttributes().stream().map(DBVEntityForeignKeyColumn::getRefAttributeName).collect(Collectors.joining(","));
        item.setText(1, "(" + ownAttrNames + ") -> (" + refAttrNames + ")");
        item.setImage(2, DBeaverIcons.getImage((DBPImage)refEntity.getDataSource().getContainer().getDriver().getIcon()));
        item.setText(2, refEntity.getDataSource().getContainer().getName());
        item.setData((Object)fk);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        if (this.editUniqueKeyPage != null) {
            List uniqueAttrs = this.editUniqueKeyPage.getSelectedAttributes();
            this.uniqueConstraint.setName(this.editUniqueKeyPage.getConstraintName());
            this.uniqueConstraint.setUseAllColumns(this.editUniqueKeyPage.isUseAllColumns());
            this.uniqueConstraint.setAttributes((Collection)(this.uniqueConstraint.isUseAllColumns() ? Collections.emptyList() : uniqueAttrs));
            try {
                this.viewer.reloadIdentifierAttributes();
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
        if (this.editDictionaryPage != null) {
            this.editDictionaryPage.saveDictionarySettings();
        }
        this.vEntity.persistConfiguration();
        DBUtils.fireObjectUpdate((DBSObject)this.vEntity, (Object)this.uniqueConstraint);
        if (this.structChanged || this.columnsPage.isStructChanged()) {
            this.viewer.refreshData(null);
        }
        super.okPressed();
    }

    public void updateMessage() {
        if (this.editDictionaryPage != null) {
            String errorMessage = this.editDictionaryPage.getErrorMessage();
            this.setErrorMessage(errorMessage);
            if (errorMessage != null) {
                return;
            }
        }
        if (this.editUniqueKeyPage != null) {
            this.setErrorMessage(this.editUniqueKeyPage.getErrorMessage());
            return;
        }
    }

    public void updateButtons() {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(CommonUtils.isEmpty((String)this.getErrorMessage()));
        }
    }

    public static enum InitPage {
        ATTRIBUTES,
        UNIQUE_KEY,
        FOREIGN_KEYS,
        DICTIONARY;

    }
}

