/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.editors;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.StyledTextUtils;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.editors.BaseValueEditor;

public class StringInlineEditor
extends BaseValueEditor<Control> {
    private static final int MAX_STRING_LENGTH = 65535;

    public StringInlineEditor(IValueController controller) {
        super(controller);
    }

    @Override
    protected Control createControl(Composite editPlaceholder) {
        boolean inline;
        boolean bl = inline = this.valueController.getEditType() == IValueController.EditType.INLINE;
        if (inline) {
            Text editor = new Text(editPlaceholder, 2048);
            editor.setEditable(!this.valueController.isReadOnly());
            return editor;
        }
        StyledText editor = new StyledText(editPlaceholder, 578);
        editor.setEditable(!this.valueController.isReadOnly());
        editor.setFont(UIUtils.getMonospaceFont());
        StyledTextUtils.fillDefaultStyledTextContextMenu((StyledText)editor);
        return editor;
    }

    @Override
    public void primeEditorValue(@Nullable Object value) throws DBException {
        String strValue = this.valueController.getValueHandler().getValueDisplayString(this.valueController.getValueType(), value, DBDDisplayFormat.EDIT);
        Control control = this.control;
        if (control instanceof Text) {
            Text text = (Text)control;
            text.setText(strValue);
            if (this.valueController.getEditType() == IValueController.EditType.INLINE) {
                text.selectAll();
            }
        } else {
            control = this.control;
            if (control instanceof StyledText) {
                StyledText styledText = (StyledText)control;
                styledText.setText(strValue);
                if (this.valueController.getEditType() == IValueController.EditType.INLINE) {
                    styledText.selectAll();
                }
            }
        }
    }

    @Override
    public Object extractEditorValue() throws DBCException {
        DBCExecutionContext executionContext = this.valueController.getExecutionContext();
        if (executionContext == null) {
            return null;
        }
        try (DBCSession session = executionContext.openSession((DBRProgressMonitor)new VoidProgressMonitor(), DBCExecutionPurpose.UTIL, "Make string value from editor");){
            String strValue;
            Control control = this.control;
            if (control instanceof Text) {
                Text text = (Text)control;
                strValue = text.getText();
            } else {
                control = this.control;
                if (control instanceof StyledText) {
                    StyledText styledText = (StyledText)control;
                    strValue = styledText.getText();
                } else {
                    control = null;
                    return control;
                }
            }
            Object object = this.valueController.getValueHandler().getValueFromObject(session, this.valueController.getValueType(), (Object)strValue, false, false);
            return object;
        }
    }
}

