/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.managers.image;

import java.io.File;
import java.io.FileInputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.imageview.AbstractImageViewer;
import org.jkiss.dbeaver.ui.controls.imageview.BrowserImageEditor;
import org.jkiss.dbeaver.ui.controls.imageview.SWTImageEditor;
import org.jkiss.dbeaver.ui.data.IValueController;

public class ImageEditorPart
extends EditorPart
implements IRefreshablePart {
    private static final Log log = Log.getLog(ImageEditorPart.class);
    private final IValueController controller;
    private AbstractImageViewer imageViewer;

    public ImageEditorPart(IValueController controller) {
        this.controller = controller;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public void dispose() {
        super.dispose();
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        DBPPreferenceStore preferenceStore = this.controller.getExecutionContext().getDataSource().getContainer().getPreferenceStore();
        this.imageViewer = preferenceStore.getBoolean("resultset.image.browser") ? new BrowserImageEditor(parent, 0) : new SWTImageEditor(parent, 0);
        this.loadImage();
    }

    private void loadImage() {
        block9: {
            if (this.imageViewer == null || this.imageViewer.isDisposed()) {
                return;
            }
            if (this.getEditorInput() instanceof IPathEditorInput) {
                try {
                    IPath absolutePath = ((IPathEditorInput)this.getEditorInput()).getPath();
                    File localFile = absolutePath.toFile();
                    if (!localFile.exists()) break block9;
                    try (FileInputStream inputStream = new FileInputStream(localFile);){
                        this.imageViewer.loadImage(inputStream);
                        this.imageViewer.update();
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Can't load image contents", (Throwable)e);
                }
            }
        }
    }

    public void setFocus() {
        this.imageViewer.setFocus();
    }

    public String getTitle() {
        return "Image";
    }

    public Image getTitleImage() {
        return DBeaverIcons.getImage((DBPImage)DBIcon.TYPE_IMAGE);
    }

    public IRefreshablePart.RefreshResult refreshPart(Object source, boolean force) {
        this.refreshImage();
        return IRefreshablePart.RefreshResult.REFRESHED;
    }

    private void refreshImage() {
        UIUtils.asyncExec(this::loadImage);
    }
}

