/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreConstants;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreOid;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreServerExtension;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.LongKeyMap;

public class PostgreDataTypeCache
extends JDBCObjectCache<PostgreSchema, PostgreDataType> {
    private static final Log log = Log.getLog(PostgreDataTypeCache.class);
    private final LongKeyMap<PostgreDataType> dataTypeMap = new LongKeyMap();

    PostgreDataTypeCache() {
        this.setListOrderComparator(DBUtils.nameComparator());
        this.setCaseSensitive(false);
    }

    @NotNull
    protected String getCacheName() {
        return "Data type cache";
    }

    protected synchronized void loadObjects(DBRProgressMonitor monitor, PostgreSchema schema) throws DBException {
        super.loadObjects(monitor, (DBSObject)schema);
        this.mapAliases(schema);
    }

    void loadDefaultTypes(PostgreSchema schema) {
        ArrayList<PostgreDataType> types = new ArrayList<PostgreDataType>();
        for (Field oidField : PostgreOid.class.getDeclaredFields()) {
            if (!Modifier.isPublic(oidField.getModifiers()) || !Modifier.isStatic(oidField.getModifiers())) continue;
            try {
                Object typeId = oidField.get(null);
                Object fieldName = oidField.getName().toLowerCase(Locale.ENGLISH);
                if (((String)fieldName).endsWith("_array")) {
                    fieldName = ((String)fieldName).substring(0, ((String)fieldName).length() - 6) + "_";
                    continue;
                }
                PostgreDataType type = new PostgreDataType(schema, CommonUtils.toInt((Object)typeId), (String)fieldName);
                types.add(type);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        this.setCache(types);
        this.mapAliases(schema);
    }

    void mapAliases(PostgreSchema schema) {
        if (schema.isCatalogSchema()) {
            PostgreServerExtension serverType = schema.getDataSource().getServerType();
            this.mapDataTypeAliases(serverType.getDataTypeAliases(), false);
            if (serverType.supportSerialTypes()) {
                this.mapDataTypeAliases(PostgreConstants.SERIAL_TYPES, true);
            }
        }
    }

    private void mapDataTypeAliases(Map<String, String> aliases, boolean isSerialType) {
        for (Map.Entry<String, String> aliasMapping : aliases.entrySet()) {
            String value = aliasMapping.getValue();
            PostgreDataType realType = (PostgreDataType)this.getCachedObject(value);
            if (realType == null) continue;
            PostgreDataType serialType = new PostgreDataType(realType, aliasMapping.getKey());
            int typeId = -1;
            if (isSerialType) {
                switch (value) {
                    case "int4": {
                        typeId = 4443;
                        break;
                    }
                    case "int2": {
                        typeId = 4444;
                        break;
                    }
                    case "int8": {
                        typeId = 4442;
                    }
                }
                serialType.setTypeId(typeId);
                serialType.setExtraDataType(true);
            }
            this.cacheObject(serialType);
        }
    }

    public void clearCache() {
        super.clearCache();
        this.dataTypeMap.clear();
    }

    public void removeObject(@NotNull PostgreDataType object, boolean resetFullCache) {
        super.removeObject((DBSObject)object, resetFullCache);
        this.dataTypeMap.remove(object.getObjectId());
    }

    public void cacheObject(@NotNull PostgreDataType object) {
        if (this.getCachedObject(object.getName()) == null) {
            super.cacheObject((DBSObject)object);
            if (!object.isAlias() || object.isExtraDataType()) {
                this.dataTypeMap.put(object.getObjectId(), (Object)object);
            }
        }
    }

    public void setCache(@NotNull List<PostgreDataType> postgreDataTypes) {
        super.setCache(postgreDataTypes);
        for (PostgreDataType dt : postgreDataTypes) {
            if (dt.isAlias()) continue;
            this.dataTypeMap.put(dt.getObjectId(), (Object)dt);
        }
    }

    static String getBaseTypeNameClause(@NotNull PostgreDataSource dataSource) {
        if (dataSource.isServerVersionAtLeast(7, 3)) {
            return "format_type(nullif(t.typbasetype, 0), t.typtypmod) as base_type_name";
        }
        return "NULL as base_type_name";
    }

    @NotNull
    protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreSchema owner) throws SQLException {
        PostgreDataSource dataSource = owner.getDataSource();
        boolean readAllTypes = dataSource.supportReadingAllDataTypes();
        boolean supportsSysTypColumn = owner.getDatabase().supportsSysTypCategoryColumn(session);
        StringBuilder sql = new StringBuilder(256);
        sql.append("SELECT t.oid,t.*,c.relkind,").append(PostgreDataTypeCache.getBaseTypeNameClause(dataSource)).append(", d.description\nFROM pg_catalog.pg_type t");
        if (!readAllTypes && supportsSysTypColumn) {
            sql.append("\nLEFT OUTER JOIN pg_catalog.pg_type et ON et.oid=t.typelem ");
        }
        sql.append("\nLEFT OUTER JOIN pg_catalog.pg_class c ON c.oid=t.typrelid\nLEFT OUTER JOIN pg_catalog.pg_description d ON t.oid=d.objoid\nWHERE t.typname IS NOT NULL");
        if (!readAllTypes) {
            sql.append("\nAND (c.relkind IS NULL OR c.relkind = 'c')");
            if (supportsSysTypColumn) {
                sql.append(" AND (et.typcategory IS NULL OR et.typcategory <> 'C')");
            }
        }
        sql.append("\nAND t.typnamespace=? ");
        JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
        dbStat.setLong(1, owner.getObjectId());
        return dbStat;
    }

    protected PostgreDataType fetchObject(@NotNull JDBCSession session, @NotNull PostgreSchema owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
        return PostgreDataType.readDataType(session, owner.getDatabase(), dbResult, true);
    }

    protected void invalidateObjects(DBRProgressMonitor monitor, PostgreSchema schema, Iterator<PostgreDataType> objectIter) {
        while (objectIter.hasNext()) {
            PostgreDataType dt = objectIter.next();
            dt.resolveValueTypeFromBaseType(monitor);
        }
    }

    public PostgreDataType getDataType(long oid) {
        return (PostgreDataType)this.dataTypeMap.get(oid);
    }

    @NotNull
    static PostgreDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull PostgreDatabase database, long oid) throws SQLException, DBException {
        try (JDBCSession session = database.getDefaultContext(monitor, true).openSession(monitor, DBCExecutionPurpose.META, "Resolve data type by OID");
             JDBCPreparedStatement dbStat = session.prepareStatement("SELECT t.oid,t.*,c.relkind," + PostgreDataTypeCache.getBaseTypeNameClause(database.getDataSource()) + " FROM pg_catalog.pg_type t\nLEFT OUTER JOIN pg_class c ON c.oid=t.typrelid\nLEFT OUTER JOIN pg_catalog.pg_description d ON t.oid=d.objoid\nWHERE t.oid=? ");){
            dbStat.setLong(1, oid);
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                if (dbResult.next()) {
                    long schemaOid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"typnamespace");
                    PostgreSchema schema = database.getSchema(monitor, schemaOid);
                    if (schema == null) {
                        throw new DBException("Schema " + schemaOid + " not found for data type " + oid);
                    }
                    PostgreDataType dataType = PostgreDataType.readDataType(session, database, dbResult, false);
                    if (dataType != null) {
                        PostgreDataType postgreDataType = dataType;
                        return postgreDataType;
                    }
                }
                throw new DBException("Data type " + oid + " not found in database " + database.getName());
            }
        }
    }

    @NotNull
    static PostgreDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull PostgreDatabase database, String name) throws SQLException, DBException {
        try (JDBCSession session = database.getDefaultContext(monitor, true).openSession(monitor, DBCExecutionPurpose.META, "Resolve data type by name");
             JDBCPreparedStatement dbStat = session.prepareStatement("SELECT t.oid,t.*," + PostgreDataTypeCache.getBaseTypeNameClause(database.getDataSource()) + " FROM pg_catalog.pg_type t\nLEFT OUTER JOIN pg_class c ON c.oid=t.typrelid\nLEFT OUTER JOIN pg_catalog.pg_description d ON t.oid=d.objoid\nWHERE t.typname=? ");){
            dbStat.setString(1, name);
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                if (dbResult.next()) {
                    long schemaOid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"typnamespace");
                    PostgreSchema schema = database.getSchema(monitor, schemaOid);
                    if (schema == null) {
                        throw new DBException("Schema " + schemaOid + " not found for data type " + name);
                    }
                    PostgreDataType dataType = PostgreDataType.readDataType(session, database, dbResult, false);
                    if (dataType != null) {
                        PostgreDataType postgreDataType = dataType;
                        return postgreDataType;
                    }
                }
                throw new DBException("Data type " + name + " not found in database " + database.getName());
            }
        }
    }
}

