/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleGlobalObject;
import org.jkiss.dbeaver.ext.oracle.model.OraclePrivObject;
import org.jkiss.dbeaver.ext.oracle.model.OraclePrivRole;
import org.jkiss.dbeaver.ext.oracle.model.OraclePrivSystem;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.access.DBAUser;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public abstract class OracleGrantee
extends OracleGlobalObject
implements DBAUser,
DBPSaveableObject,
DBPRefreshableObject {
    private static final Log log = Log.getLog(OracleGrantee.class);
    final RolePrivCache rolePrivCache = new RolePrivCache();
    private final SystemPrivCache systemPrivCache = new SystemPrivCache();
    private final ObjectPrivCache objectPrivCache = new ObjectPrivCache();

    public OracleGrantee(OracleDataSource dataSource) {
        super(dataSource, true);
    }

    @Association
    public Collection<OraclePrivRole> getRolePrivs(DBRProgressMonitor monitor) throws DBException {
        return this.rolePrivCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<OraclePrivSystem> getSystemPrivs(DBRProgressMonitor monitor) throws DBException {
        return this.systemPrivCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<OraclePrivObject> getObjectPrivs(DBRProgressMonitor monitor) throws DBException {
        return this.objectPrivCache.getAllObjects(monitor, this);
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.rolePrivCache.clearCache();
        this.systemPrivCache.clearCache();
        this.objectPrivCache.clearCache();
        return this;
    }

    static class RolePrivCache
    extends JDBCObjectCache<OracleGrantee, OraclePrivRole> {
        RolePrivCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleGrantee owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM DBA_ROLE_PRIVS WHERE GRANTEE=? ORDER BY GRANTED_ROLE");
            dbStat.setString(1, owner.getName());
            return dbStat;
        }

        protected OraclePrivRole fetchObject(@NotNull JDBCSession session, @NotNull OracleGrantee owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OraclePrivRole(owner, (ResultSet)resultSet);
        }
    }

    static class SystemPrivCache
    extends JDBCObjectCache<OracleGrantee, OraclePrivSystem> {
        SystemPrivCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleGrantee owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM DBA_SYS_PRIVS WHERE GRANTEE=? ORDER BY PRIVILEGE");
            dbStat.setString(1, owner.getName());
            return dbStat;
        }

        protected OraclePrivSystem fetchObject(@NotNull JDBCSession session, @NotNull OracleGrantee owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OraclePrivSystem(owner, (ResultSet)resultSet);
        }
    }

    static class ObjectPrivCache
    extends JDBCObjectCache<OracleGrantee, OraclePrivObject> {
        ObjectPrivCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleGrantee owner) throws SQLException {
            boolean hasDBA = owner.getDataSource().isViewAvailable(session.getProgressMonitor(), "SYS", "DBA_TAB_PRIVS");
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT p.*,o.OBJECT_TYPE\nFROM " + (hasDBA ? "DBA_TAB_PRIVS p, DBA_OBJECTS o" : "ALL_TAB_PRIVS p, ALL_OBJECTS o") + "\nWHERE p.GRANTEE=? AND o.OWNER=p." + (hasDBA ? "OWNER" : "TABLE_SCHEMA") + " AND o.OBJECT_NAME=p.TABLE_NAME AND o.OBJECT_TYPE<>'PACKAGE BODY'");
            dbStat.setString(1, owner.getName());
            return dbStat;
        }

        protected OraclePrivObject fetchObject(@NotNull JDBCSession session, @NotNull OracleGrantee owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OraclePrivObject(owner, (ResultSet)resultSet);
        }
    }
}

