/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.config.migration.wizards.custom;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.ui.config.migration.ImportConfigMessages;
import org.jkiss.dbeaver.ui.config.migration.wizards.ConfigImportWizardPage;
import org.jkiss.dbeaver.ui.config.migration.wizards.ImportConnectionInfo;
import org.jkiss.dbeaver.ui.config.migration.wizards.ImportData;
import org.jkiss.dbeaver.ui.config.migration.wizards.ImportDriverInfo;
import org.jkiss.dbeaver.ui.config.migration.wizards.custom.ConfigImportWizardCustom;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.csv.CSVReader;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class ConfigImportWizardPageCustomConnections
extends ConfigImportWizardPage {
    private static final Log log = Log.getLog(ConfigImportWizardPageCustomConnections.class);

    protected ConfigImportWizardPageCustomConnections() {
        super(ImportConfigMessages.config_import_wizard_page_caption_connections);
        this.setTitle(ImportConfigMessages.config_import_wizard_page_caption_connections);
        this.setDescription(ImportConfigMessages.config_import_wizard_header_import_configuration);
    }

    @Override
    protected void loadConnections(ImportData importData) throws DBException {
        this.setErrorMessage(null);
        ConfigImportWizardCustom wizard = (ConfigImportWizardCustom)this.getWizard();
        DBPDriver driver = wizard.getDriver();
        ImportDriverInfo driverInfo = new ImportDriverInfo(driver.getId(), driver.getName(), driver.getSampleURL(), driver.getDriverClassName());
        importData.addDriver(driverInfo);
        File inputFile = wizard.getInputFile();
        try (FileInputStream is = new FileInputStream(inputFile);
             InputStreamReader reader = new InputStreamReader((InputStream)is, wizard.getInputFileEncoding());){
            if (wizard.getImportType() == ConfigImportWizardCustom.ImportType.CSV) {
                this.importCSV(importData, driverInfo, reader);
            } else {
                this.importXML(importData, driverInfo, reader);
            }
        }
        catch (Exception e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    private void importCSV(ImportData importData, ImportDriverInfo driver, Reader reader) throws IOException {
        Object[] line;
        CSVReader csvReader = new CSVReader(reader);
        Object[] header = csvReader.readNext();
        if (ArrayUtils.isEmpty((Object[])header)) {
            this.setErrorMessage(ImportConfigMessages.config_import_wizard_no_connection_found_error);
            return;
        }
        while (!ArrayUtils.isEmpty((Object[])(line = csvReader.readNext()))) {
            HashMap<String, String> conProps = new HashMap<String, String>();
            for (int i = 0; i < line.length && i < header.length; ++i) {
                conProps.put((String)header[i], (String)line[i]);
            }
            this.makeConnectionFromProps(importData, driver, conProps);
        }
    }

    private void importXML(ImportData importData, ImportDriverInfo driver, Reader reader) throws XMLException {
        Document document = XMLUtils.parseDocument((Reader)reader);
        for (Element conElement : XMLUtils.getChildElementList((Element)document.getDocumentElement())) {
            HashMap<String, String> conProps = new HashMap<String, String>();
            NamedNodeMap attrs = conElement.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr attr = (Attr)attrs.item(i);
                conProps.put(attr.getName(), attr.getValue());
            }
            this.makeConnectionFromProps(importData, driver, conProps);
        }
    }

    private void makeConnectionFromProps(ImportData importData, ImportDriverInfo driver, Map<String, String> conProps) {
        String name = conProps.get("name");
        if (CommonUtils.isEmpty((String)name)) {
            return;
        }
        ImportConnectionInfo ici = new ImportConnectionInfo(driver, conProps.get("id"), name, conProps.get("url"), conProps.get("host"), conProps.get("port"), conProps.get("database"), conProps.get("user"), conProps.get("password"));
        log.debug((Object)("load connection: " + ici.toString()));
        importData.addConnection(ici);
    }
}

