/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model.session;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDataSource;
import org.jkiss.dbeaver.ext.altibase.model.session.AltibaseServerSession;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManagerSQL;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;

public class AltibaseServerSessionManager
implements DBAServerSessionManager<AltibaseServerSession>,
DBAServerSessionManagerSQL {
    private final AltibaseDataSource dataSource;

    public AltibaseServerSessionManager(AltibaseDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Collection<AltibaseServerSession> getSessions(@NotNull DBCSession session, @NotNull Map<String, Object> options) throws DBException {
        try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement(this.generateSessionReadQuery(options));){
            ArrayList<AltibaseServerSession> arrayList;
            block15: {
                JDBCResultSet dbResult = dbStat.executeQuery();
                try {
                    ArrayList<AltibaseServerSession> sessions = new ArrayList<AltibaseServerSession>();
                    while (dbResult.next()) {
                        sessions.add(new AltibaseServerSession((ResultSet)dbResult));
                    }
                    arrayList = sessions;
                    if (dbResult == null) break block15;
                }
                catch (Throwable throwable) {
                    if (dbResult != null) {
                        try {
                            dbResult.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                dbResult.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new DBDatabaseException((Throwable)e, session.getDataSource());
        }
    }

    public void alterSession(@NotNull DBCSession session, @NotNull String sessionId, @NotNull Map<String, Object> options) throws DBException {
        try {
            String sql = String.format("ALTER DATABASE %s SESSION CLOSE %s", this.dataSource.getDbName((JDBCSession)session), sessionId);
            try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement(sql);){
                dbStat.execute();
            }
        }
        catch (SQLException e) {
            throw new DBDatabaseException((Throwable)e, session.getDataSource());
        }
    }

    @NotNull
    public Map<String, Object> getTerminateOptions() {
        return Map.of();
    }

    public boolean canGenerateSessionReadQuery() {
        return true;
    }

    @NotNull
    public String generateSessionReadQuery(@NotNull Map<String, Object> options) {
        return "SELECT s.id session_id , s.trans_id tx_id , CURRENT_STMT_ID stmt_id , db_username user_name , nvl2(s.query, s.query, ' ') AS sql , obj_name lock_target , DECODE(is_grant, 1, 'HOLDER', 0, 'WAITER', '') lock_status , lock_desc lock_type , TO_CHAR(conv_timezone(UNIX_TO_DATE( login_time ), '+00:00', db_timezone()), 'YYYY-MM-DD HH24:MI:SS') login_time , CASE2(IDLE_START_TIME < 1, '', TO_CHAR(conv_timezone(UNIX_TO_DATE( idle_start_time ), '+00:00', db_timezone()), 'YYYY-MM-DD HH24:MI:SS')) idle_since , CASE2(autocommit_flag = 1, 'T', 'F') autocommit , decode(sysdba_flag, 0, 'F', 1, 'T') sysda , query_time_limit , ddl_time_limit , fetch_time_limit , utrans_time_limit , idle_time_limit , nls_territory , time_zone , client_app_info , comm_name , client_type , client_protocol_version , client_pid FROM  (SELECT ss.*, st.query FROM v$session ss LEFT OUTER JOIN v$statement st  ON st.session_id = ss.id AND st.tx_id = ss.trans_id AND st.id = ss.current_stmt_id) s LEFT OUTER JOIN (SELECT  u.user_name || '.' ||a.table_name obj_name , b.trans_id  , b.lock_desc  , b.is_grant  FROM  system_.sys_tables_ a, v$lock b, system_.sys_users_ u  WHERE  u.user_id = a.user_id AND a.table_oid = b.table_oid) l ON s.trans_id = l.trans_id ORDER BY login_time";
    }
}

