/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.ai.engine.copilot;

import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.engine.AIEngineProperties;
import org.jkiss.dbeaver.model.ai.engine.AIModel;
import org.jkiss.dbeaver.model.ai.engine.AIModelFeature;
import org.jkiss.dbeaver.model.ai.engine.copilot.CopilotClient;
import org.jkiss.dbeaver.model.ai.engine.copilot.CopilotCompletionEngine;
import org.jkiss.dbeaver.model.ai.engine.copilot.CopilotModels;
import org.jkiss.dbeaver.model.ai.engine.copilot.CopilotProperties;
import org.jkiss.dbeaver.model.ai.registry.AIEngineDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceAuth;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.ai.engine.copilot.CopilotMessages;
import org.jkiss.dbeaver.ui.ai.internal.AIUIMessages;
import org.jkiss.dbeaver.ui.ai.model.CachedValue;
import org.jkiss.dbeaver.ui.ai.model.ContextWindowSizeField;
import org.jkiss.dbeaver.ui.ai.model.ModelSelectorField;
import org.jkiss.dbeaver.ui.ai.preferences.AIIObjectPropertyConfigurator;
import org.jkiss.utils.CommonUtils;

public class CopilotConfigurator<ENGINE extends AIEngineDescriptor, PROPERTIES extends CopilotProperties>
implements AIIObjectPropertyConfigurator<ENGINE, PROPERTIES> {
    private Text temperatureText;
    private ContextWindowSizeField contextWindowSizeField;
    private ModelSelectorField modelSelectorField;
    private Button logQueryCheck;
    private Text accessTokenText;
    protected volatile String accessToken;
    protected String token = "";
    private String temperature = "0.0";
    private boolean logQuery = false;
    protected final CachedValue<List<AIModel>> modelsCache = new CachedValue(this::fetchCopilotModels);

    @NotNull
    private List<AIModel> fetchCopilotModels(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.accessToken == null || this.accessToken.isEmpty()) {
            throw new DBException("Access token is not set");
        }
        try (CopilotCompletionEngine engine = this.createEngine();){
            List list = engine.getModels(monitor);
            return list;
        }
    }

    public void createControl(@NotNull Composite parent, AIEngineDescriptor object, @NotNull Runnable propertyChangeListener) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)3);
        composite.setLayoutData((Object)new GridData(768));
        this.createConnectionParameters(composite);
        this.createModelParameters(composite);
        this.createAdditionalSettings(composite);
        UIUtils.syncExec(this::applySettings);
    }

    public void loadSettings(@NotNull PROPERTIES configuration) {
        this.token = CommonUtils.toString((Object)configuration.getToken());
        this.modelSelectorField.setSelectedModel(configuration.getModel());
        this.contextWindowSizeField.setValue(configuration.getContextWindowSize());
        this.temperature = CommonUtils.toString((Object)configuration.getTemperature(), (String)"0.0");
        this.logQuery = CommonUtils.toBoolean((Object)configuration.isLoggingEnabled());
        this.accessToken = CommonUtils.toString((Object)configuration.getToken(), (String)"");
        this.accessTokenText.setText(this.accessToken);
        this.applySettings();
        this.modelSelectorField.refreshModelListSilently(true);
    }

    public void saveSettings(@NotNull PROPERTIES properties) {
        properties.setToken(this.accessToken);
        properties.setModel(this.modelSelectorField.getSelectedModel());
        properties.setContextWindowSize(this.contextWindowSizeField.getValue());
        properties.setTemperature(CommonUtils.toDouble((Object)this.temperature));
        properties.setLoggingEnabled(this.logQuery);
    }

    public void resetSettings(@NotNull PROPERTIES copilotPropertiesLegacyAISettings) {
    }

    public boolean isComplete() {
        return true;
    }

    protected void createModelParameters(@NotNull Composite parent) {
        ModelSelectorField.ModelListProvider modelListProvider = (monitor, forceRefresh) -> this.modelsCache.get(monitor, forceRefresh).stream().filter(it -> it.features().contains(AIModelFeature.CHAT)).map(AIModel::name).toList();
        this.modelSelectorField = ModelSelectorField.builder().withParent(parent).withGridData(new GridData(768)).withModifyListener(() -> CopilotModels.getModelByName((String)this.modelSelectorField.getSelectedModel()).ifPresentOrElse(model -> {
            this.contextWindowSizeField.setValue(model.contextWindowSize());
            this.temperatureText.setText(String.valueOf(model.defaultTemperature()));
        }, () -> {
            this.contextWindowSizeField.setValue(null);
            this.temperatureText.setText("0.0");
        })).withModelListSupplier(modelListProvider).build();
        this.contextWindowSizeField = ContextWindowSizeField.builder().withParent(parent).withGridData(GridDataFactory.fillDefaults().span(2, 1).create()).build();
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.temperatureText = UIUtils.createLabelText((Composite)parent, (String)AIUIMessages.gpt_preference_page_text_temperature, (String)"0.0");
        this.temperatureText.setLayoutData((Object)gridData);
        this.temperatureText.setToolTipText("Lower temperatures give more precise results");
        this.temperatureText.addVerifyListener(UIUtils.getNumberVerifyListener((Locale)Locale.getDefault()));
        this.temperatureText.addModifyListener(e -> {
            this.temperature = this.temperatureText.getText();
        });
    }

    private void createAdditionalSettings(@NotNull Composite parent) {
        this.logQueryCheck = UIUtils.createCheckbox((Composite)parent, (String)"Write AI queries to debug log", (String)"Write AI queries with metadata info in the debug logs", (boolean)false, (int)2);
        this.logQueryCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CopilotConfigurator.this.logQuery = CopilotConfigurator.this.logQueryCheck.getSelection();
            }
        });
    }

    private void applySettings() {
        this.temperatureText.setText(this.temperature);
        this.logQueryCheck.setSelection(this.logQuery);
    }

    protected void createConnectionParameters(@NotNull Composite parent) {
        this.accessTokenText = UIUtils.createLabelText((Composite)parent, (String)CopilotMessages.copilot_access_token, (String)"", (int)0x400800);
        GridData gd = new GridData(768);
        gd.widthHint = 150;
        this.accessTokenText.setLayoutData((Object)gd);
        this.accessTokenText.addModifyListener(e -> {
            this.accessToken = this.accessTokenText.getText();
        });
        this.accessTokenText.setMessage(CopilotMessages.copilot_preference_page_token_info);
        UIUtils.createDialogButton((Composite)parent, (String)CopilotMessages.copilot_access_token_authorize, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> {
            try {
                this.accessToken = (String)UIUtils.runWithDialog(monitor -> {
                    CompletableFuture<Void> future = new CompletableFuture<Void>();
                    try {
                        String string = this.acquireAccessToken(monitor, future);
                        return string;
                    }
                    finally {
                        future.complete(null);
                    }
                });
            }
            catch (DBException ex) {
                DBWorkbench.getPlatformUI().showError(CopilotMessages.oauth_auth_title, NLS.bind((String)CopilotMessages.oauth_auth_error_message, (Object)ex.getMessage()), (Throwable)ex);
                return;
            }
            UIUtils.showMessageBox((Shell)UIUtils.getActiveShell(), (String)CopilotMessages.oauth_auth_title, (String)CopilotMessages.oauth_auth_success_message, (int)2);
            if (this.accessTokenText != null && !this.accessTokenText.isDisposed()) {
                this.accessTokenText.setText(this.accessToken);
                this.accessTokenText = UIUtils.recreateTextControl((Text)this.accessTokenText, (int)2048);
            }
            this.modelSelectorField.refreshModelListSilently(true);
        }));
    }

    @NotNull
    private String acquireAccessToken(@NotNull DBRProgressMonitor monitor, @NotNull CompletableFuture<Void> future) throws DBException {
        String string;
        UIServiceAuth service = (UIServiceAuth)DBWorkbench.getService(UIServiceAuth.class);
        if (service == null) {
            throw new DBException("No authentication service available");
        }
        CopilotClient client = new CopilotClient(this.getCurrentAuthURL());
        try {
            monitor.subTask("Requesting device code");
            CopilotClient.DeviceCodeResponse deviceCodeResponse = client.requestDeviceCode(monitor);
            service.showCodePopup(URI.create(deviceCodeResponse.verificationUri()), deviceCodeResponse.userCode(), future);
            monitor.subTask("Awaiting access token");
            string = client.requestAccessToken(monitor, deviceCodeResponse, future);
        }
        catch (Throwable throwable) {
            try {
                try {
                    client.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (InterruptedException e) {
                throw new DBException("Authorization was interrupted", (Throwable)e);
            }
        }
        client.close();
        return string;
    }

    @NotNull
    protected String getCurrentAuthURL() {
        return "https://api.github.com";
    }

    @Override
    @NotNull
    public Optional<AIEngineProperties> getCurrentProperties() {
        CopilotProperties copilotPropertiesCopy = new CopilotProperties();
        this.saveSettings((PROPERTIES)copilotPropertiesCopy);
        return Optional.of(copilotPropertiesCopy);
    }

    @NotNull
    protected CopilotCompletionEngine createEngine() {
        CopilotProperties properties = new CopilotProperties();
        properties.setToken(this.accessToken);
        return new CopilotCompletionEngine(properties);
    }
}

