/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystemRoot;
import org.jkiss.dbeaver.model.navigator.fs.DBNPathBase;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.utils.ByteNumberFormat;

public class NavigatorHandlerLoadResource
extends AbstractHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        File[] srcFiles = DialogUtils.openFileList((Shell)shell, (String)"Open file(s)", null);
        if (srcFiles == null) {
            return null;
        }
        DBNNode pathNodes = NavigatorUtils.getSelectedNode(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        if (!(pathNodes instanceof DBNPathBase)) {
            return null;
        }
        DBNPathBase pathNode = (DBNPathBase)pathNodes;
        try {
            UIUtils.runInProgressDialog(monitor -> {
                try {
                    Path targetPath = pathNode.getPath();
                    if (!(pathNode instanceof DBNFileSystemRoot) && !Files.isDirectory(targetPath, new LinkOption[0])) {
                        targetPath = targetPath.getParent();
                    }
                    this.loadLocalFiles(monitor, srcFiles, targetPath);
                    pathNodes.refreshNode(monitor, (Object)this);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("File save IO error", null, (Throwable)e);
        }
        return null;
    }

    private void loadLocalFiles(DBRProgressMonitor monitor, File[] srcFiles, Path targetPath) {
        long totalFilesSize = 0L;
        for (File srcFile : srcFiles) {
            totalFilesSize += srcFile.length();
        }
        monitor.beginTask("Load resources", (int)totalFilesSize);
        block13: for (File srcFile : srcFiles) {
            if (monitor.isCanceled()) {
                return;
            }
            monitor.subTask(srcFile.getName() + " (" + ByteNumberFormat.getInstance().format(srcFile.length()) + ")");
            Path targetFilePath = targetPath.resolve(srcFile.getName());
            try {
                byte[] buffer = new byte[10000];
                try (InputStream is = Files.newInputStream(srcFile.toPath(), new OpenOption[0]);
                     OutputStream os = Files.newOutputStream(targetFilePath, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                    while (true) {
                        if (monitor.isCanceled()) {
                            continue block13;
                        }
                        int count = is.read(buffer);
                        if (count <= 0) {
                            continue block13;
                        }
                        monitor.worked(count);
                        os.write(buffer, 0, count);
                    }
                }
            }
            catch (IOException e) {
                DBWorkbench.getPlatformUI().showError("IO error", null, (Throwable)e);
            }
        }
        monitor.done();
    }

    public void updateElement(UIElement element, Map parameters) {
    }
}

