/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.navigator.INavigatorListener;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithResult;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSStructContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.AbstractUIJob;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.LinuxKeyboardArrowsListener;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ProgressPainter;
import org.jkiss.dbeaver.ui.navigator.INavigatorFilter;
import org.jkiss.dbeaver.ui.navigator.INavigatorItemRenderer;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectRename;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorContent;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorContentProvider;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorLabelProvider;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorToolTipSupport;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilter;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilterObjectType;
import org.jkiss.dbeaver.ui.navigator.database.DefaultNavigatorNodeRenderer;
import org.jkiss.dbeaver.ui.navigator.database.TextMatcherExt;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DatabaseNavigatorTree
extends Composite
implements INavigatorListener {
    private static final Log log = Log.getLog(DatabaseNavigatorTree.class);
    static final String TREE_DATA_STAT_MAX_SIZE = "nav.stat.maxSize";
    private static final String FILTER_TOOLBAR_CONTRIBUTION_ID = "toolbar:org.jkiss.dbeaver.navigator.filter.toolbar";
    private static final String DATA_TREE_CONTROL = DatabaseNavigatorTree.class.getSimpleName();
    private static final boolean INLINE_RENAME_ENABLED = false;
    private final TreeViewer treeViewer;
    private DBNModel model;
    private TreeEditor treeEditor;
    private boolean checkEnabled;
    private INavigatorFilter navigatorFilter;
    private TreeFilter treeFilter;
    private Text filterControl;
    private INavigatorItemRenderer itemRenderer;
    private boolean filterShowConnected = false;
    private DatabaseNavigatorTreeFilterObjectType filterObjectType = DatabaseNavigatorTreeFilterObjectType.connection;
    private volatile ProgressPainter treeLoadingListener;
    private static final Set<DBNNode> nodeInLoadingProcess = new HashSet<DBNNode>();

    public static DatabaseNavigatorTree getFromShell(Display display) {
        if (display == null) {
            return null;
        }
        Control focusControl = display.getFocusControl();
        if (focusControl == null) {
            return null;
        }
        return DatabaseNavigatorTree.getFromShell(focusControl.getShell());
    }

    public static DatabaseNavigatorTree getFromShell(Shell shell) {
        return (DatabaseNavigatorTree)((Object)shell.getData(DATA_TREE_CONTROL));
    }

    public DatabaseNavigatorTree(Composite parent, DBNNode rootNode, int style) {
        this(parent, rootNode, style, false);
    }

    public DatabaseNavigatorTree(Composite parent, DBNNode rootNode, int style, boolean showRoot) {
        this(parent, rootNode, style, showRoot, null, null);
    }

    public DatabaseNavigatorTree(Composite parent, DBNNode rootNode, int style, boolean showRoot, INavigatorFilter navigatorFilter) {
        this(parent, rootNode, style, showRoot, navigatorFilter, null);
    }

    public DatabaseNavigatorTree(Composite parent, DBNNode rootNode, int style, boolean showRoot, INavigatorFilter navigatorFilter, String filterPlaceholderText) {
        super(parent, 0);
        if (UIUtils.isInDialog((Control)parent)) {
            parent.getShell().setData(DATA_TREE_CONTROL, (Object)this);
        }
        this.setLayout((Layout)new FillLayout());
        this.navigatorFilter = navigatorFilter;
        this.model = DBWorkbench.getPlatform().getNavigatorModel();
        assert (this.model != null);
        this.model.addListener((INavigatorListener)this);
        this.addDisposeListener(e -> {
            if (this.model != null) {
                this.model.removeListener((INavigatorListener)this);
                this.model = null;
            }
        });
        this.treeViewer = this.doCreateTreeViewer(this, style);
        this.updateFilterMessage();
        Tree tree = this.treeViewer.getTree();
        tree.setCursor(this.getDisplay().getSystemCursor(0));
        this.treeViewer.setUseHashlookup(true);
        if (rootNode == null) {
            this.treeLoadingListener = new ProgressPainter((Control)tree);
        }
        DatabaseNavigatorLabelProvider labelProvider = this.createLabelProvider(this);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.treeViewer.setContentProvider((IContentProvider)this.createContentProvider(showRoot));
        if (rootNode != null) {
            this.setInput(rootNode);
        }
        new DatabaseNavigatorToolTipSupport(this);
        this.initEditor();
        this.setItemRenderer(new DefaultNavigatorNodeRenderer());
        tree.addListener(42, event -> this.onPaintItem(tree, event));
        tree.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> UIUtils.asyncExec(() -> ((Tree)tree).redraw())));
        Listener mouseListener = e -> {
            Object element;
            TreeItem item = tree.getItem(new Point(e.x, e.y));
            if (item != null && (element = item.getData()) instanceof DBNNode) {
                DBNNode node = (DBNNode)element;
                Cursor cursor = this.itemRenderer.getCursor(node, tree, e);
                if (tree.getCursor() != cursor) {
                    tree.setCursor(cursor);
                }
            }
        };
        tree.addListener(32, mouseListener);
        tree.addListener(5, mouseListener);
        tree.addListener(6, mouseListener);
        tree.addListener(7, mouseListener);
        tree.addListener(3, event -> this.onItemMouseDown(tree, event, false));
        tree.addListener(8, event -> this.onItemMouseDown(tree, event, true));
        LinuxKeyboardArrowsListener.installOn((Tree)tree);
        new NodeLoadersPainter().schedule();
    }

    @NotNull
    protected DatabaseNavigatorContentProvider createContentProvider(boolean showRoot) {
        return new DatabaseNavigatorContentProvider(this, showRoot);
    }

    @NotNull
    protected DatabaseNavigatorLabelProvider createLabelProvider(DatabaseNavigatorTree tree) {
        return new DatabaseNavigatorLabelProvider(tree);
    }

    public boolean isFilterShowConnected() {
        return this.filterShowConnected;
    }

    public void setFilterShowConnected(boolean filterShowConnected) {
        this.filterShowConnected = filterShowConnected;
    }

    @NotNull
    public DatabaseNavigatorTreeFilterObjectType getFilterObjectType() {
        return this.filterObjectType;
    }

    public void setFilterObjectType(@NotNull DatabaseNavigatorTreeFilterObjectType filterObjectType) {
        if (this.filterObjectType != filterObjectType) {
            this.filterObjectType = filterObjectType;
            this.updateFilterMessage();
        }
    }

    private void updateFilterMessage() {
        if (this.filterControl != null) {
            this.filterControl.setMessage(this.filterObjectType.getDescription());
        }
    }

    public ILabelDecorator getLabelDecorator() {
        return ((DatabaseNavigatorLabelProvider)this.treeViewer.getLabelProvider()).getLabelDecorator();
    }

    public void setLabelDecorator(ILabelDecorator labelDecorator) {
        ((DatabaseNavigatorLabelProvider)this.treeViewer.getLabelProvider()).setLabelDecorator(labelDecorator);
    }

    INavigatorItemRenderer getItemRenderer() {
        return this.itemRenderer;
    }

    void setItemRenderer(INavigatorItemRenderer itemRenderer) {
        this.itemRenderer = itemRenderer;
    }

    private void onPaintItem(Tree tree, Event event) {
        Object element;
        if (this.itemRenderer != null && (element = event.item.getData()) instanceof DBNNode) {
            DBNNode node = (DBNNode)element;
            try {
                this.itemRenderer.paintNodeDetails(node, tree, event.gc, event);
            }
            catch (Exception e) {
                log.debug((Object)("Error in node '" + String.valueOf(node) + "' paint"), (Throwable)e);
            }
        }
    }

    private void onItemMouseDown(Tree tree, Event event, boolean defaultAction) {
        Object element;
        TreeItem item;
        if (this.itemRenderer != null && event.button == 1 && (item = tree.getItem(new Point(event.x, event.y))) != null && (element = item.getData()) instanceof DBNNode) {
            DBNNode node = (DBNNode)element;
            this.itemRenderer.performAction(node, tree, event, defaultAction);
        }
    }

    public void setInput(DBNNode rootNode) {
        if (this.treeLoadingListener != null) {
            this.treeLoadingListener.close();
            this.treeLoadingListener = null;
        }
        this.treeViewer.setInput((Object)new DatabaseNavigatorContent(rootNode));
    }

    public INavigatorFilter getNavigatorFilter() {
        return this.navigatorFilter;
    }

    public void setNavigatorFilter(final INavigatorFilter navigatorFilter) {
        this.navigatorFilter = navigatorFilter;
        if (this.treeViewer != null) {
            this.treeViewer.addFilter(new ViewerFilter(this){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return navigatorFilter.select(element);
                }
            });
        }
    }

    @Nullable
    public Text getFilterControl() {
        return this.filterControl;
    }

    private TreeViewer doCreateTreeViewer(Composite parent, int style) {
        this.checkEnabled = (style & 0x20) != 0;
        final int treeStyle = 0x300 | style;
        if (this.checkEnabled) {
            if (this.navigatorFilter != null) {
                CustomFilteredTree filteredTree = new CustomFilteredTree(this, treeStyle){

                    @Override
                    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
                        return new CheckboxTreeViewer(parent, treeStyle);
                    }
                };
                this.filterControl = filteredTree.getFilterControl();
                return filteredTree.getViewer();
            }
            return new CheckboxTreeViewer(parent, treeStyle);
        }
        if (this.navigatorFilter != null) {
            CustomFilteredTree filteredTree = new CustomFilteredTree(treeStyle);
            this.filterControl = filteredTree.getFilterControl();
            return filteredTree.getViewer();
        }
        return this.doCreateNavigatorTreeViewer(parent, style);
    }

    private TreeViewer doCreateNavigatorTreeViewer(Composite parent, int style) {
        return new TreeViewer(this, parent, style){

            public ISelection getSelection() {
                ISelection selection = super.getSelection();
                if (!selection.isEmpty()) {
                    return selection;
                }
                Object rootNode = this.getInput();
                if (rootNode instanceof DatabaseNavigatorContent) {
                    DatabaseNavigatorContent dnc = (DatabaseNavigatorContent)rootNode;
                    rootNode = dnc.getRootNode();
                }
                return rootNode == null ? new TreeSelection() : new TreeSelection(new TreePath(new Object[]{rootNode}));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void handleTreeExpand(TreeEvent event) {
                this.getTree().setRedraw(false);
                try {
                    Object object;
                    if (event.item != null && (object = event.item.getData()) instanceof DBNProject) {
                        DBNProject dbnProject = (DBNProject)object;
                        dbnProject.getProject().setRuntimeProperty("user.decline.project.decryption", Boolean.FALSE.toString());
                    }
                    super.handleTreeExpand(event);
                }
                finally {
                    this.getTree().setRedraw(true);
                }
            }

            protected void handleTreeCollapse(TreeEvent event) {
                this.getTree().setRedraw(false);
                try {
                    super.handleTreeCollapse(event);
                }
                finally {
                    this.getTree().setRedraw(true);
                }
            }
        };
    }

    public DBNNode getModel() {
        DatabaseNavigatorContent content = (DatabaseNavigatorContent)this.treeViewer.getInput();
        return content.getRootNode();
    }

    private void initEditor() {
    }

    @NotNull
    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    @NotNull
    public CheckboxTreeViewer getCheckboxViewer() {
        return (CheckboxTreeViewer)this.treeViewer;
    }

    public boolean isFilterActive() {
        return this.treeFilter != null && this.treeFilter.isActive();
    }

    public boolean isMatchingNeeded(@NotNull Object element) {
        return this.treeFilter != null && this.treeFilter.isMatchingNeeded(element);
    }

    public void resetFilter() {
        if (this.filterControl != null) {
            this.filterControl.setText("");
        }
        if (this.treeFilter != null) {
            this.treeFilter.setPattern("");
        }
        this.treeViewer.refresh(true);
    }

    public void nodeChanged(DBNEvent event) {
        switch (event.getAction()) {
            case ADD: 
            case REMOVE: {
                DBNNode node = event.getNode();
                DBNNode parentNode = node.getParentNode();
                if (parentNode == null || this.treeViewer.getControl().isDisposed() || parentNode.isDisposed()) break;
                this.treeViewer.refresh(this.getViewerObject(parentNode));
                if (event.getNodeChange() != DBNEvent.NodeChange.SELECT) break;
                this.treeViewer.reveal((Object)node);
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)node));
                break;
            }
            case UPDATE: {
                if (this.treeViewer.getControl().isDisposed() || this.treeViewer.isBusy()) break;
                switch (event.getNodeChange()) {
                    case BEFORE_LOAD: {
                        this.startNodeLoadingVisualization(event.getNode());
                        break;
                    }
                    case AFTER_LOAD: {
                        this.stopNodeLoadingVisualization(event.getNode());
                        break;
                    }
                    case LOAD: {
                        this.treeViewer.refresh(this.getViewerObject(event.getNode()));
                        this.expandNodeOnLoad(event.getNode());
                        break;
                    }
                    case UNLOAD: {
                        this.stopNodeLoadingVisualization(event.getNode());
                        this.treeViewer.collapseToLevel((Object)event.getNode(), -1);
                        this.treeViewer.update(this.getViewerObject(event.getNode()), null);
                        this.treeViewer.collapseToLevel((Object)event.getNode(), -1);
                        break;
                    }
                    case REFRESH: {
                        this.treeViewer.refresh(this.getViewerObject(event.getNode()), true);
                        break;
                    }
                    case LOCK: 
                    case UNLOCK: 
                    case STRUCT_REFRESH: {
                        this.treeViewer.refresh(this.getViewerObject(event.getNode()));
                    }
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNodeLoadingVisualization(DBNNode node) {
        Set<DBNNode> set = nodeInLoadingProcess;
        synchronized (set) {
            nodeInLoadingProcess.add(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopNodeLoadingVisualization(DBNNode node) {
        Set<DBNNode> set = nodeInLoadingProcess;
        synchronized (set) {
            nodeInLoadingProcess.remove(node);
        }
    }

    private void expandNodeOnLoad(final DBNNode node) {
        if (node instanceof DBNDataSource && DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.expand.on.connect")) {
            DBRRunnableWithResult<DBNNode> runnable = new DBRRunnableWithResult<DBNNode>(){

                public void run(DBRProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        this.result = DatabaseNavigatorTree.this.findActiveNode(monitor, node);
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            RuntimeUtils.runTask((DBRRunnableWithProgress)runnable, (String)"Find active node", (long)2000L);
            if (runnable.getResult() != null && !this.treeViewer.getTree().isDisposed()) {
                this.showNode((DBNNode)runnable.getResult());
                this.treeViewer.expandToLevel(runnable.getResult(), 1);
            }
        }
    }

    @NotNull
    private DBNNode findActiveNode(@NotNull DBRProgressMonitor monitor, @NotNull DBNNode node) throws DBException {
        return this.findActiveNode(monitor, node, node);
    }

    @NotNull
    private DBNNode findActiveNode(@NotNull DBRProgressMonitor monitor, @NotNull DBNNode parent, @NotNull DBNNode node) throws DBException {
        Object[] children = node.getChildren(monitor);
        if (!ArrayUtils.isEmpty((Object[])children)) {
            if (children[0] instanceof DBNContainer) {
                return this.findActiveNode(monitor, node, (DBNNode)children[0]);
            }
            for (Object child : children) {
                if (!DBNUtils.isDefaultElement((Object)child)) continue;
                return this.findActiveNode(monitor, node, (DBNNode)child);
            }
        }
        return parent;
    }

    private Object getViewerObject(DBNNode node) {
        DatabaseNavigatorContent dnc;
        Object input = this.treeViewer.getInput();
        if (input instanceof DatabaseNavigatorContent && (dnc = (DatabaseNavigatorContent)input).getRootNode() == node) {
            return input;
        }
        return node;
    }

    void showNode(DBNNode node) {
        this.treeViewer.reveal((Object)node);
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)node));
    }

    public void reloadTree(DBNNode rootNode) {
        this.setInput(rootNode);
    }

    private void renameItem(TreeItem item) {
        this.disposeOldEditor();
        if (item.isDisposed()) {
            return;
        }
        final DBNNode node = (DBNNode)item.getData();
        Text text = new Text((Composite)this.treeViewer.getTree(), 2048);
        text.setText(node.getNodeDisplayName());
        text.selectAll();
        text.setFocus();
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                DatabaseNavigatorTree.this.disposeOldEditor();
            }
        });
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    Text text = (Text)DatabaseNavigatorTree.this.treeEditor.getEditor();
                    String newName = text.getText();
                    DatabaseNavigatorTree.this.disposeOldEditor();
                    DatabaseNavigatorTree.this.treeViewer.getTree().setFocus();
                    if (!CommonUtils.isEmpty((String)newName) && !newName.equals(node.getNodeDisplayName())) {
                        NavigatorHandlerObjectRename.renameNode(UIUtils.getActiveWorkbenchWindow(), DatabaseNavigatorTree.this.treeViewer.getControl().getShell(), node, newName, (Object)this);
                    }
                } else if (e.keyCode == 27) {
                    DatabaseNavigatorTree.this.disposeOldEditor();
                    DatabaseNavigatorTree.this.treeViewer.getTree().setFocus();
                }
            }
        });
        Rectangle itemBounds = item.getBounds(0);
        Rectangle treeBounds = this.treeViewer.getTree().getBounds();
        this.treeEditor.minimumWidth = Math.max(itemBounds.width, 50);
        this.treeEditor.minimumWidth = Math.min(this.treeEditor.minimumWidth, treeBounds.width - (itemBounds.x - treeBounds.x) - item.getImageBounds((int)0).width - 4);
        this.treeEditor.minimumHeight = text.computeSize((int)-1, (int)-1).y;
        this.treeEditor.setEditor((Control)text, item, 0);
    }

    private void disposeOldEditor() {
        Control oldEditor = this.treeEditor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
    }

    protected void onTreeRefresh() {
    }

    private class NodeLoadersPainter
    extends UIJob {
        private static final long REPAINT_DELAY = 100L;
        private static final long WAIT_DELAY = 500L;
        private int ticksCount;

        public NodeLoadersPainter() {
            super("NavigatorTreeLoadersPainterJob");
            this.ticksCount = 0;
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            Set<DBNNode> set = nodeInLoadingProcess;
            synchronized (set) {
                long nextDelay = 500L;
                if (!nodeInLoadingProcess.isEmpty()) {
                    ++this.ticksCount;
                    for (DBNNode node : nodeInLoadingProcess) {
                        Widget widget = DatabaseNavigatorTree.this.treeViewer.testFindItem((Object)node);
                        if (!(widget instanceof TreeItem)) continue;
                        TreeItem treeItem = (TreeItem)widget;
                        treeItem.setImage(this.getCurrentImage());
                        nextDelay = 100L;
                    }
                } else {
                    this.ticksCount = 0;
                }
                if (!DatabaseNavigatorTree.this.treeViewer.getTree().isDisposed()) {
                    this.schedule(nextDelay);
                }
            }
            return Status.OK_STATUS;
        }

        private Image getCurrentImage() {
            int imgIndex = this.ticksCount % UIIcon.LOADING.size();
            return DBeaverIcons.getImage((DBPImage)((DBPImage)UIIcon.LOADING.get(imgIndex)));
        }
    }

    private class CustomFilteredTree
    extends FilteredTree {
        CustomFilteredTree(int treeStyle) {
            super((Composite)DatabaseNavigatorTree.this, treeStyle, (PatternFilter)new TreeFilter(DatabaseNavigatorTree.this.navigatorFilter), true, true);
            try {
                if (this.treeViewer != null) {
                    this.treeViewer.setUseHashlookup(true);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ((GridLayout)this.getLayout()).verticalSpacing = 0;
            UIUtils.addDefaultEditActionsSupport((IServiceLocator)UIUtils.getActiveWorkbenchWindow(), (Control)this.getFilterControl());
            DatabaseNavigatorTree.this.treeFilter = (TreeFilter)super.getPatternFilter();
        }

        protected Composite createFilterControls(Composite parent) {
            DatabaseNavigatorTreeFilter dnf;
            super.createFilterControls(parent);
            INavigatorFilter iNavigatorFilter = DatabaseNavigatorTree.this.navigatorFilter;
            if (iNavigatorFilter instanceof DatabaseNavigatorTreeFilter && !(dnf = (DatabaseNavigatorTreeFilter)iNavigatorFilter).isConnectionsOnly()) {
                IMenuService menuService;
                ++((GridLayout)parent.getLayout()).numColumns;
                ToolBarManager filterManager = new ToolBarManager();
                filterManager.add((IContributionItem)new Separator("additions"));
                IWorkbenchWindow workbenchWindow = UIUtils.findWorkbenchWindow((Control)parent);
                if (workbenchWindow == null) {
                    workbenchWindow = UIUtils.getActiveWorkbenchWindow();
                }
                if ((menuService = (IMenuService)workbenchWindow.getService(IMenuService.class)) != null) {
                    menuService.populateContributionManager((ContributionManager)filterManager, DatabaseNavigatorTree.FILTER_TOOLBAR_CONTRIBUTION_ID);
                }
                filterManager.createControl(parent);
                parent.addDisposeListener(e -> filterManager.dispose());
            }
            return parent;
        }

        protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
            return ((DatabaseNavigatorTree)this.getParent()).doCreateNavigatorTreeViewer(parent, style);
        }

        protected WorkbenchJob doCreateRefreshJob() {
            return new WorkbenchJob("Refresh Filter"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    boolean initial;
                    if (CustomFilteredTree.this.treeViewer.getControl().isDisposed()) {
                        return Status.CANCEL_STATUS;
                    }
                    String text = CustomFilteredTree.this.getFilterString();
                    if (text == null) {
                        return Status.OK_STATUS;
                    }
                    boolean bl = initial = CustomFilteredTree.this.initialText != null && CustomFilteredTree.this.initialText.equals(text);
                    if (initial) {
                        CustomFilteredTree.this.getPatternFilter().setPattern(null);
                    } else {
                        CustomFilteredTree.this.getPatternFilter().setPattern(text);
                    }
                    Composite redrawFalseControl = CustomFilteredTree.this.treeComposite != null ? CustomFilteredTree.this.treeComposite : CustomFilteredTree.this.treeViewer.getControl();
                    try {
                        redrawFalseControl.setRedraw(false);
                        CustomFilteredTree.this.treeViewer.refresh(true);
                        if (!text.isEmpty() && !initial) {
                            CustomFilteredTree.this.updateToolbar(true);
                        } else {
                            CustomFilteredTree.this.updateToolbar(false);
                        }
                        ((DatabaseNavigatorTree)CustomFilteredTree.this.getParent()).onTreeRefresh();
                    }
                    finally {
                        redrawFalseControl.setRedraw(true);
                    }
                    return Status.OK_STATUS;
                }
            };
        }
    }

    private class TreeFilter
    extends PatternFilter {
        private final INavigatorFilter filter;
        private boolean hasPattern = false;
        private TextMatcherExt matcher;
        private TextMatcherExt matcherShort;
        private String[] dotPattern;

        TreeFilter(INavigatorFilter filter) {
            this.setIncludeLeadingWildcard(true);
            this.filter = filter;
        }

        public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
            int size = elements.length;
            ArrayList<Object> out = new ArrayList<Object>(size);
            for (Object element : elements) {
                if (!this.select(viewer, parent, element)) continue;
                out.add(element);
            }
            return out.toArray();
        }

        public void setPattern(String patternString) {
            this.hasPattern = !CommonUtils.isEmpty((String)patternString);
            this.dotPattern = null;
            if (patternString != null) {
                Object pattern = patternString;
                if (!patternString.endsWith(" ")) {
                    pattern = patternString + "*";
                }
                pattern = "*" + (String)pattern;
                this.matcher = new TextMatcherExt((String)pattern, true, false);
                this.dotPattern = patternString.split("\\.");
                if (this.dotPattern.length == 2) {
                    Object patternShort = this.dotPattern[1];
                    if (!((String)patternShort).endsWith(" ")) {
                        patternShort = (String)patternShort + "*";
                    }
                    patternShort = "*" + (String)patternShort;
                    this.matcherShort = new TextMatcherExt((String)patternShort, true, false);
                } else {
                    this.dotPattern = null;
                }
            } else {
                super.setPattern(null);
            }
        }

        protected boolean wordMatches(String text) {
            if (text == null) {
                return false;
            }
            if (this.matcher != null) {
                return this.matcher.match(text);
            }
            return super.wordMatches(text);
        }

        public boolean isElementVisible(Viewer viewer, Object element) {
            DBNDataSource dataSource;
            if (DatabaseNavigatorTree.this.filterShowConnected && element instanceof DBNDataSource && !(dataSource = (DBNDataSource)element).getDataSourceContainer().isConnected()) {
                return false;
            }
            if ((DatabaseNavigatorTree.this.filterShowConnected || this.hasPattern && DatabaseNavigatorTree.this.getFilterObjectType() == DatabaseNavigatorTreeFilterObjectType.connection || this.hasPattern && this.filter.filterFolders()) && element instanceof DBNLocalFolder) {
                return this.hasVisibleConnections(viewer, (DBNLocalFolder)element);
            }
            if (!this.filter.select(element)) {
                return false;
            }
            if (!this.isMatchingNeeded(element)) {
                return true;
            }
            String labelText = ((ILabelProvider)((ContentViewer)viewer).getLabelProvider()).getText(element);
            if (labelText == null) {
                return false;
            }
            return this.isPatternMatched(labelText, element);
        }

        public boolean isActive() {
            return this.matcher != null && !this.matcher.match("");
        }

        public boolean isMatchingNeeded(Object element) {
            boolean needToMatch = this.filter.filterObjectByPattern(element);
            if (!needToMatch && element instanceof DBNDatabaseNode) {
                DBNDatabaseNode node = (DBNDatabaseNode)element;
                DBSObject object = node.getObject();
                switch (DatabaseNavigatorTree.this.filterObjectType) {
                    case connection: {
                        needToMatch = object instanceof DBPDataSourceContainer;
                        break;
                    }
                    case container: {
                        boolean bl = needToMatch = object instanceof DBSSchema || object instanceof DBSCatalog;
                        if (!needToMatch) break;
                        try {
                            Class primaryChildType = ((DBSStructContainer)object).getPrimaryChildType(null);
                            needToMatch = !DBSStructContainer.class.isAssignableFrom(primaryChildType);
                        }
                        catch (Exception e) {
                            log.debug((Object)e);
                        }
                        break;
                    }
                    default: {
                        needToMatch = !(object instanceof DBPDataSourceContainer) && !(object instanceof DBSSchema) && !(object instanceof DBSCatalog) && !(object instanceof DBNDatabaseFolder) && !(object instanceof DBSTableColumn);
                    }
                }
            }
            return needToMatch;
        }

        private boolean isPatternMatched(String labelText, Object element) {
            boolean patternMatched = this.wordMatches(labelText);
            if (!patternMatched && this.dotPattern != null) {
                DBNNode item = null;
                if (element instanceof DBNDatabaseItem) {
                    DBNDatabaseItem di = (DBNDatabaseItem)element;
                    item = di.getParentNode();
                }
                boolean schemaMatched = false;
                while (item != null) {
                    if (item instanceof DBNDatabaseFolder) {
                        DBNDatabaseFolder df = (DBNDatabaseFolder)item;
                        item = df.getParentNode();
                        continue;
                    }
                    if (!(item instanceof DBNDatabaseItem)) break;
                    DBNDatabaseItem di = (DBNDatabaseItem)item;
                    DBSObject obj = di.getObject();
                    if (!(obj instanceof DBSStructContainer)) continue;
                    String name = obj.getName();
                    if (name == null) break;
                    schemaMatched = name.equalsIgnoreCase(this.dotPattern[0]);
                    break;
                }
                if (schemaMatched) {
                    return this.matcherShort.match(labelText);
                }
                return false;
            }
            if (!patternMatched && element instanceof DBNDatabaseItem) {
                DBNDatabaseItem item = (DBNDatabaseItem)element;
                DBSObject obj = item.getObject();
                labelText = obj == null ? null : obj.getDescription();
                patternMatched = this.wordMatches(labelText);
            }
            return patternMatched;
        }

        private boolean hasVisibleConnections(Viewer viewer, DBNLocalFolder folder) {
            DBNNode[] children = folder.getChildren((DBRProgressMonitor)new VoidProgressMonitor());
            if (children == null) {
                return false;
            }
            for (DBNNode child : children) {
                if (child instanceof DBNLocalFolder) {
                    DBNLocalFolder lf = (DBNLocalFolder)child;
                    if (!this.hasVisibleConnections(viewer, lf)) continue;
                    return true;
                }
                if (!this.isLeafMatch(viewer, child) || DatabaseNavigatorTree.this.filterShowConnected && child instanceof DBNDataSource && !((DBNDataSource)child).getDataSourceContainer().isConnected()) continue;
                return true;
            }
            return false;
        }
    }

    private class TreeSelectionAdapter
    implements MouseListener {
        private volatile TreeItem curSelection;
        private volatile RenameJob renameJob;

        private TreeSelectionAdapter() {
        }

        public synchronized void mouseDoubleClick(MouseEvent e) {
            this.curSelection = null;
            if (this.renameJob != null) {
                this.renameJob.canceled = true;
            }
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            if ((e.stateMask & 0x80000) == 0) {
                this.curSelection = null;
                return;
            }
            this.changeSelection(e);
        }

        void changeSelection(MouseEvent e) {
            DatabaseNavigatorTree.this.disposeOldEditor();
            TreeItem newSelection = DatabaseNavigatorTree.this.treeViewer.getTree().getItem(new Point(e.x, e.y));
            if (newSelection == null) {
                return;
            }
            IWorkbenchPart activePart = UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart();
            if (!(newSelection.getData() instanceof DBNNode) || activePart == null || !ActionUtils.isCommandEnabled((String)"org.eclipse.ui.edit.rename", (IServiceLocator)activePart.getSite())) {
                this.curSelection = null;
                return;
            }
            if (this.curSelection != null && this.curSelection == newSelection && (this.renameJob == null || this.renameJob.selection == null)) {
                if (this.renameJob == null) {
                    this.renameJob = new RenameJob();
                } else {
                    this.renameJob.cancel();
                }
                this.renameJob.selection = this.curSelection;
                this.renameJob.schedule(1000L);
            }
            this.curSelection = newSelection;
        }

        private class RenameJob
        extends AbstractUIJob {
            private volatile boolean canceled;
            public TreeItem selection;

            RenameJob() {
                super("Rename ");
                this.canceled = false;
            }

            @NotNull
            protected IStatus runInUIThread(@NotNull DBRProgressMonitor monitor) {
                try {
                    if (!DatabaseNavigatorTree.this.treeViewer.getTree().isDisposed() && DatabaseNavigatorTree.this.treeViewer.getTree().isFocusControl() && TreeSelectionAdapter.this.curSelection == this.selection && !this.canceled) {
                        TreeItem itemToRename = this.selection;
                        UIUtils.asyncExec(() -> DatabaseNavigatorTree.this.renameItem(itemToRename));
                    }
                }
                finally {
                    this.canceled = false;
                    this.selection = null;
                }
                return Status.OK_STATUS;
            }
        }
    }

    private static class TreeBackgroundColorPainter
    implements Listener {
        private DatabaseNavigatorLabelProvider labelProvider;

        TreeBackgroundColorPainter(DatabaseNavigatorLabelProvider labelProvider) {
            this.labelProvider = labelProvider;
        }

        public void handleEvent(Event event) {
            if ((event.detail & 2) == 0 && (event.detail & 0x20) == 0) {
                return;
            }
            TreeItem item = (TreeItem)event.item;
            Color colorBackground = this.labelProvider.getBackground(item.getData());
            if (colorBackground != null) {
                GC gc = event.gc;
                Color oldBackground = gc.getForeground();
                gc.setForeground(colorBackground);
                gc.drawRoundRectangle(event.x, event.y, event.width, event.height - 1, 3, 3);
                gc.setForeground(oldBackground);
            }
        }
    }
}

