/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public abstract class AbstractContextDescriptor
extends AbstractDescriptor {
    private static final String OBJECT_TYPE = "objectType";
    @NotNull
    private final AbstractDescriptor.ObjectType[] objectTypes;

    public AbstractContextDescriptor(@NotNull IConfigurationElement config) {
        super(config.getContributor().getName());
        ArrayList<AbstractDescriptor.ObjectType> objectTypes = new ArrayList<AbstractDescriptor.ObjectType>();
        String objectType = config.getAttribute(OBJECT_TYPE);
        if (objectType != null) {
            objectTypes.add((AbstractDescriptor)this.new AbstractDescriptor.ObjectType(objectType));
        }
        for (IConfigurationElement typeCfg : config.getChildren(OBJECT_TYPE)) {
            objectTypes.add((AbstractDescriptor)this.new AbstractDescriptor.ObjectType(typeCfg));
        }
        this.objectTypes = objectTypes.toArray(new AbstractDescriptor.ObjectType[0]);
    }

    public AbstractContextDescriptor(@NotNull String pluginId) {
        super(pluginId);
        this.objectTypes = new AbstractDescriptor.ObjectType[0];
    }

    public boolean hasObjectTypes() {
        return this.objectTypes.length > 0;
    }

    @NotNull
    public AbstractDescriptor.ObjectType[] getObjectTypes() {
        return this.objectTypes;
    }

    public boolean appliesTo(@NotNull DBPObject object) {
        return this.appliesTo(object, null);
    }

    public boolean matchesType(@NotNull Class<? extends DBSObject> objectClass) {
        for (AbstractDescriptor.ObjectType objectType : this.objectTypes) {
            if (!objectType.matchesType(objectClass)) continue;
            return true;
        }
        return false;
    }

    public boolean appliesTo(@NotNull DBPObject object, @Nullable Object context) {
        if (object instanceof DBSObject) {
            object = DBUtils.getPublicObject((DBSObject)object);
        }
        if (object == null) {
            return false;
        }
        Object adapted = this.adaptType(object);
        for (AbstractDescriptor.ObjectType objectType : this.objectTypes) {
            if (!objectType.appliesTo(object, context) && (adapted == null || !objectType.appliesTo(adapted, context))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected Object adaptType(@NotNull DBPObject object) {
        return null;
    }
}

