/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator.fs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.fs.DBFFileSystemDescriptor;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystem;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystemRoot;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNLazyNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystemRoot;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class DBNFileSystem
extends DBNNode
implements DBNLazyNode {
    private static final Log log = Log.getLog(DBNFileSystem.class);
    private DBFVirtualFileSystem fileSystem;
    private DBNFileSystemRoot[] children;

    public DBNFileSystem(@NotNull DBNNode parentNode, @NotNull DBFVirtualFileSystem fileSystem) {
        super(parentNode);
        this.fileSystem = fileSystem;
    }

    @NotNull
    public DBFVirtualFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public DBNFileSystemRoot getRoot(@NotNull String path) {
        if (this.children == null) {
            return null;
        }
        if (path.endsWith(":")) {
            path = path.substring(0, path.length() - 1);
        }
        for (DBNFileSystemRoot root : this.children) {
            if (!root.getRoot().getRootId().equals(path)) continue;
            return root;
        }
        return null;
    }

    public DBNFileSystemRoot getRoot(DBFVirtualFileSystemRoot dbfRoot) {
        if (this.children == null) {
            return null;
        }
        for (DBNFileSystemRoot root : this.children) {
            if (!CommonUtils.equalObjects((Object)root.getRoot(), (Object)dbfRoot)) continue;
            return root;
        }
        return null;
    }

    @Override
    public boolean isDisposed() {
        return this.fileSystem == null || super.isDisposed();
    }

    @Override
    protected void dispose(boolean reflect) {
        this.children = null;
        this.fileSystem = null;
        super.dispose(reflect);
    }

    @Override
    @NotNull
    public String getNodeType() {
        return DBNNode.NodePathType.dbvfs.name() + ".fileSystem";
    }

    @Override
    @NotNull
    public String getNodeTypeLabel() {
        return ModelMessages.fs_file_system;
    }

    @Override
    @Property(id="name", viewable=true, order=1)
    @NotNull
    public String getNodeDisplayName() {
        return this.fileSystem.getFileSystemDisplayName();
    }

    @Override
    @Nullable
    public String getNodeDescription() {
        return this.fileSystem.getDescription();
    }

    @Override
    @Nullable
    public DBPImage getNodeIcon() {
        DBFFileSystemDescriptor provider = DBWorkbench.getPlatform().getFileSystemRegistry().getFileSystemProvider(this.fileSystem.getProviderId());
        return provider == null ? DBIcon.TREE_FOLDER_LINK : provider.getIcon();
    }

    @Override
    public boolean allowsChildren() {
        return true;
    }

    @Nullable
    public DBNFileSystemRoot[] getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.children == null && !monitor.isForceCacheUsage()) {
            this.children = this.readChildNodes(monitor, null);
        }
        return this.children;
    }

    @Nullable
    public DBNFileSystemRoot getChild(@NotNull DBRProgressMonitor monitor, @NotNull String name) throws DBException {
        DBNFileSystemRoot[] roots = this.getChildren(monitor);
        if (roots != null) {
            for (DBNFileSystemRoot root : roots) {
                if (!root.getName().equals(name)) continue;
                return root;
            }
        }
        return null;
    }

    @NotNull
    protected DBNFileSystemRoot[] readChildNodes(@NotNull DBRProgressMonitor monitor, @Nullable DBNFileSystemRoot[] mergeWith) throws DBException {
        DBFVirtualFileSystem fileSystem = this.fileSystem;
        if (fileSystem == null || DBWorkbench.getPlatform().isShuttingDown()) {
            return new DBNFileSystemRoot[0];
        }
        ArrayList<DBNFileSystemRoot> result = new ArrayList<DBNFileSystemRoot>();
        if (mergeWith != null) {
            fileSystem.refreshRoots(monitor);
        }
        for (DBFVirtualFileSystemRoot dBFVirtualFileSystemRoot : fileSystem.getRootFolders(monitor)) {
            DBNFileSystemRoot newChild = null;
            if (mergeWith != null) {
                for (DBNFileSystemRoot oldRoot : mergeWith) {
                    if (!oldRoot.getName().equals(dBFVirtualFileSystemRoot.getName())) continue;
                    newChild = oldRoot;
                    break;
                }
            }
            if (newChild == null) {
                newChild = new DBNFileSystemRoot(this, dBFVirtualFileSystemRoot);
            }
            result.add(newChild);
        }
        if (mergeWith != null) {
            for (DBNFileSystemRoot oldRoot : mergeWith) {
                if (result.contains(oldRoot)) continue;
                DBNUtils.disposeNode(oldRoot, false);
                break;
            }
        }
        if (result.isEmpty()) {
            return new DBNFileSystemRoot[0];
        }
        DBNNode[] childNodes = result.toArray(new DBNFileSystemRoot[0]);
        this.sortChildren(childNodes);
        return childNodes;
    }

    @Override
    public boolean isManageable() {
        return true;
    }

    @Override
    @Nullable
    public DBNNode refreshNode(@NotNull DBRProgressMonitor monitor, @Nullable Object source) throws DBException {
        if (this.children != null) {
            this.children = this.readChildNodes(monitor, this.children);
        }
        this.getModel().fireNodeUpdate(this, this, DBNEvent.NodeChange.REFRESH);
        return this;
    }

    @Override
    @Deprecated
    @NotNull
    public String getNodeItemPath() {
        return this.getParentNode().getNodeItemPath() + "/" + this.getName();
    }

    @Override
    @NotNull
    public String getName() {
        return this.fileSystem.getId();
    }

    @Override
    public boolean supportsRename() {
        return false;
    }

    protected void sortChildren(DBNNode[] list) {
        Arrays.sort(list, (o1, o2) -> o1.getNodeDisplayName().compareToIgnoreCase(o2.getNodeDisplayName()));
    }

    public Collection<DBPDataSourceContainer> getAssociatedDataSources() {
        return Collections.emptyList();
    }

    public void refreshResourceState(Object source) {
        this.fireNodeEvent(new DBNEvent(source, DBNEvent.Action.UPDATE, this));
    }

    @Override
    @NotNull
    public String toString() {
        return this.fileSystem.getFileSystemDisplayName();
    }

    @Override
    public boolean needsInitialization() {
        return this.children == null;
    }
}

