/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class ServiceRegistry {
    private static final Log log = Log.getLog(ServiceRegistry.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.service";
    private static ServiceRegistry instance = null;
    private final Map<String, List<ServiceDescriptor>> services = new HashMap<String, List<ServiceDescriptor>>();

    public static synchronized ServiceRegistry getInstance() {
        if (instance == null) {
            instance = new ServiceRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private ServiceRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        for (IConfigurationElement ext : extElements = registry.getConfigurationElementsFor(EXTENSION_ID)) {
            ServiceDescriptor service = new ServiceDescriptor(ext);
            List descriptors = this.services.computeIfAbsent(service.type.getImplName(), s -> new ArrayList());
            descriptors.add(service);
        }
    }

    @Nullable
    public <T> T getService(@NotNull Class<T> serviceType) {
        List<ServiceDescriptor> descriptors = this.services.get(serviceType.getName());
        if (!CommonUtils.isEmpty(descriptors)) {
            boolean headlessMode = DBWorkbench.getPlatform().getApplication().isHeadlessMode();
            for (ServiceDescriptor descriptor : descriptors) {
                if (descriptors.size() > 1 && headlessMode != descriptor.headless) continue;
                if (!descriptor.singleton) {
                    try {
                        return descriptor.impl.createInstance(serviceType);
                    }
                    catch (DBException e) {
                        log.debug(e);
                        return null;
                    }
                }
                if (descriptor.instance == null) {
                    try {
                        descriptor.instance = descriptor.impl.createInstance(Object.class);
                    }
                    catch (DBException e) {
                        log.debug("Error creating service '" + serviceType.getName() + "'", e);
                    }
                }
                return (T)descriptor.instance;
            }
        }
        return null;
    }

    private static class ServiceDescriptor
    extends AbstractDescriptor {
        private final AbstractDescriptor.ObjectType type;
        private final AbstractDescriptor.ObjectType impl;
        private final boolean headless;
        private final boolean singleton;
        private Object instance;

        ServiceDescriptor(IConfigurationElement config) {
            super(config);
            this.type = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("name"));
            this.impl = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
            this.headless = CommonUtils.toBoolean((Object)config.getAttribute("headless"));
            this.singleton = CommonUtils.toBoolean((Object)config.getAttribute("singleton"), (boolean)true);
        }
    }
}

