/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class PropertySourceCustom
implements DBPPropertySource {
    private final List<DBPPropertyDescriptor> props = new ArrayList<DBPPropertyDescriptor>();
    private Map<String, Object> originalValues = new TreeMap<String, Object>();
    private final Map<String, Object> propValues = new TreeMap<String, Object>();
    private Map<String, Object> defaultValues = new TreeMap<String, Object>();
    private IVariableResolver defValueResolver = null;

    public PropertySourceCustom() {
    }

    public PropertySourceCustom(@NotNull Collection<? extends DBPPropertyDescriptor> properties, @Nullable Map<String, ?> values) {
        this.addProperties(properties);
        this.setValues(values);
    }

    public PropertySourceCustom(@NotNull DBPPropertyDescriptor[] properties, @NotNull Map<String, ?> values) {
        this.addProperties(properties);
        this.setValues(values);
    }

    public void setDefValueResolver(@NotNull IVariableResolver defValueResolver) {
        this.defValueResolver = defValueResolver;
    }

    public void setValues(@Nullable Map<String, ?> values) {
        this.originalValues = new HashMap<String, Object>();
        if (values != null) {
            block0: for (Map.Entry<String, ?> value : values.entrySet()) {
                Object propValue = value.getValue();
                for (DBPPropertyDescriptor prop : this.props) {
                    Class<?> dataType;
                    if (!prop.getId().equals(value.getKey())) continue;
                    if (propValue instanceof String && ((dataType = prop.getDataType()) != null && !CharSequence.class.isAssignableFrom(dataType) || !((String)propValue).isEmpty())) {
                        propValue = GeneralUtils.convertString((String)propValue, dataType);
                    }
                    this.originalValues.put(value.getKey(), propValue);
                    continue block0;
                }
            }
        }
    }

    public void setDefaultValues(@NotNull Map<String, Object> defaultValues) {
        this.defaultValues = defaultValues;
    }

    public void addDefaultValues(@NotNull Map<String, ?> defaultValues) {
        this.defaultValues.putAll(defaultValues);
    }

    @NotNull
    public Map<String, Object> getPropertyValues() {
        HashMap<String, Object> allValues = new HashMap<String, Object>(this.originalValues);
        allValues.putAll(this.propValues);
        return allValues;
    }

    @NotNull
    public Map<String, Object> getPropertiesWithDefaults() {
        HashMap<String, Object> allValues = new HashMap<String, Object>(this.defaultValues);
        allValues.putAll(this.originalValues);
        allValues.putAll(this.propValues);
        if (this.defValueResolver != null) {
            for (Map.Entry entry : allValues.entrySet()) {
                entry.setValue(this.getDefaultValue(entry.getValue()));
            }
        }
        return allValues;
    }

    public void addProperty(@NotNull DBPPropertyDescriptor property) {
        this.props.add(property);
        Object defaultValue = property.getDefaultValue();
        if (defaultValue != null) {
            this.defaultValues.put(property.getId(), defaultValue);
        }
    }

    public void addProperties(@NotNull Collection<? extends DBPPropertyDescriptor> properties) {
        this.props.addAll(properties);
        for (DBPPropertyDescriptor dBPPropertyDescriptor : properties) {
            Object defaultValue = dBPPropertyDescriptor.getDefaultValue();
            if (defaultValue == null) continue;
            this.defaultValues.put(dBPPropertyDescriptor.getId(), defaultValue);
        }
    }

    public void addProperties(DBPPropertyDescriptor[] properties) {
        Collections.addAll(this.props, properties);
        for (DBPPropertyDescriptor prop : properties) {
            Object defaultValue = prop.getDefaultValue();
            if (defaultValue == null) continue;
            this.defaultValues.put(prop.getId(), defaultValue);
        }
    }

    private Object getDefaultValue(Object defaultValue) {
        if (this.defValueResolver != null && defaultValue instanceof String) {
            return GeneralUtils.replaceVariables((String)defaultValue, this.defValueResolver);
        }
        return defaultValue;
    }

    @Override
    @NotNull
    public Object getEditableValue() {
        return this;
    }

    @Override
    @NotNull
    public DBPPropertyDescriptor[] getProperties() {
        return this.props.toArray(new DBPPropertyDescriptor[0]);
    }

    @Override
    @Nullable
    public Object getPropertyValue(@Nullable DBRProgressMonitor monitor, @NotNull String id) {
        if (id == null) {
            return null;
        }
        Object value = this.propValues.get(id);
        if (value == null) {
            value = this.originalValues.get(id);
        }
        if (value == null) {
            value = this.defaultValues.get(id);
        }
        return value != null ? this.getDefaultValue(value) : null;
    }

    @Override
    public boolean isPropertyResettable(@NotNull String id) {
        return true;
    }

    @Override
    public boolean isPropertySet(@NotNull String id) {
        Object value = this.getPropertyValue(null, id);
        if (value == null) {
            return false;
        }
        Object defaultValue = this.getDefaultValue(this.defaultValues.get(id));
        return !CommonUtils.equalObjects((Object)this.getDefaultValue(value), (Object)defaultValue);
    }

    @Override
    public void resetPropertyValue(@Nullable DBRProgressMonitor monitor, @NotNull String id) {
        this.propValues.remove(id);
    }

    @Override
    public void setPropertyValue(@Nullable DBRProgressMonitor monitor, @NotNull String id, @Nullable Object value) {
        if (!this.originalValues.containsKey(id)) {
            if (this.propValues.containsKey(id)) {
                this.originalValues.put(id, this.propValues.get(id));
            } else if (this.defaultValues.containsKey(id)) {
                this.originalValues.put(id, this.defaultValues.get(id));
            } else {
                this.originalValues.put(id, null);
            }
        }
        if (value == null || value.equals(this.originalValues.get(id))) {
            this.propValues.remove(id);
        } else {
            this.propValues.put(id, value);
        }
    }

    @Override
    public void resetPropertyValueToDefault(@NotNull String id) {
        this.propValues.remove(id);
        this.originalValues.remove(id);
    }

    public void removeAll() {
        this.props.clear();
        this.originalValues.clear();
        this.propValues.clear();
        this.defaultValues.clear();
    }
}

