/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.jkiss.code.NotNull;

public class ByteNumberFormat
extends NumberFormat {
    private static final long serialVersionUID = 1L;
    public static final Unit[] UNITS = Unit.values();
    private static final DecimalFormat fpFormat = new DecimalFormat("#.#");
    private final BinaryPrefix binaryPrefix;

    public ByteNumberFormat() {
        this.binaryPrefix = BinaryPrefix.JEDEC;
    }

    public ByteNumberFormat(@NotNull BinaryPrefix binaryPrefix) {
        this.binaryPrefix = binaryPrefix;
    }

    public static int computeIndex(double bytes) {
        int result;
        int index = 0;
        for (int i = 0; i < UNITS.length && (result = (int)(bytes / 1024.0)) != 0 && !((bytes /= 1024.0) < 1.0); ++i) {
            ++index;
        }
        return index;
    }

    public String getBytes(double bytes) {
        double intBytes;
        int index = ByteNumberFormat.computeIndex(bytes);
        if (index >= UNITS.length) {
            index = UNITS.length - 1;
        }
        if ((intBytes = bytes) == 0.0) {
            return String.valueOf(0);
        }
        for (int i = 0; i < index; ++i) {
            intBytes /= 1024.0;
        }
        String str = (long)intBytes >= 10L ? String.valueOf((long)intBytes) : fpFormat.format(intBytes);
        Unit unit = UNITS[index];
        if (unit == Unit.BYTE) {
            return str;
        }
        return str + (this.binaryPrefix == BinaryPrefix.ISO ? unit.isoPrefix : unit.jedecPrefix);
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        return toAppendTo.append(this.getBytes(number));
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return toAppendTo.append(this.getBytes(number));
    }

    @Override
    public Number parse(String source, ParsePosition parsePosition) {
        return null;
    }

    public static enum BinaryPrefix {
        JEDEC,
        ISO;

    }

    private static enum Unit {
        BYTE("B", "B"),
        KILOBYTE("K", "KiB"),
        MEGABYTE("M", "MiB"),
        GIGABYTE("G", "GiB"),
        TERABYTE("T", "TiB"),
        PETABYTE("P", "PiB");

        private final String jedecPrefix;
        private final String isoPrefix;

        private Unit(String jedecPrefix, String isoPrefix) {
            this.jedecPrefix = jedecPrefix;
            this.isoPrefix = isoPrefix;
        }
    }
}

