/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.vertica.model;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedureParameter;
import org.jkiss.dbeaver.ext.generic.model.GenericScriptObject;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.vertica.model.VerticaSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPUniqueObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractProcedure;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;

public class VerticaUDF
extends AbstractProcedure<GenericDataSource, GenericStructContainer>
implements GenericScriptObject,
DBPUniqueObject,
DBPRefreshableObject {
    private static final Pattern PATTERN_COL_NAME_NUMERIC = Pattern.compile("\\$?([0-9]+)");
    private String type;
    private String returnType;
    private String argumentType;
    private String definition;
    private String volatility;
    private boolean isStrict;
    private boolean isFenced;

    public VerticaUDF(VerticaSchema container, JDBCResultSet dbResult) {
        super((DBSObjectContainer)container, true, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"function_name"), null);
        this.type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"procedure_type");
        this.returnType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"function_return_type");
        this.argumentType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"function_argument_type");
        this.definition = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"function_definition");
        this.volatility = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"volatility");
        this.isStrict = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_strict");
        this.isFenced = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_fenced");
        this.setDescription(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"comment"));
    }

    @Property(viewable=true, order=3, labelProvider=GenericCatalog.CatalogNameTermProvider.class)
    public GenericCatalog getCatalog() {
        return ((GenericStructContainer)this.getContainer()).getCatalog();
    }

    public DBSProcedureType getProcedureType() {
        return DBSProcedureType.FUNCTION;
    }

    @Nullable
    public Collection<GenericProcedureParameter> getParameters(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getContainer(), this});
    }

    @NotNull
    public String getUniqueName() {
        return this.getName();
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        return this.definition;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this;
    }
}

