/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.ExasolSysTablePrefix;
import org.jkiss.dbeaver.ext.exasol.editors.ExasolObjectType;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolExecutionContext;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolScript;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableBase;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableColumn;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableForeignKey;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableUniqueKey;
import org.jkiss.dbeaver.ext.exasol.model.ExasolView;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCStructureAssistant;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractObjectReference;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;

public class ExasolStructureAssistant
extends JDBCStructureAssistant<ExasolExecutionContext> {
    private static final Log log = Log.getLog(ExasolStructureAssistant.class);
    private static final DBSObjectType[] HYPER_LINKS_TYPES = new DBSObjectType[]{ExasolObjectType.TABLE, ExasolObjectType.COLUMN, ExasolObjectType.VIEW, ExasolObjectType.SCHEMA, ExasolObjectType.SCRIPT, ExasolObjectType.FOREIGNKEY, ExasolObjectType.PRIMARYKEY};
    private static final DBSObjectType[] SUPP_OBJ_TYPES = new DBSObjectType[]{ExasolObjectType.TABLE, ExasolObjectType.VIEW, ExasolObjectType.COLUMN, ExasolObjectType.SCRIPT, ExasolObjectType.FOREIGNKEY, ExasolObjectType.PRIMARYKEY};
    private static final DBSObjectType[] AUTOC_OBJ_TYPES = new DBSObjectType[]{ExasolObjectType.TABLE, ExasolObjectType.VIEW, ExasolObjectType.COLUMN, ExasolObjectType.SCHEMA, ExasolObjectType.SCRIPT};
    private final ExasolDataSource dataSource;
    private final String sqlConstraintsSchema;
    private final String sqlConstraintsAll;

    public ExasolStructureAssistant(ExasolDataSource dataSource) {
        this.dataSource = dataSource;
        this.sqlConstraintsAll = "/*snapshot execution*/ SELECT CONSTRAINT_SCHEMA,CONSTRAINT_TABLE, CONSTRAINT_TYPE, CONSTRAINT_NAME FROM SYS." + dataSource.getTablePrefix(ExasolSysTablePrefix.ALL) + "_CONSTRAINTS WHERE CONSTRAINT_TYPE <> 'NOT NULL'  AND CONSTRAINT_NAME like '%s' AND CONSTRAINT_TYPE = '%s'";
        this.sqlConstraintsSchema = this.sqlConstraintsAll + " AND CONSTRAINT_SCHEMA = '%s'";
    }

    @NotNull
    public DBSObjectType[] getSupportedObjectTypes() {
        return SUPP_OBJ_TYPES;
    }

    @NotNull
    public DBSObjectType[] getSearchObjectTypes() {
        return this.getSupportedObjectTypes();
    }

    @NotNull
    public DBSObjectType[] getHyperlinkObjectTypes() {
        return HYPER_LINKS_TYPES;
    }

    @NotNull
    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return AUTOC_OBJ_TYPES;
    }

    protected void findObjectsByMask(@NotNull ExasolExecutionContext executionContext, @NotNull JDBCSession session, @NotNull DBSObjectType objectType, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull List<DBSObjectReference> references) throws DBException, SQLException {
        ExasolSchema schema;
        String objectNameMask = params.getMask();
        DBSObject parentObject = params.getParentObject();
        log.debug((Object)("Search Mask:" + objectNameMask + " Object Type:" + objectType.getTypeName()));
        ExasolSchema exasolSchema = schema = parentObject instanceof ExasolSchema ? (ExasolSchema)parentObject : null;
        if (schema == null && !params.isGlobalSearch()) {
            schema = executionContext.getContextDefaults().getDefaultSchema();
        }
        if (objectType == ExasolObjectType.TABLE) {
            this.findTableObjectByName(session, schema, params, references);
        } else if (objectType == ExasolObjectType.VIEW) {
            this.findViews(session, schema, params, references);
        } else if (objectType == ExasolObjectType.FOREIGNKEY) {
            this.findConstraintsByMask(session, schema, params, references, "FOREIGN KEY");
        } else if (objectType == ExasolObjectType.PRIMARYKEY) {
            this.findConstraintsByMask(session, schema, params, references, "PRIMARY KEY");
        } else if (objectType == ExasolObjectType.SCRIPT) {
            this.findProceduresByMask(session, schema, params, references);
        } else if (objectType == ExasolObjectType.COLUMN) {
            this.findTableColumnsByMask(session, schema, params, references);
        }
    }

    private void findTableColumnsByMask(@NotNull JDBCSession session, @Nullable ExasolSchema schema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull List<DBSObjectReference> references) throws SQLException, DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        String schemaMask = schema == null ? "%" : ExasolUtils.quoteString(schema.getName());
        String mask = ExasolUtils.quoteString(params.getMask());
        StringBuilder sql = new StringBuilder("/*snapshot execution*/ SELECT TABLE_SCHEM,TABLE_NAME as column_table,COLUMN_NAME from \"$ODBCJDBC\".ALL_COLUMNS WHERE TABLE_SCHEM like '");
        sql.append(schemaMask).append("' AND ");
        if (params.isSearchInComments()) {
            sql.append("(");
        }
        sql.append("COLUMN_NAME LIKE '").append(mask).append("'");
        if (params.isSearchInComments()) {
            sql.append(" OR COLUMN_COMMENT LIKE '").append(mask).append("')");
        }
        try (JDBCStatement dbStat = session.createStatement();
             JDBCResultSet dbResult = dbStat.executeQuery(sql.toString());){
            if (dbResult == null) {
                log.warn((Object)"Result set is null while looking for Exasol table columns");
                return;
            }
            while (!monitor.isCanceled() && dbResult.next() && references.size() <= params.getMaxResults()) {
                final String schemaName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_SCHEM");
                final String tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_TABLE");
                final String columnName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_NAME");
                if (tableName == null || columnName == null) continue;
                final ExasolSchema tableSchema = schema != null ? schema : this.dataSource.getSchema(monitor, schemaName);
                references.add((DBSObjectReference)new AbstractObjectReference<DBSObject>(this, columnName, (DBSObject)tableSchema, null, ExasolTableColumn.class, RelationalObjectType.TYPE_TABLE_COLUMN){

                    public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                        if (tableSchema == null) {
                            throw new DBException("Table schema '" + schemaName + "' not found");
                        }
                        ExasolTableBase table = tableSchema.getTable(monitor, tableName);
                        if (table == null && (table = (ExasolTableBase)tableSchema.getViewCache().getObject(monitor, tableSchema, tableName)) == null) {
                            throw new DBException("nor Table or view with name '" + tableName + "'  found in schema '" + schemaName + "'");
                        }
                        ExasolTableColumn tableColumn = ((ExasolTableBase)table).getAttribute(monitor, columnName);
                        if (tableColumn == null) {
                            throw new DBException("no table column with name '" + columnName + "'  found in table '" + schemaName + "." + tableName + "'");
                        }
                        return tableColumn;
                    }
                });
            }
        }
    }

    private void findProceduresByMask(@NotNull JDBCSession session, @Nullable ExasolSchema schema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull List<DBSObjectReference> references) throws SQLException, DBException {
        String mask = ExasolUtils.quoteString(params.getMask());
        StringBuilder sql = new StringBuilder("/*snapshot execution*/ SELECT SCRIPT_SCHEMA, SCRIPT_NAME FROM SYS.");
        sql.append(this.dataSource.getTablePrefix(ExasolSysTablePrefix.ALL)).append("_SCRIPTS WHERE ");
        ArrayList<String> clause = new ArrayList<String>(3);
        clause.add(ExasolStructureAssistant.getLikeClause("SCRIPT_NAME", mask, params.isCaseSensitive()));
        if (params.isSearchInDefinitions()) {
            clause.add(ExasolStructureAssistant.getLikeClause("SCRIPT_TEXT", mask, params.isCaseSensitive()));
        }
        if (params.isSearchInComments()) {
            clause.add(ExasolStructureAssistant.getLikeClause("SCRIPT_COMMENT", mask, params.isCaseSensitive()));
        }
        if (clause.size() == 1) {
            sql.append((String)clause.get(0));
        } else {
            sql.append("(").append(String.join((CharSequence)" OR ", clause)).append(")");
        }
        if (schema != null) {
            sql.append(String.format(" AND SCRIPT_SCHEMA = '%s'", ExasolUtils.quoteString(schema.getName())));
        }
        DBRProgressMonitor monitor = session.getProgressMonitor();
        try (JDBCStatement dbStat = session.createStatement();
             JDBCResultSet dbResult = dbStat.executeQuery(sql.toString());){
            if (dbResult == null) {
                log.debug((Object)"Result set is null when looking for Exasol procedures");
                return;
            }
            while (!monitor.isCanceled() && references.size() < params.getMaxResults() && dbResult.next()) {
                final String schemaName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SCRIPT_SCHEMA");
                final String scriptName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SCRIPT_NAME");
                if (scriptName == null) continue;
                final ExasolSchema tableSchema = schema != null ? schema : this.dataSource.getSchema(monitor, schemaName);
                references.add((DBSObjectReference)new AbstractObjectReference<ExasolSchema>(this, scriptName, tableSchema, null, ExasolScript.class, RelationalObjectType.TYPE_PROCEDURE){

                    public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                        if (tableSchema == null) {
                            throw new DBException("Table schema '" + schemaName + "' not found");
                        }
                        ExasolScript script = (ExasolScript)tableSchema.scriptCache.getObject(monitor, (DBSObject)tableSchema, scriptName);
                        if (script == null) {
                            throw new DBException("Script '" + String.valueOf(script) + "'  not found in schema '" + schemaName + "'");
                        }
                        return script;
                    }
                });
            }
        }
    }

    private void findConstraintsByMask(@NotNull JDBCSession session, final @Nullable ExasolSchema schema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull List<DBSObjectReference> references, String constType) throws SQLException, DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        String sql = "";
        sql = schema == null ? String.format(this.sqlConstraintsAll, ExasolUtils.quoteString(params.getMask()), constType) : String.format(this.sqlConstraintsSchema, ExasolUtils.quoteString(schema.getName()), constType, ExasolUtils.quoteString(params.getMask()));
        try (JDBCStatement dbStat = session.createStatement();
             JDBCResultSet dbResult = dbStat.executeQuery(sql);){
            if (dbResult == null) {
                log.debug((Object)"Result set is null when looking for Exasol constraints");
                return;
            }
            while (!monitor.isCanceled() && dbResult.next() && references.size() < params.getMaxResults()) {
                Class classType;
                final String schemaName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_SCHEMA");
                final String tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_TABLE");
                final String constName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_NAME");
                if (constType.equals("PRIMARY KEY")) {
                    classType = ExasolTableUniqueKey.class;
                } else if (constType.equals("FOREIGN KEY")) {
                    classType = ExasolTableForeignKey.class;
                } else {
                    throw new DBException("Unkown constraint type" + constType);
                }
                references.add((DBSObjectReference)new AbstractObjectReference<DBSObject>(constName, (DBSObject)this.dataSource.getSchema(monitor, schemaName), null, classType, RelationalObjectType.TYPE_CONSTRAINT){

                    public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                        ExasolSchema tableSchema;
                        ExasolSchema exasolSchema = tableSchema = schema != null ? schema : ExasolStructureAssistant.this.dataSource.getSchema(monitor, schemaName);
                        if (tableSchema == null) {
                            throw new DBException("Table schema '" + schemaName + "' not found");
                        }
                        ExasolTable table = tableSchema.getTable(monitor, tableName);
                        if (table == null) {
                            throw new DBException("Table '" + tableName + "' not found in schema  '" + schemaName + "' not found");
                        }
                        if (classType.equals(ExasolTableForeignKey.class)) {
                            ExasolTableForeignKey foreignKey = (ExasolTableForeignKey)table.getAssociation(monitor, constName);
                            if (foreignKey == null) {
                                throw new DBException("Foreign Key  '" + constName + "' for Table '" + tableName + "' not found in schema '" + schemaName + "'");
                            }
                            return foreignKey;
                        }
                        ExasolTableUniqueKey primaryKey = table.getConstraint(monitor, constName);
                        if (primaryKey == null) {
                            throw new DBException("Primary Key '" + constName + "' for Table '" + tableName + "' not found in schema '" + schemaName + "'");
                        }
                        return primaryKey;
                    }
                });
            }
        }
    }

    private void findTableObjectByName(@NotNull JDBCSession session, final @Nullable ExasolSchema schema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull Collection<? super DBSObjectReference> references) throws SQLException, DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        String mask = ExasolUtils.quoteString(params.getMask());
        StringBuilder sql = new StringBuilder("/*snapshot execution*/ SELECT table_schem,table_name as column_table,table_type from \"$ODBCJDBC\".ALL_TABLES WHERE ");
        if (schema != null) {
            sql.append("TABLE_SCHEM = '").append(schema.getName()).append("' AND ");
        }
        if (params.isSearchInComments()) {
            sql.append("(");
        }
        sql.append("TABLE_NAME LIKE '").append(mask).append("' ");
        if (params.isSearchInComments()) {
            sql.append("OR REMARKS LIKE '").append(mask).append("') ");
        }
        sql.append("AND TABLE_TYPE = 'TABLE'");
        try (JDBCStatement dbStat = session.createStatement();
             JDBCResultSet dbResult = dbStat.executeQuery(sql.toString());){
            if (dbResult == null) {
                log.debug((Object)"Result set is null when looking for Exasol table objects");
                return;
            }
            while (!monitor.isCanceled() && references.size() < params.getMaxResults() && dbResult.next()) {
                final String schemaName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_SCHEM");
                final String tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_TABLE");
                if (tableName == null) continue;
                ExasolSchema exasolSchema = this.dataSource.getSchema(monitor, schemaName);
                references.add((DBSObjectReference)new AbstractObjectReference<DBSObject>(tableName, (DBSObject)exasolSchema, null, ExasolTable.class, RelationalObjectType.TYPE_TABLE){

                    public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                        ExasolSchema tableSchema;
                        ExasolSchema exasolSchema = tableSchema = schema != null ? schema : ExasolStructureAssistant.this.dataSource.getSchema(monitor, schemaName);
                        if (tableSchema == null) {
                            throw new DBException("Table schema '" + schemaName + "' not found");
                        }
                        ExasolTable table = (ExasolTable)tableSchema.getTableCache().getObject(monitor, tableSchema, tableName);
                        if (table == null) {
                            throw new DBException("Table '" + tableName + "' not found in schema '" + schemaName + "'");
                        }
                        return table;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findViews(@NotNull JDBCSession session, @Nullable ExasolSchema schema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull Collection<? super DBSObjectReference> references) throws DBException, SQLException {
        int limit;
        DBRProgressMonitor monitor;
        String viewSchemaColumn = "VIEW_SCHEMA";
        String viewNameColumn = "VIEW_NAME";
        StringBuilder sql = new StringBuilder("/*snapshot execution*/");
        sql.append(" SELECT ");
        if (schema == null) {
            sql.append(viewSchemaColumn).append(", ");
        }
        sql.append(viewNameColumn).append(" FROM ").append(this.getMetadataTableName("VIEWS")).append(" WHERE ");
        ArrayList<String> clause = new ArrayList<String>(3);
        String mask = ExasolUtils.quoteString(params.getMask());
        clause.add(ExasolStructureAssistant.getLikeClause(viewNameColumn, mask, params.isCaseSensitive()));
        if (params.isSearchInDefinitions()) {
            clause.add(ExasolStructureAssistant.getLikeClause("VIEW_TEXT", mask, params.isCaseSensitive()));
        }
        if (params.isSearchInComments()) {
            clause.add(ExasolStructureAssistant.getLikeClause("VIEW_COMMENT", mask, params.isCaseSensitive()));
        }
        if (clause.size() == 1) {
            sql.append((String)clause.get(0));
        } else {
            sql.append("(").append(String.join((CharSequence)" OR ", clause)).append(")");
        }
        if (schema != null) {
            sql.append(String.format(" AND VIEW_SCHEMA = '%s'", ExasolUtils.quoteString(schema.getName())));
        }
        if (ExasolStructureAssistant.isFetchCompleted(monitor = session.getProgressMonitor(), references, limit = params.getMaxResults())) {
            return;
        }
        int halfOfWork = limit - references.size();
        monitor.beginTask("Fetching objects", halfOfWork * 2);
        try (JDBCStatement statement = session.createStatement();
             JDBCResultSet resultSet = statement.executeQuery(sql.toString());){
            monitor.worked(halfOfWork);
            if (resultSet == null) {
                log.debug((Object)"Result set is null");
                return;
            }
            while (!ExasolStructureAssistant.isFetchCompleted(monitor, references, limit) && resultSet.next()) {
                String viewName;
                ExasolSchema viewSchema = schema;
                if (viewSchema == null) {
                    String viewSchemaName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)viewSchemaColumn);
                    if (viewSchemaName == null) continue;
                    viewSchema = this.dataSource.getSchema(session.getProgressMonitor(), viewSchemaName);
                    if (viewSchema == null) {
                        log.warn((Object)String.format("Schema '%s' not found in schema cache of datasource '%s'", new Object[]{viewSchemaName, this.dataSource}));
                        continue;
                    }
                }
                if ((viewName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)viewNameColumn)) == null) continue;
                references.add((DBSObjectReference)new ViewReference(viewSchema, viewName));
            }
        }
        finally {
            monitor.done();
        }
    }

    private static boolean isFetchCompleted(@NotNull DBRProgressMonitor monitor, @NotNull Collection<?> objects, int limit) {
        return monitor.isCanceled() || objects.size() >= limit;
    }

    @NotNull
    private static String getLikeClause(@NotNull String identifier, @NotNull String mask, boolean isCaseSensitive) {
        if (isCaseSensitive) {
            return String.format("%s LIKE '%s'", identifier, mask);
        }
        return String.format("UPPER(%s) LIKE '%s'", identifier, mask.toUpperCase(Locale.ROOT));
    }

    @NotNull
    private String getMetadataTableName(@NotNull String suffix) {
        return "SYS." + this.dataSource.getTablePrefix(ExasolSysTablePrefix.ALL) + "_" + suffix;
    }

    protected JDBCDataSource getDataSource() {
        return this.dataSource;
    }

    public boolean supportsSearchInCommentsFor(@NotNull DBSObjectType objectType) {
        return objectType == ExasolObjectType.TABLE || objectType == ExasolObjectType.VIEW || objectType == ExasolObjectType.SCRIPT || objectType == ExasolObjectType.COLUMN;
    }

    public boolean supportsSearchInDefinitionsFor(@NotNull DBSObjectType objectType) {
        return objectType == ExasolObjectType.VIEW || objectType == ExasolObjectType.SCRIPT;
    }

    private static final class ViewReference
    extends AbstractObjectReference<ExasolSchema> {
        private ViewReference(@NotNull ExasolSchema container, @NotNull String name) {
            super(name, (DBSObject)container, null, ExasolView.class, RelationalObjectType.TYPE_VIEW);
        }

        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
            ExasolSchema schema = (ExasolSchema)this.getContainer();
            String viewName = this.getName();
            DBSObject view = schema.getViewCache().getObject(monitor, schema, viewName);
            if (view == null) {
                throw new DBException(String.format("View '%s' not found in schema '%s'", viewName, schema.getName()));
            }
            return view;
        }
    }
}

