/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.text;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ICommentsSupport;
import org.jkiss.dbeaver.ui.ISingleControlEditor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.IActionContributor;
import org.jkiss.dbeaver.ui.editors.INonPersistentEditorInput;
import org.jkiss.dbeaver.ui.editors.IStatefulEditorInput;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.editors.internal.EditorsMessages;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public abstract class BaseTextEditor
extends AbstractDecoratedTextEditor
implements ISingleControlEditor {
    public static final String TEXT_EDITOR_CONTEXT = "org.eclipse.ui.textEditorScope";
    public static final String GROUP_SQL_PREFERENCES = "sql.preferences";
    public static final String GROUP_SQL_ADDITIONS = "sql.additions";
    public static final String GROUP_SQL_EXTRAS = "sql.extras";
    private final List<IActionContributor> actionContributors = new ArrayList<IActionContributor>();

    public void addContextMenuContributor(IActionContributor contributor) {
        this.actionContributors.add(contributor);
    }

    public static BaseTextEditor getTextEditor(IEditorPart editor) {
        if (editor == null) {
            return null;
        }
        if (editor instanceof BaseTextEditor) {
            return (BaseTextEditor)editor;
        }
        return (BaseTextEditor)((Object)editor.getAdapter(BaseTextEditor.class));
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        if (input != this.getEditorInput()) {
            this.releaseEditorInput();
        }
        super.doSetInput(input);
    }

    public void dispose() {
        this.releaseEditorInput();
        super.dispose();
    }

    public void releaseEditorInput() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof IStatefulEditorInput) {
            ((IStatefulEditorInput)editorInput).release();
        }
    }

    @Nullable
    public IDocument getDocument() {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider == null) {
            return null;
        }
        return provider.getDocument((Object)this.getEditorInput());
    }

    @Nullable
    public StyledText getEditorControl() {
        TextViewer textViewer = this.getTextViewer();
        return textViewer == null ? null : textViewer.getTextWidget();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (this.getSite() instanceof SubEditorSite) {
            this.getTextViewer().getTextWidget().setKeyBinding(127, 127);
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new GroupMarker(GROUP_SQL_ADDITIONS));
        menu.add((IContributionItem)new GroupMarker(GROUP_SQL_EXTRAS));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("group.copy"));
        menu.add((IContributionItem)new Separator("group.print"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new Separator("group.find"));
        menu.add((IContributionItem)new Separator("group.add"));
        menu.add((IContributionItem)new Separator("group.undo"));
        menu.add((IContributionItem)new GroupMarker("group.save"));
        menu.add((IContributionItem)new Separator("group.rest"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker(GROUP_SQL_PREFERENCES));
        if (this.isEditable()) {
            this.addAction(menu, "group.undo", ITextEditorActionConstants.UNDO);
            this.addAction(menu, "group.save", ITextEditorActionConstants.SAVE);
            this.addAction(menu, "group.copy", ITextEditorActionConstants.CUT);
            this.addAction(menu, "group.copy", ITextEditorActionConstants.COPY);
            this.addAction(menu, "group.copy", ITextEditorActionConstants.PASTE);
            IAction action = this.getAction("QuickAssist");
            if (action != null && action.isEnabled()) {
                this.addAction(menu, "group.edit", "QuickAssist");
            }
        } else {
            this.addAction(menu, "group.copy", ITextEditorActionConstants.COPY);
        }
        IAction preferencesAction = this.getAction("Preferences.ContextAction");
        if (preferencesAction != null) {
            menu.appendToGroup(GROUP_SQL_PREFERENCES, preferencesAction);
        }
        for (IActionContributor ac : this.actionContributors) {
            ac.contributeActions((IContributionManager)menu);
        }
    }

    @Nullable
    public TextViewer getTextViewer() {
        return (TextViewer)this.getSourceViewer();
    }

    @Nullable
    public SourceViewer getViewer() {
        return (SourceViewer)super.getSourceViewer();
    }

    public void enableUndoManager(boolean enable) {
        TextViewer textViewer = this.getTextViewer();
        IUndoManager undoManager = textViewer.getUndoManager();
        if (undoManager != null) {
            if (!enable) {
                undoManager.disconnect();
            } else {
                undoManager.connect((ITextViewer)textViewer);
            }
        }
    }

    @Nullable
    public ICommentsSupport getCommentsSupport() {
        return null;
    }

    protected boolean isReadOnly() {
        return false;
    }

    public void loadFromExternalFile() {
        IDocument document;
        File[] loadFile = DialogUtils.openFileList((Shell)this.getSite().getShell(), (String)EditorsMessages.file_dialog_select_files, (String[])new String[]{"*.sql", "*.txt", "*", "*.*"});
        if (loadFile == null) {
            return;
        }
        StringBuilder newContent = new StringBuilder();
        for (File file : loadFile) {
            try {
                newContent.append(Files.readString(file.toPath(), GeneralUtils.DEFAULT_FILE_CHARSET));
                newContent.append(System.lineSeparator());
            }
            catch (IOException e) {
                DBWorkbench.getPlatformUI().showError(EditorsMessages.file_dialog_cannot_load_file, EditorsMessages.file_dialog_cannot_load_file + " '" + file.getAbsolutePath() + "' - " + e.getMessage());
            }
        }
        if (!CommonUtils.isEmpty((CharSequence)newContent) && (document = this.getDocument()) != null) {
            document.set(newContent.toString());
        }
    }

    public void saveToExternalFile() {
        this.saveToExternalFile(null);
    }

    public void saveToExternalFile(@Nullable String currentDirectory) {
        String fileName;
        IEditorInput editorInput = this.getEditorInput();
        File curFile = EditorUtils.getLocalFileFromInput(editorInput);
        String string = fileName = curFile == null ? null : curFile.getName();
        if (CommonUtils.isNotEmpty((String)currentDirectory)) {
            DialogUtils.setCurDialogFolder((String)currentDirectory);
        }
        IDocument document = this.getDocument();
        File saveFile = DialogUtils.selectFileForSave((Shell)this.getSite().getShell(), (String)EditorsMessages.file_dialog_save_as_file, (String[])new String[]{"*.sql", "*.txt", "*", "*.*"}, (String)fileName);
        if (document == null || saveFile == null) {
            return;
        }
        try {
            UIUtils.runInProgressService(monitor -> {
                try {
                    StringReader cr = new StringReader(document.get());
                    ContentUtils.saveContentToFile((Reader)cr, (File)saveFile, (String)ResourcesPlugin.getEncoding(), (DBRProgressMonitor)monitor);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError(EditorsMessages.file_dialog_save_failed, null, e.getTargetException());
        }
        this.afterSaveToFile(saveFile);
    }

    protected void afterSaveToFile(File saveFile) {
    }

    @Nullable
    public int[] getCurrentLines() {
        return null;
    }

    protected boolean isNonPersistentEditor() {
        return this.getEditorInput() instanceof INonPersistentEditorInput;
    }

    protected void setFocusToTextControl() {
        StyledText textWidget;
        SourceViewer viewer = this.getViewer();
        if (viewer != null && (textWidget = viewer.getTextWidget()) != null && !textWidget.isDisposed()) {
            textWidget.setFocus();
        }
    }
}

