/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.virtual;

import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.virtual.DBVAbstractContext;
import org.jkiss.dbeaver.model.virtual.DBVUtils;

public class DBVDataContext
extends DBVAbstractContext {
    public static final String VAR_TABLE = "table";
    public static final String VAR_ROW = "row";
    private final Map<String, Object> nsList = DBVUtils.getExpressionNamespaces();
    private final DBSObject dataContainer;
    private final DBDAttributeBinding[] attributes;
    private final Object[] row;
    private final String excludeName;

    public DBVDataContext(@NotNull DBSObject dataContainer, @NotNull DBDAttributeBinding[] allAttributes, @NotNull Object[] row, @Nullable String excludeName) {
        this.dataContainer = dataContainer;
        this.attributes = allAttributes;
        this.row = row;
        this.excludeName = excludeName;
    }

    public Object get(String s) {
        Object ns = this.nsList.get(s);
        if (ns != null) {
            return ns;
        }
        if (s.equals(this.excludeName)) {
            return null;
        }
        if (s.equals(VAR_ROW)) {
            return new RowInfo();
        }
        if (s.equals(VAR_TABLE)) {
            return new TableInfo();
        }
        for (DBDAttributeBinding attr : this.attributes) {
            if (!s.equals(attr.getLabel())) continue;
            return DBUtils.getAttributeValue(attr, this.attributes, this.row);
        }
        return null;
    }

    public class RowInfo
    extends DBVAbstractContext {
        public Object get(String s) {
            for (DBDAttributeBinding attr : DBVDataContext.this.attributes) {
                if (!s.equals(attr.getLabel())) continue;
                return DBUtils.getAttributeValue(attr, DBVDataContext.this.attributes, DBVDataContext.this.row);
            }
            return null;
        }
    }

    public class TableInfo
    extends DBVAbstractContext {
        public Object get(String s) {
            return switch (s) {
                case "name" -> DBVDataContext.this.dataContainer.getName();
                case "schema", "container" -> DBVDataContext.this.dataContainer.getParentObject();
                default -> null;
            };
        }
    }
}

