/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPGlobalEventListener;
import org.jkiss.dbeaver.model.app.DBPGlobalEventManager;

public class GlobalEventManagerImpl
implements DBPGlobalEventManager {
    private static final Log log = Log.getLog(GlobalEventManagerImpl.class);
    private static GlobalEventManagerImpl instance;
    private final List<DBPGlobalEventListener> listeners = new ArrayList<DBPGlobalEventListener>();

    public static GlobalEventManagerImpl getInstance() {
        if (instance == null) {
            instance = new GlobalEventManagerImpl();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private DBPGlobalEventListener[] getListenersCopy() {
        DBPGlobalEventListener[] listeners;
        List<DBPGlobalEventListener> list = this.listeners;
        synchronized (list) {
            listeners = this.listeners.toArray(new DBPGlobalEventListener[0]);
        }
        return listeners;
    }

    public void fireGlobalEvent(@NotNull String eventId, @NotNull Map<String, Object> properties) {
        for (DBPGlobalEventListener listener : this.getListenersCopy()) {
            listener.handleGlobalEvent(eventId, properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(@NotNull DBPGlobalEventListener listener) {
        List<DBPGlobalEventListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(@NotNull DBPGlobalEventListener listener) {
        List<DBPGlobalEventListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }
}

