/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceTask;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPEnumWithValue;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLState;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class JDBCUtils {
    public static boolean LOG_JDBC_WARNINGS = CommonUtils.toBoolean((Object)System.getProperty("dbeaver.jdbc.log.warnings"));
    private static final Log log = Log.getLog(JDBCUtils.class);
    private static final Map<String, Integer> badColumnNames = new HashMap<String, Integer>();

    @Nullable
    public static String safeGetString(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getString(columnName);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static String safeGetStringTrimmed(ResultSet dbResult, String columnName) {
        try {
            String value = dbResult.getString(columnName);
            if (value != null && !value.isEmpty()) {
                return value.trim();
            }
            return value;
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static String safeGetString(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getString(columnIndex);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return null;
        }
    }

    @Nullable
    public static String safeGetStringTrimmed(ResultSet dbResult, int columnIndex) {
        try {
            String value = dbResult.getString(columnIndex);
            if (value != null && !value.isEmpty()) {
                return value.trim();
            }
            return value;
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return null;
        }
    }

    public static void setStringOrNull(PreparedStatement dbStat, int columnIndex, String value) throws SQLException {
        if (value != null) {
            dbStat.setString(columnIndex, value);
        } else {
            dbStat.setNull(columnIndex, 12);
        }
    }

    public static int safeGetInt(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getInt(columnName);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return 0;
        }
    }

    public static int safeGetInt(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getInt(columnIndex);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return 0;
        }
    }

    @Nullable
    public static Integer safeGetInteger(ResultSet dbResult, String columnName) {
        try {
            int result = dbResult.getInt(columnName);
            if (dbResult.wasNull()) {
                return null;
            }
            return result;
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static Integer safeGetInteger(ResultSet dbResult, int columnIndex) {
        try {
            int result = dbResult.getInt(columnIndex);
            if (dbResult.wasNull()) {
                return null;
            }
            return result;
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return null;
        }
    }

    public static long safeGetLong(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getLong(columnName);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return 0L;
        }
    }

    public static long safeGetLong(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getLong(columnIndex);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return 0L;
        }
    }

    @Nullable
    public static Long safeGetLongNullable(ResultSet dbResult, String columnName) {
        try {
            long result = dbResult.getLong(columnName);
            return dbResult.wasNull() ? null : Long.valueOf(result);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    public static double safeGetDouble(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getDouble(columnName);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return 0.0;
        }
    }

    public static double safeGetDouble(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getDouble(columnIndex);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return 0.0;
        }
    }

    public static float safeGetFloat(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getFloat(columnName);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return 0.0f;
        }
    }

    public static float safeGetFloat(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getFloat(columnIndex);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return 0.0f;
        }
    }

    @Nullable
    public static BigDecimal safeGetBigDecimal(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getBigDecimal(columnName);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static BigDecimal safeGetBigDecimal(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getBigDecimal(columnIndex);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return null;
        }
    }

    public static boolean safeGetBoolean(ResultSet dbResult, String columnName) {
        return JDBCUtils.safeGetBoolean(dbResult, columnName, false);
    }

    public static boolean safeGetBoolean(ResultSet dbResult, String columnName, boolean defValue) {
        try {
            return dbResult.getBoolean(columnName);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return defValue;
        }
    }

    public static boolean safeGetBoolean(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getBoolean(columnIndex);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return false;
        }
    }

    public static boolean safeGetBoolean(@NotNull ResultSet dbResult, int columnIndex, @NotNull String trueValue) {
        try {
            String strValue = dbResult.getString(columnIndex);
            return strValue != null && strValue.startsWith(trueValue);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return false;
        }
    }

    public static boolean safeGetBoolean(ResultSet dbResult, String columnName, String trueValue) {
        try {
            String strValue = dbResult.getString(columnName);
            return strValue != null && strValue.startsWith(trueValue);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return false;
        }
    }

    @Nullable
    public static byte[] safeGetBytes(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getBytes(columnName);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static Timestamp safeGetTimestamp(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getTimestamp(columnName);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static Timestamp safeGetTimestamp(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getTimestamp(columnIndex);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return null;
        }
    }

    @Nullable
    public static Date safeGetDate(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getDate(columnName);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static Date safeGetDate(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getDate(columnIndex);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return null;
        }
    }

    @Nullable
    public static Time safeGetTime(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getTime(columnName);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static Time safeGetTime(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getTime(columnIndex);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return null;
        }
    }

    @Nullable
    public static SQLXML safeGetXML(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getSQLXML(columnName);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static SQLXML safeGetXML(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getSQLXML(columnIndex);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return null;
        }
    }

    @Nullable
    public static Object safeGetObject(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getObject(columnName);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static Object safeGetObject(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getObject(columnIndex);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return null;
        }
    }

    @Nullable
    public static <T> T safeGetArray(ResultSet dbResult, String columnName) {
        try {
            Array array = dbResult.getArray(columnName);
            return (T)(array == null ? null : array.getArray());
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static Object safeGetArray(ResultSet dbResult, int columnIndex) {
        try {
            Array array = dbResult.getArray(columnIndex);
            return array == null ? null : array.getArray();
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return null;
        }
    }

    @Nullable
    public static <T extends Enum<T>> T safeGetEnum(@NotNull ResultSet dbResult, @NotNull String columnName, @NotNull Class<T> type) {
        try {
            int value = dbResult.getInt(columnName);
            for (Enum constant : (Enum[])type.getEnumConstants()) {
                if (((DBPEnumWithValue)constant).getValue() != value) continue;
                return (T)constant;
            }
            log.debug((Object)("Can't convert value " + value + " to enum type " + String.valueOf(type)));
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
        }
        return null;
    }

    @Nullable
    public static String normalizeIdentifier(@Nullable String value) {
        return value == null ? null : value.trim();
    }

    public static boolean isConnectionAlive(DBPDataSource dataSource, Connection connection) {
        try {
            if (connection == null || connection.isClosed()) {
                return false;
            }
        }
        catch (SQLException e) {
            log.debug((Object)e);
            return false;
        }
        for (DBPDataSourceTask task : dataSource.getContainer().getTasks()) {
            if (!task.isActiveTask()) continue;
            return true;
        }
        String testSQL = dataSource.getSQLDialect().getTestSQL();
        int invalidateTimeout = dataSource.getContainer().getPreferenceStore().getInt("connection.validation.timeout");
        boolean[] isValid = new boolean[1];
        RuntimeUtils.runTask(monitor -> {
            block11: {
                try {
                    if (!CommonUtils.isEmpty((String)testSQL)) {
                        try (Statement dbStat = connection.createStatement();){
                            dbStat.execute(testSQL);
                            isValid[0] = true;
                            break block11;
                        }
                    }
                    try {
                        isValid[0] = connection.isValid(invalidateTimeout);
                    }
                    catch (Throwable e) {
                        connection.getMetaData().getTables(null, null, "DBEAVERFAKETABLENAMEFORPING", null);
                        isValid[0] = true;
                    }
                }
                catch (SQLException e) {
                    isValid[0] = false;
                }
            }
        }, (String)("Ping connection " + dataSource.getContainer().getName()), (long)(invalidateTimeout + 2000), (boolean)true);
        return isValid[0];
    }

    public static void scrollResultSet(ResultSet dbResult, long offset, boolean forceFetch) throws SQLException {
        boolean scrolled = false;
        if (!forceFetch) {
            try {
                scrolled = dbResult.absolute((int)offset);
            }
            catch (IncompatibleClassChangeError | UnsupportedOperationException | SQLException e) {
                log.debug((Object)e.getMessage());
            }
        }
        if (!scrolled) {
            for (long i = 1L; i <= offset; ++i) {
                try {
                    dbResult.next();
                    continue;
                }
                catch (SQLException e) {
                    throw new SQLException("Can't scroll result set to row " + offset, e);
                }
            }
        }
    }

    public static void reportWarnings(JDBCSession session, SQLWarning rootWarning) {
        for (SQLWarning warning = rootWarning; warning != null; warning = warning.getNextWarning()) {
            if (warning.getMessage() == null && warning.getErrorCode() == 0) continue;
            log.warn((Object)("SQL Warning (DataSource: " + session.getDataSource().getContainer().getName() + "; Code: " + warning.getErrorCode() + "; State: " + warning.getSQLState() + "): " + warning.getLocalizedMessage()));
        }
    }

    @NotNull
    public static String limitQueryLength(@NotNull String query, int maxLength) {
        return query.length() <= maxLength ? query : query.substring(0, maxLength);
    }

    public static DBSForeignKeyModifyRule getCascadeFromNum(int num) {
        return switch (num) {
            case 3 -> DBSForeignKeyModifyRule.NO_ACTION;
            case 0 -> DBSForeignKeyModifyRule.CASCADE;
            case 2 -> DBSForeignKeyModifyRule.SET_NULL;
            case 4 -> DBSForeignKeyModifyRule.SET_DEFAULT;
            case 1 -> DBSForeignKeyModifyRule.RESTRICT;
            default -> DBSForeignKeyModifyRule.UNKNOWN;
        };
    }

    public static DBSForeignKeyModifyRule getCascadeFromName(String name) {
        return switch (name) {
            case "NO ACTION" -> DBSForeignKeyModifyRule.NO_ACTION;
            case "CASCADE" -> DBSForeignKeyModifyRule.CASCADE;
            case "SET NULL" -> DBSForeignKeyModifyRule.SET_NULL;
            case "SET DEFAULT" -> DBSForeignKeyModifyRule.SET_DEFAULT;
            case "RESTRICT" -> DBSForeignKeyModifyRule.RESTRICT;
            default -> DBSForeignKeyModifyRule.UNKNOWN;
        };
    }

    public static void executeSQL(Connection session, String sql, Object ... params) throws SQLException {
        try (PreparedStatement dbStat = session.prepareStatement(sql);){
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    dbStat.setObject(i + 1, params[i]);
                }
            }
            dbStat.execute();
        }
    }

    public static int executeUpdate(Connection session, String sql, Object ... params) throws SQLException {
        try (PreparedStatement dbStat = session.prepareStatement(sql);){
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    dbStat.setObject(i + 1, params[i]);
                }
            }
            int n = dbStat.executeUpdate();
            return n;
        }
    }

    public static void executeProcedure(Connection session, String sql) throws SQLException {
        try (CallableStatement dbStat = session.prepareCall(sql);){
            dbStat.execute();
        }
    }

    public static <T> T executeQuery(Connection session, String sql, Object ... params) throws SQLException {
        try (PreparedStatement dbStat = session.prepareStatement(sql);){
            T t;
            block18: {
                ResultSet resultSet;
                block16: {
                    Object object;
                    block17: {
                        if (params != null) {
                            for (int i = 0; i < params.length; ++i) {
                                dbStat.setObject(i + 1, params[i]);
                            }
                        }
                        resultSet = dbStat.executeQuery();
                        try {
                            if (!resultSet.next()) break block16;
                            object = resultSet.getObject(1);
                            if (resultSet == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return (T)object;
                }
                t = null;
                if (resultSet == null) break block18;
                resultSet.close();
            }
            return t;
        }
    }

    public static void executeStatement(Connection session, String sql, Object ... params) throws SQLException {
        try (PreparedStatement dbStat = session.prepareStatement(sql);){
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    dbStat.setObject(i + 1, params[i]);
                }
            }
            dbStat.execute();
        }
    }

    public static void executeStatement(Connection session, String sql) throws SQLException {
        try (Statement dbStat = session.createStatement();){
            dbStat.execute(sql);
        }
    }

    @Nullable
    public static String queryString(Connection session, String sql, Object ... args) throws SQLException {
        try (PreparedStatement dbStat = session.prepareStatement(sql);){
            String string;
            block18: {
                ResultSet resultSet;
                block16: {
                    String string2;
                    block17: {
                        if (args != null) {
                            for (int i = 0; i < args.length; ++i) {
                                dbStat.setObject(i + 1, args[i]);
                            }
                        }
                        resultSet = dbStat.executeQuery();
                        try {
                            if (!resultSet.next()) break block16;
                            string2 = resultSet.getString(1);
                            if (resultSet == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return string2;
                }
                string = null;
                if (resultSet == null) break block18;
                resultSet.close();
            }
            return string;
        }
    }

    @Nullable
    public static <T> T queryObject(Connection session, String sql, Object ... args) throws SQLException {
        try (PreparedStatement dbStat = session.prepareStatement(sql);){
            T t;
            block18: {
                ResultSet resultSet;
                block16: {
                    Object object;
                    block17: {
                        if (args != null) {
                            for (int i = 0; i < args.length; ++i) {
                                dbStat.setObject(i + 1, args[i]);
                            }
                        }
                        resultSet = dbStat.executeQuery();
                        try {
                            if (!resultSet.next()) break block16;
                            object = resultSet.getObject(1);
                            if (resultSet == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return (T)object;
                }
                t = null;
                if (resultSet == null) break block18;
                resultSet.close();
            }
            return t;
        }
    }

    @NotNull
    public static List<String> queryStrings(Connection session, String sql, Object ... args) throws SQLException {
        try (PreparedStatement dbStat = session.prepareStatement(sql);){
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    dbStat.setObject(i + 1, args[i]);
                }
            }
            ArrayList<String> results = new ArrayList<String>();
            try (ResultSet resultSet = dbStat.executeQuery();){
                while (resultSet.next()) {
                    results.add(resultSet.getString(1));
                }
            }
            ArrayList<String> arrayList = results;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void debugColumnRead(ResultSet dbResult, String columnName, Exception error) {
        Object colFullId = columnName;
        if (dbResult instanceof JDBCResultSet) {
            colFullId = (String)colFullId + ":" + ((JDBCResultSet)dbResult).getSession().getDataSource().getContainer().getId();
        }
        Map<String, Integer> map = badColumnNames;
        synchronized (map) {
            Integer errorCount = badColumnNames.get(colFullId);
            if (errorCount == null) {
                log.debug((Object)("Can't get column '" + columnName + "': " + error.getMessage()));
            }
            badColumnNames.put((String)colFullId, errorCount == null ? 0 : errorCount + 1);
        }
    }

    private static void debugColumnRead(ResultSet dbResult, int columnIndex, Exception error) {
        JDBCUtils.debugColumnRead(dbResult, "#" + columnIndex, error);
    }

    public static void appendFilterClause(@NotNull StringBuilder sql, @NotNull DBSObjectFilter filter, @NotNull String columnAlias, @NotNull boolean firstClause) {
        JDBCUtils.appendFilterClause(sql, filter, columnAlias, firstClause, null);
    }

    public static void appendFilterClause(@NotNull StringBuilder sql, @NotNull DBSObjectFilter filter, @NotNull String columnAlias, @NotNull boolean firstClause, DBPDataSource dataSource) {
        List exclude;
        if (filter.isNotApplicable()) {
            return;
        }
        if (filter.hasSingleMask()) {
            if (columnAlias != null) {
                firstClause = SQLUtils.appendFirstClause((StringBuilder)sql, (boolean)firstClause);
                sql.append(columnAlias);
            }
            SQLUtils.appendLikeCondition((StringBuilder)sql, (String)filter.getSingleMask(), (boolean)false, (SQLDialect)(dataSource != null ? dataSource.getSQLDialect() : null));
            return;
        }
        List include = filter.getInclude();
        if (!CommonUtils.isEmpty((Collection)include)) {
            if (columnAlias != null) {
                firstClause = SQLUtils.appendFirstClause((StringBuilder)sql, (boolean)firstClause);
            }
            sql.append("(");
            int includeSize = include.size();
            for (int i = 0; i < includeSize; ++i) {
                if (i > 0) {
                    sql.append(" OR ");
                }
                if (columnAlias != null) {
                    sql.append(columnAlias);
                }
                SQLUtils.appendLikeCondition((StringBuilder)sql, (String)((String)include.get(i)), (boolean)false, (SQLDialect)(dataSource != null ? dataSource.getSQLDialect() : null));
            }
            sql.append(")");
        }
        if (!CommonUtils.isEmpty((Collection)(exclude = filter.getExclude()))) {
            if (columnAlias != null) {
                SQLUtils.appendFirstClause((StringBuilder)sql, (boolean)firstClause);
            }
            sql.append("NOT (");
            int excludeSize = exclude.size();
            for (int i = 0; i < excludeSize; ++i) {
                if (i > 0) {
                    sql.append(" OR ");
                }
                if (columnAlias != null) {
                    sql.append(columnAlias);
                }
                SQLUtils.appendLikeCondition((StringBuilder)sql, (String)((String)exclude.get(i)), (boolean)false, (SQLDialect)(dataSource != null ? dataSource.getSQLDialect() : null));
            }
            sql.append(")");
        }
    }

    public static void setFilterParameters(PreparedStatement statement, int paramIndex, DBSObjectFilter filter) throws SQLException {
        if (filter.isNotApplicable()) {
            return;
        }
        for (String inc : CommonUtils.safeCollection((Collection)filter.getInclude())) {
            statement.setString(paramIndex++, SQLUtils.makeSQLLike((String)inc));
        }
        for (String exc : CommonUtils.safeCollection((Collection)filter.getExclude())) {
            statement.setString(paramIndex++, SQLUtils.makeSQLLike((String)exc));
        }
    }

    public static void rethrowSQLException(Throwable e) throws SQLException {
        if (e instanceof InvocationTargetException) {
            Throwable targetException = ((InvocationTargetException)e).getTargetException();
            if (targetException instanceof SQLException) {
                throw (SQLException)targetException;
            }
            throw new SQLException(targetException);
        }
    }

    @NotNull
    public static DBPDataKind resolveDataKind(@Nullable DBPDataSource dataSource, String typeName, int typeID) {
        if (dataSource == null) {
            return JDBCDataSource.getDataKind(typeName, typeID);
        }
        if (dataSource instanceof DBPDataTypeProvider) {
            return ((DBPDataTypeProvider)dataSource).resolveDataKind(typeName, typeID);
        }
        return DBPDataKind.UNKNOWN;
    }

    public static String escapeWildCards(JDBCSession session, String string) {
        if (string == null || string.isEmpty() || string.indexOf(37) == -1 && string.indexOf(95) == -1) {
            return string;
        }
        try {
            SQLDialect dialect = SQLUtils.getDialectFromDataSource((DBPDataSource)session.getDataSource());
            String escapeStr = dialect.getSearchStringEscape();
            if (CommonUtils.isEmpty((String)escapeStr) || escapeStr.equals(" ")) {
                return string;
            }
            return string.replace("%", escapeStr + "%").replace("_", escapeStr + "_");
        }
        catch (Throwable e) {
            log.debug((Object)"Error escaping wildcard string", e);
            return string;
        }
    }

    public static boolean queryHasOutputParameters(SQLDialect sqlDialect, String sqlQuery) {
        return sqlQuery.contains("?");
    }

    public static Long queryLong(Connection session, String sql, Object ... params) throws SQLException {
        Number result = (Number)JDBCUtils.executeQuery(session, sql, params);
        if (result != null) {
            return result.longValue();
        }
        return null;
    }

    public static long executeInsertAutoIncrement(Connection session, String sql, String columnName, Object ... params) throws SQLException {
        try (PreparedStatement dbStat = session.prepareStatement(sql, JDBCUtils.getColumnList(columnName));){
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    dbStat.setObject(i + 1, params[i]);
                }
            }
            dbStat.execute();
            long l = JDBCUtils.getGeneratedKey(dbStat);
            return l;
        }
    }

    public static long getGeneratedKey(PreparedStatement dbStat) throws SQLException {
        try (ResultSet keysRS = dbStat.getGeneratedKeys();){
            keysRS.next();
            long l = keysRS.getLong(1);
            return l;
        }
    }

    public static void executeInMetaSession(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object, @NotNull String task, @NotNull String sql) throws DBCException, SQLException {
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)object, (String)task);
             JDBCStatement statement = session.createStatement();){
            statement.execute(sql);
        }
    }

    public static String[] getColumnList(@NotNull String columnName) {
        return new String[]{columnName.toLowerCase()};
    }

    public static boolean isRollbackWarning(SQLException sqlError) {
        return SQLState.SQL_25P01.getCode().equals(sqlError.getSQLState());
    }

    public static boolean isFeatureNotSupportedError(@Nullable DBPDataSource dataSource, @NotNull Throwable ex) {
        return ex instanceof SQLFeatureNotSupportedException || dataSource != null && DBExecUtils.discoverErrorType((DBPDataSource)dataSource, (Throwable)ex) == DBPErrorAssistant.ErrorType.FEATURE_UNSUPPORTED;
    }
}

