/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerExecutionContext;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObject;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObjectType;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerProcedure;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTable;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableBase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableCheckConstraint;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableForeignKey;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerView;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractObjectReference;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.utils.CommonUtils;

public class SQLServerStructureAssistant
implements DBSStructureAssistant<SQLServerExecutionContext> {
    private static final Log log = Log.getLog(SQLServerStructureAssistant.class);
    private final SQLServerDataSource dataSource;

    public SQLServerStructureAssistant(SQLServerDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @NotNull
    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{SQLServerObjectType.S, SQLServerObjectType.U, SQLServerObjectType.IT, SQLServerObjectType.V, SQLServerObjectType.SN, SQLServerObjectType.P, SQLServerObjectType.FN, SQLServerObjectType.FT, SQLServerObjectType.FS, SQLServerObjectType.X};
    }

    @NotNull
    public DBSObjectType[] getSearchObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_VIEW, SQLServerObjectType.SN, RelationalObjectType.TYPE_PROCEDURE, SQLServerObjectType.SCHEMA};
    }

    @NotNull
    public DBSObjectType[] getHyperlinkObjectTypes() {
        return new DBSObjectType[]{SQLServerObjectType.S, SQLServerObjectType.U, SQLServerObjectType.IT, SQLServerObjectType.V, RelationalObjectType.TYPE_PROCEDURE};
    }

    @NotNull
    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return new DBSObjectType[]{SQLServerObjectType.U, SQLServerObjectType.V, SQLServerObjectType.P, SQLServerObjectType.FN, SQLServerObjectType.IF, SQLServerObjectType.TF, SQLServerObjectType.X, SQLServerObjectType.SN};
    }

    @NotNull
    public List<DBSObjectReference> findObjectsByMask(@NotNull DBRProgressMonitor monitor, @NotNull SQLServerExecutionContext executionContext, @NotNull DBSStructureAssistant.ObjectsSearchParams params) throws DBException {
        if (params.getMask().startsWith("%#") || params.getMask().startsWith("#")) {
            try (JDBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.META, "Find temp tables by name");){
                ArrayList<DBSObjectReference> objects = new ArrayList<DBSObjectReference>();
                this.searchTempTables(session, params, objects);
                ArrayList<DBSObjectReference> arrayList = objects;
                return arrayList;
            }
        }
        return this.findAllObjects(monitor, executionContext, params);
    }

    private List<DBSObjectReference> findAllObjects(@NotNull DBRProgressMonitor monitor, @NotNull SQLServerExecutionContext executionContext, @NotNull DBSStructureAssistant.ObjectsSearchParams params) throws DBException {
        Collection<SQLServerDatabase> databases;
        DBSObject parentObject = params.getParentObject();
        boolean globalSearch = params.isGlobalSearch();
        SQLServerSchema schema = null;
        if (parentObject == null || parentObject instanceof DataSourceDescriptor) {
            if (globalSearch) {
                databases = executionContext.getDataSource().getDatabases(monitor);
            } else {
                database = executionContext.getContextDefaults().getDefaultCatalog();
                if (database == null) {
                    database = executionContext.getDataSource().getDefaultDatabase(monitor);
                }
                schema = executionContext.getContextDefaults().getDefaultSchema();
                if (database == null || schema == null) {
                    return Collections.emptyList();
                }
                databases = Collections.singletonList(database);
            }
        } else if (parentObject instanceof SQLServerDatabase) {
            database = (SQLServerDatabase)parentObject;
            databases = Collections.singletonList(database);
            if (!globalSearch && (schema = executionContext.getContextDefaults().getDefaultSchema()) == null) {
                return Collections.emptyList();
            }
        } else if (parentObject instanceof SQLServerSchema) {
            schema = (SQLServerSchema)parentObject;
            database = schema.getDatabase();
            databases = Collections.singletonList(database);
        } else if (parentObject instanceof SQLServerObject) {
            databases = Collections.singletonList(((SQLServerObject)parentObject).getDatabase());
        } else if (parentObject instanceof DBPDataSourceContainer) {
            database = executionContext.getContextDefaults().getDefaultCatalog();
            if (database == null) {
                database = executionContext.getDataSource().getDefaultDatabase(monitor);
            }
            databases = Collections.singletonList(database);
        } else {
            return Collections.emptyList();
        }
        if (CommonUtils.isEmpty(databases)) {
            return Collections.emptyList();
        }
        ArrayList<SQLServerObjectType> supObjectTypes = new ArrayList<SQLServerObjectType>(params.getObjectTypes().length + 2);
        for (DBSObjectType objectType : params.getObjectTypes()) {
            if (objectType instanceof SQLServerObjectType) {
                supObjectTypes.add((SQLServerObjectType)objectType);
                continue;
            }
            if (objectType == RelationalObjectType.TYPE_PROCEDURE) {
                supObjectTypes.addAll(SQLServerObjectType.getTypesForClass(SQLServerProcedure.class));
                continue;
            }
            if (objectType == RelationalObjectType.TYPE_TABLE) {
                supObjectTypes.addAll(SQLServerObjectType.getTypesForClass(SQLServerTable.class));
                continue;
            }
            if (objectType == RelationalObjectType.TYPE_CONSTRAINT) {
                supObjectTypes.addAll(SQLServerObjectType.getTypesForClass(SQLServerTableCheckConstraint.class));
                supObjectTypes.addAll(SQLServerObjectType.getTypesForClass(SQLServerTableForeignKey.class));
                continue;
            }
            if (objectType != RelationalObjectType.TYPE_VIEW) continue;
            supObjectTypes.addAll(SQLServerObjectType.getTypesForClass(SQLServerView.class));
        }
        if (supObjectTypes.isEmpty()) {
            return Collections.emptyList();
        }
        StringBuilder objectTypeClause = new StringBuilder(100);
        for (SQLServerObjectType objectType : supObjectTypes) {
            if (objectTypeClause.length() > 0) {
                objectTypeClause.append(",");
            }
            objectTypeClause.append("'").append(objectType.getTypeID()).append("'");
        }
        if (objectTypeClause.length() == 0) {
            return Collections.emptyList();
        }
        boolean hasMask = !CommonUtils.isEmpty((String)params.getMask()) && !params.getMask().equals("%");
        StringBuilder sqlBuilder = new StringBuilder("SELECT TOP %d schema_id, name, type FROM %s o");
        if (params.isSearchInComments()) {
            sqlBuilder.append(" LEFT JOIN sys.extended_properties ep ON ((o.parent_object_id = 0 AND ep.minor_id = 0 AND o.object_id = ep.major_id) OR (o.parent_object_id <> 0 AND ep.minor_id = o.parent_object_id AND ep.major_id = o.object_id)) ");
        }
        sqlBuilder.append(" WHERE o.type IN (").append((CharSequence)objectTypeClause).append(") ");
        if (hasMask) {
            boolean addParentheses;
            sqlBuilder.append("AND ");
            boolean bl = addParentheses = params.isSearchInComments() || params.isSearchInDefinitions();
            if (addParentheses) {
                sqlBuilder.append("(");
            }
            sqlBuilder.append("o.name LIKE ? ");
            if (params.isSearchInComments()) {
                sqlBuilder.append("OR (ep.name = 'MS_Description' AND CAST(ep.value AS nvarchar) LIKE ?)");
            }
            if (params.isSearchInDefinitions()) {
                if (params.isSearchInComments()) {
                    sqlBuilder.append(" ");
                }
                sqlBuilder.append("OR OBJECT_DEFINITION(o.object_id) LIKE ?");
            }
            if (addParentheses) {
                sqlBuilder.append(") ");
            }
        }
        boolean isNeedSchemaSearch = supObjectTypes.contains((Object)SQLServerObjectType.SCHEMA);
        if (schema != null) {
            sqlBuilder.append("AND o.schema_id = ? ");
        } else if (isNeedSchemaSearch) {
            sqlBuilder.append(" UNION ALL\nSELECT TOP %d schema_id, name, 'SCHEMA'\n");
            sqlBuilder.append("FROM %s\n");
            sqlBuilder.append("WHERE name LIKE ? \n");
            sqlBuilder.append("ORDER BY o.name");
        }
        String template = sqlBuilder.toString();
        ArrayList<DBSObjectReference> objects = new ArrayList<DBSObjectReference>();
        try (final JDBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.META, "Find objects by name");){
            for (SQLServerDatabase database : databases) {
                int rowsToFetch = params.getMaxResults() - objects.size();
                if (rowsToFetch < 1) {
                    break;
                }
                String sql = String.format(template, rowsToFetch, SQLServerUtils.getSystemTableName(database, "all_objects"), rowsToFetch, SQLServerUtils.getSystemTableName(database, "schemas"));
                try {
                    JDBCPreparedStatement dbStat = session.prepareStatement(sql);
                    try {
                        int idx = 1;
                        if (hasMask) {
                            dbStat.setString(1, params.getMask());
                            ++idx;
                            if (params.isSearchInComments()) {
                                dbStat.setString(idx, params.getMask());
                                ++idx;
                            }
                            if (params.isSearchInDefinitions()) {
                                dbStat.setString(idx, params.getMask());
                                ++idx;
                            }
                        }
                        if (schema != null) {
                            dbStat.setLong(idx, schema.getObjectId());
                        } else if (isNeedSchemaSearch) {
                            dbStat.setString(idx++, params.getMask());
                        }
                        dbStat.setFetchSize(1000);
                        JDBCResultSet dbResult = dbStat.executeQuery();
                        try {
                            while (dbResult.next() && !session.getProgressMonitor().isCanceled() && objects.size() < params.getMaxResults()) {
                                long schemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"schema_id");
                                final String objectName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name");
                                final String objectTypeName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"type");
                                final SQLServerObjectType objectType = SQLServerObjectType.valueOf(objectTypeName);
                                final SQLServerSchema objectSchema = schemaId == 0L ? null : database.getSchema(session.getProgressMonitor(), schemaId);
                                objects.add((DBSObjectReference)new AbstractObjectReference<DBSObject>(this, objectName, (DBSObject)(objectSchema != null ? objectSchema : database), null, objectType.getTypeClass(), (DBSObjectType)objectType){

                                    public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                                        DBSObject object = objectType.findObject(session.getProgressMonitor(), objectSchema, objectName);
                                        if (object == null) {
                                            throw new DBException(objectTypeName + " '" + objectName + "' not found");
                                        }
                                        return object;
                                    }
                                });
                            }
                        }
                        finally {
                            if (dbResult == null) continue;
                            dbResult.close();
                        }
                    }
                    finally {
                        if (dbStat == null) continue;
                        dbStat.close();
                    }
                }
                catch (SQLException e) {
                    log.debug((Object)("Unable to perform metadata search in mssql instance. databaseName=" + database.getName() + ", schema=" + (schema != null ? schema.getName() : "null")), (Throwable)e);
                }
            }
        }
        return objects;
    }

    public boolean supportsSearchInCommentsFor(@NotNull DBSObjectType objectType) {
        return true;
    }

    public boolean supportsSearchInDefinitionsFor(@NotNull DBSObjectType objectType) {
        return true;
    }

    private void searchTempTables(final @NotNull JDBCSession session, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull List<DBSObjectReference> objects) throws DBException {
        SQLServerDatabase database = this.dataSource.getDatabase(session.getProgressMonitor(), "tempdb");
        final SQLServerSchema schema = database.getSchema(session.getProgressMonitor(), "dbo");
        StringBuilder sql = new StringBuilder().append("SELECT TOP ").append(params.getMaxResults() - objects.size()).append(" *").append("\nFROM ").append(SQLServerUtils.getSystemTableName(database, "all_objects")).append("\nWHERE type = '").append(SQLServerObjectType.U.name()).append("' AND name LIKE '#%' AND name LIKE ? AND OBJECT_ID(CONCAT('").append("tempdb").append("..', QUOTENAME(name))) <> 0");
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());){
            dbStat.setString(1, "%" + params.getMask() + "%");
            dbStat.setFetchSize(1000);
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (dbResult.next() && !session.getProgressMonitor().isCanceled()) {
                    final String objectName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name");
                    final String objectNameTrimmed = SQLServerStructureAssistant.extractTempTableName(objectName);
                    final SQLServerObjectType objectType = SQLServerObjectType.valueOf(JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"type"));
                    objects.add((DBSObjectReference)new AbstractObjectReference<SQLServerDatabase>(this, objectName, database, null, objectType.getTypeClass(), (DBSObjectType)objectType){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            SQLServerTableBase object = schema.getChild(session.getProgressMonitor(), objectName);
                            if (object == null) {
                                schema.getTableCache().setFullCache(false);
                                object = schema.getChild(session.getProgressMonitor(), objectName);
                            }
                            if (object == null) {
                                throw new DBException(objectType.name() + " '" + objectName + "' not found");
                            }
                            return object;
                        }

                        @NotNull
                        public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
                            return objectNameTrimmed;
                        }
                    });
                }
            }
        }
        catch (Throwable e) {
            throw new DBDatabaseException("Error while searching in system catalog", e, (DBPDataSource)this.dataSource);
        }
    }

    @NotNull
    private static String extractTempTableName(@NotNull String originalName) {
        if (originalName.startsWith("##")) {
            return originalName;
        }
        String name = originalName.substring(0, 116);
        for (int i = name.length() - 1; i >= 0; --i) {
            if (name.charAt(i) == '_') continue;
            return name.substring(0, i + 1);
        }
        return name;
    }
}

