/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.ui.views;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.altibase.AltibaseConstants;
import org.jkiss.dbeaver.ext.altibase.ui.internal.AltibaseUIMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageAltibase
extends TargetPrefPage {
    static final Log log = Log.getLog(PrefPageAltibase.class);
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.altibase.general";
    private int planTypeIdx;
    private Button[] planTypeBtns;
    private Button enableDbmsOutputCheck;
    private Button enablePlanPrefixDepthCheck;

    public PrefPageAltibase() {
        this.setPreferenceStore((IPreferenceStore)new PreferenceStoreDelegate(DBWorkbench.getPlatform().getPreferenceStore()));
    }

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("altibase.explain.plan.type") || store.contains("altibase.dbms.output") || store.contains("altibase.plan.prefix");
    }

    @NotNull
    protected Control createPreferenceContent(Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        Composite planGroup = UIUtils.createTitledComposite((Composite)composite, (String)AltibaseUIMessages.pref_page_altibase_explain_plan_legend, (int)1, (int)768);
        Label descLabel = new Label(planGroup, 64);
        descLabel.setText(AltibaseUIMessages.pref_page_altibase_explain_plan_content);
        GridData gd = new GridData(32);
        descLabel.setLayoutData((Object)gd);
        int i = 0;
        final int size = AltibaseConstants.ExplainPlan.values().length;
        this.planTypeBtns = new Button[size];
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                for (int i = 0; i < size; ++i) {
                    if (PrefPageAltibase.this.planTypeBtns[i] == null || !PrefPageAltibase.this.planTypeBtns[i].getSelection()) continue;
                    PrefPageAltibase.this.planTypeIdx = i;
                }
            }
        };
        for (AltibaseConstants.ExplainPlan explainplan : AltibaseConstants.ExplainPlan.values()) {
            this.planTypeBtns[i++] = UIUtils.createRadioButton((Composite)planGroup, (String)explainplan.getTitle(), null, (SelectionListener)selectionListener);
        }
        Composite miscGroup = UIUtils.createTitledComposite((Composite)composite, (String)AltibaseUIMessages.pref_page_altibase_legend_misc, (int)1, (int)768);
        this.enableDbmsOutputCheck = UIUtils.createCheckbox((Composite)miscGroup, (String)AltibaseUIMessages.pref_page_altibase_checkbox_enable_dbms_output, (boolean)true);
        this.enablePlanPrefixDepthCheck = UIUtils.createCheckbox((Composite)miscGroup, (String)AltibaseUIMessages.pref_page_altibase_checkbox_plan_prefix_depth, (boolean)true);
        return composite;
    }

    protected void loadPreferences(DBPPreferenceStore store) {
        this.planTypeIdx = store.getInt("altibase.explain.plan.type");
        if (this.planTypeBtns[this.planTypeIdx] != null) {
            this.selectButtonEvent(this.planTypeIdx);
        }
        this.enableDbmsOutputCheck.setSelection(store.getBoolean("altibase.dbms.output"));
        this.enablePlanPrefixDepthCheck.setSelection(store.getBoolean("altibase.plan.prefix"));
    }

    protected void savePreferences(DBPPreferenceStore store) {
        store.setValue("altibase.explain.plan.type", this.planTypeIdx);
        store.setValue("altibase.dbms.output", this.enableDbmsOutputCheck.getSelection());
        store.setValue("altibase.plan.prefix", this.enablePlanPrefixDepthCheck.getSelection());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("altibase.explain.plan.type");
        store.setToDefault("altibase.dbms.output");
        store.setToDefault("altibase.plan.prefix");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    protected String getPropertyPageID() {
        return PAGE_ID;
    }

    private void selectButtonEvent(int idx) {
        if (this.planTypeBtns[this.planTypeIdx] != null) {
            this.planTypeBtns[idx].setSelection(true);
            this.planTypeBtns[idx].notifyListeners(13, new Event());
        }
    }
}

