/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLGroupingAttribute;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.utils.CommonUtils;

public class SQLGroupingQueryGenerator {
    private static final Log log = Log.getLog(SQLGroupingQueryGenerator.class);
    public static final String FUNCTION_COUNT = "COUNT";
    public static final String DEFAULT_FUNCTION = "COUNT(*)";
    @NotNull
    private final DBPDataSource dataSource;
    @NotNull
    private final DBSDataContainer container;
    @NotNull
    private final SQLDialect dialect;
    @NotNull
    private final SQLSyntaxManager syntaxManager;
    @NotNull
    private final List<SQLGroupingAttribute> groupAttributes;
    @NotNull
    private final List<String> groupFunctions;
    private final boolean showDuplicatesOnly;
    private String[] funcAliases = new String[0];

    public SQLGroupingQueryGenerator(@NotNull DBPDataSource dataSource, @NotNull DBSDataContainer container, @NotNull SQLDialect dialect, @NotNull SQLSyntaxManager syntaxManager, @NotNull List<SQLGroupingAttribute> groupAttributes, @NotNull List<String> groupFunctions, boolean showDuplicatesOnly) {
        this.dataSource = dataSource;
        this.container = container;
        this.dialect = dialect;
        this.syntaxManager = syntaxManager;
        this.groupAttributes = groupAttributes;
        this.groupFunctions = groupFunctions;
        this.showDuplicatesOnly = showDuplicatesOnly;
    }

    @NotNull
    public String generateGroupingQuery(String queryText) throws DBException {
        String subqueryAlias;
        Select select;
        boolean isCTE;
        if (queryText == null || queryText.isEmpty()) {
            if (this.container != null) {
                queryText = this.container.getName();
            } else {
                throw new DBException("Empty data container");
            }
        }
        for (String delimiter : this.syntaxManager.getStatementDelimiters()) {
            while (queryText.endsWith(delimiter)) {
                queryText = queryText.substring(0, queryText.length() - delimiter.length());
            }
        }
        boolean useAliasForColumns = this.dataSource.getSQLDialect().supportsAliasInSelect();
        StringBuilder sql = new StringBuilder();
        this.funcAliases = new String[this.groupFunctions.size()];
        for (int i = 0; i < this.groupFunctions.size(); ++i) {
            this.funcAliases[i] = useAliasForColumns ? this.makeGroupFunctionAlias(this.groupFunctions, i) : this.groupFunctions.get(i);
        }
        Statement statement = null;
        try {
            statement = SQLSemanticProcessor.parseQuery((SQLDialect)this.dataSource.getSQLDialect(), (String)queryText);
        }
        catch (Throwable e) {
            log.debug((Object)"SQL parse error", e);
        }
        boolean bl = isCTE = statement instanceof Select && (select = (Select)statement).getWithItemsList() != null && !select.getWithItemsList().isEmpty();
        if (!(this.container instanceof DBSEntity) && this.dialect.supportsSubqueries() && !isCTE) {
            int i;
            subqueryAlias = "src";
            sql.append("SELECT ");
            for (i = 0; i < this.groupAttributes.size(); ++i) {
                if (i > 0) {
                    sql.append(", ");
                }
                sql.append(this.groupAttributes.get(i).prepareSqlString(subqueryAlias));
            }
            for (i = 0; i < this.groupFunctions.size(); ++i) {
                String func = this.groupFunctions.get(i);
                sql.append(", ").append(func);
                if (!useAliasForColumns) continue;
                sql.append(" as ").append(this.funcAliases[i]);
            }
            sql.append(" FROM (\n");
            sql.append(queryText);
            sql.append("\n) ").append(subqueryAlias);
        } else {
            subqueryAlias = null;
            if (statement instanceof PlainSelect) {
                select = (PlainSelect)statement;
                select.setOrderByElements(null);
                SQLDialect sqlDialect = this.dataSource.getSQLDialect();
                FromItem fromItem = select.getFromItem();
                if (fromItem instanceof Table) {
                    Table table = (Table)fromItem;
                    FormattedTable formattedTable = new FormattedTable(table, sqlDialect);
                    formattedTable.setAlias(table.getAlias());
                    select.setFromItem((FromItem)formattedTable);
                }
                ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
                select.setSelectItems(selectItems);
                for (SQLGroupingAttribute groupAttribute : this.groupAttributes) {
                    selectItems.add(new SelectItem(groupAttribute.prepareExpression()));
                }
                for (int i = 0; i < this.groupFunctions.size(); ++i) {
                    String func = this.groupFunctions.get(i);
                    Expression expression = SQLSemanticProcessor.parseExpression((String)func);
                    SelectItem sei = new SelectItem(expression);
                    if (useAliasForColumns) {
                        sei.setAlias(new Alias(this.funcAliases[i]));
                    }
                    selectItems.add(sei);
                }
            }
            if (statement != null) {
                queryText = statement.toString();
                sql.append(queryText);
            }
        }
        sql.append("\nGROUP BY ");
        for (int i = 0; i < this.groupAttributes.size(); ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(this.groupAttributes.get(i).prepareSqlString(subqueryAlias));
        }
        if (this.showDuplicatesOnly) {
            sql.append("\nHAVING ");
            int foundCountIndex = this.countFunctionIndex();
            if (this.dataSource.getSQLDialect().supportsAliasInHaving() && foundCountIndex >= 0) {
                sql.append(this.funcAliases[foundCountIndex]);
            } else {
                sql.append(DEFAULT_FUNCTION);
            }
            sql.append(" > 1");
        }
        return sql.toString();
    }

    @NotNull
    private String makeGroupFunctionAlias(List<String> groupFunctions, int funcIndex) {
        String function = groupFunctions.get(funcIndex);
        StringBuilder alias = new StringBuilder();
        char delimeter = '_';
        for (int i = 0; i < function.length(); ++i) {
            char c = function.charAt(i);
            if (Character.isLetterOrDigit(c) || c == delimeter) {
                alias.append(c);
                continue;
            }
            if (c != '(' && c != ')') continue;
            alias.append(delimeter);
        }
        while (!alias.isEmpty() && alias.charAt(alias.length() - 1) == delimeter) {
            alias.deleteCharAt(alias.length() - 1);
        }
        if (!alias.isEmpty()) {
            long numberOfSameColumnNames = Arrays.stream(this.funcAliases).filter(Objects::nonNull).filter(a -> a.startsWith(alias.toString().toLowerCase(Locale.ENGLISH))).count();
            if (numberOfSameColumnNames > 0L) {
                alias.append(delimeter).append(numberOfSameColumnNames);
            }
            return alias.toString().toLowerCase(Locale.ENGLISH);
        }
        return "i_" + funcIndex;
    }

    public String[] getFuncAliases() {
        return this.funcAliases;
    }

    private int countFunctionIndex() {
        for (int i = 0; i < this.groupFunctions.size(); ++i) {
            if (!this.groupFunctions.get(i).equalsIgnoreCase(DEFAULT_FUNCTION)) continue;
            return this.funcAliases.length > i ? i : -1;
        }
        return -1;
    }

    private static class FormattedTable
    extends Table {
        private final SQLDialect sqlDialect;

        public FormattedTable(Table table, SQLDialect sqlDialect) {
            super(table.getDatabase(), table.getSchemaName(), table.getName());
            this.sqlDialect = sqlDialect;
        }

        @NotNull
        public String getFullyQualifiedName() {
            String databaseName = !CommonUtils.isEmpty((String)this.getDatabase().getDatabaseName()) ? this.getDatabase().getDatabaseName() + this.sqlDialect.getCatalogSeparator() : "";
            String schemaName = this.getSchemaName() != null ? this.getSchemaName() + this.sqlDialect.getStructSeparator() : "";
            return databaseName + schemaName + this.getName();
        }
    }
}

