/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.data;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBFetchProgress;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryContainer;
import org.jkiss.dbeaver.model.sql.SQLQueryParameter;
import org.jkiss.dbeaver.model.sql.SQLQueryResult;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.parser.SQLParserContext;
import org.jkiss.dbeaver.model.sql.parser.SQLRuleManager;
import org.jkiss.dbeaver.model.sql.parser.SQLScriptParser;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class SQLQueryDataContainer
implements DBSDataContainer,
SQLQueryContainer,
DBPContextProvider,
DBPImageProvider {
    private final DBPContextProvider contextProvider;
    private final SQLScriptContext scriptContext;
    private SQLQuery query;
    private final Log log;

    public SQLQueryDataContainer(DBPContextProvider contextProvider, SQLQuery query, SQLScriptContext scriptContext, Log log) {
        this.contextProvider = contextProvider;
        this.query = query;
        this.scriptContext = scriptContext;
        this.log = log;
    }

    @Nullable
    public DBCExecutionContext getExecutionContext() {
        return this.contextProvider.getExecutionContext();
    }

    @NotNull
    public String[] getSupportedFeatures() {
        return new String[]{"data.select", "data.count", "data.filter"};
    }

    @Override
    public SQLScriptContext getScriptContext() {
        return this.scriptContext;
    }

    @NotNull
    public DBCStatistics readData(@Nullable DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBException {
        DBCStatistics statistics = new DBCStatistics();
        DBPDataSource dataSource = session.getDataSource();
        SQLQuery sqlQuery = this.query;
        String queryText = sqlQuery.getText();
        if (dataFilter != null && dataFilter.hasFilters()) {
            String filteredQueryText;
            try {
                filteredQueryText = dataSource.getSQLDialect().addFiltersToQuery(session.getProgressMonitor(), dataSource, queryText, dataFilter);
            }
            catch (DBException e) {
                throw new DBCException("Unable to apply filters to query", (Throwable)e, session.getExecutionContext());
            }
            sqlQuery = new SQLQuery(dataSource, filteredQueryText, sqlQuery);
        } else {
            sqlQuery = new SQLQuery(dataSource, queryText, sqlQuery);
        }
        if (this.scriptContext != null) {
            SQLSyntaxManager syntaxManager = new SQLSyntaxManager();
            syntaxManager.init(dataSource.getSQLDialect(), dataSource.getContainer().getPreferenceStore());
            SQLRuleManager ruleManager = new SQLRuleManager(syntaxManager);
            ruleManager.loadRules(dataSource, false);
            SQLParserContext parserContext = new SQLParserContext(this.getDataSource(), syntaxManager, ruleManager, (IDocument)new Document(this.query.getText()));
            sqlQuery.setParameters(SQLScriptParser.parseParametersAndVariables(parserContext, 0, sqlQuery.getLength()));
            if (!this.scriptContext.fillQueryParameters(sqlQuery, () -> dataReceiver, CommonUtils.isBitSet((long)flags, (long)256L))) {
                return statistics;
            }
        }
        SQLQueryResult curResult = new SQLQueryResult(sqlQuery);
        if (firstRow > 0L) {
            curResult.setRowOffset(Long.valueOf(firstRow));
        }
        statistics.setQueryText(sqlQuery.getText());
        long startTime = System.currentTimeMillis();
        try (DBCStatement dbcStatement = DBUtils.makeStatement((DBCExecutionSource)source, (DBCSession)session, (DBCStatementType)DBCStatementType.SCRIPT, (SQLQuery)sqlQuery, (long)firstRow, (long)maxRows);){
            DBExecUtils.setStatementFetchSize((DBCStatement)dbcStatement, (long)firstRow, (long)maxRows, (int)fetchSize);
            session.getProgressMonitor().subTask("Execute query");
            boolean hasResultSet = dbcStatement.executeStatement();
            statistics.addExecuteTime(System.currentTimeMillis() - startTime);
            statistics.addStatementsCount();
            curResult.setHasResultSet(hasResultSet);
            if (hasResultSet) {
                DBCResultSet resultSet = dbcStatement.openResultSet();
                if (resultSet != null) {
                    SQLQueryResult.ExecuteResult executeResult = curResult.addExecuteResult(true);
                    DBRProgressMonitor monitor = session.getProgressMonitor();
                    monitor.subTask("Fetch result set");
                    DBFetchProgress fetchProgress = new DBFetchProgress(session.getProgressMonitor());
                    DBDDataReceiver.startFetchWorkflow((DBDDataReceiver)dataReceiver, (DBCSession)session, (DBCResultSet)resultSet, (long)firstRow, (long)maxRows);
                    try (DBCResultSet dBCResultSet = resultSet;){
                        long fetchStartTime = System.currentTimeMillis();
                        while (!fetchProgress.isMaxRowsFetched(maxRows) && !fetchProgress.isCanceled() && resultSet.nextRow()) {
                            dataReceiver.fetchRow(session, resultSet);
                            fetchProgress.monitorRowFetch();
                        }
                        statistics.addFetchTime(System.currentTimeMillis() - fetchStartTime);
                    }
                    if (executeResult != null) {
                        executeResult.setRowCount(Long.valueOf(fetchProgress.getRowCount()));
                    }
                    statistics.setRowsFetched(fetchProgress.getRowCount());
                    monitor.subTask(fetchProgress.getRowCount() + " rows fetched");
                }
            } else {
                this.log.warn((Object)"No results returned by query execution");
            }
            try {
                curResult.addWarnings(dbcStatement.getStatementWarnings());
            }
            catch (Throwable e) {
                this.log.warn((Object)"Can't read execution warnings", e);
            }
        }
        return statistics;
    }

    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) throws DBCException {
        return -1L;
    }

    @Nullable
    public String getDescription() {
        return "SQL Query";
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.getDataSource();
    }

    @NotNull
    public DBPDataSource getDataSource() {
        DBCExecutionContext executionContext = this.getExecutionContext();
        return executionContext == null ? null : executionContext.getDataSource();
    }

    public boolean isPersisted() {
        return false;
    }

    @NotNull
    public String getName() {
        String name = this.query.getOriginalText();
        if (name == null) {
            name = "SQL";
        }
        return name;
    }

    @Nullable
    public DBPDataSourceContainer getDataSourceContainer() {
        DBPDataSource dataSource = this.getDataSource();
        return dataSource == null ? null : dataSource.getContainer();
    }

    public String toString() {
        return this.query.getOriginalText();
    }

    @Override
    public SQLScriptElement getQuery() {
        return this.query;
    }

    public void setQuery(SQLQuery query) {
        this.query = query;
    }

    @Override
    public Map<String, Object> getQueryParameters() {
        if (this.query.getParameters() == null) {
            return this.scriptContext.getAllParameters();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (SQLQueryParameter parameter : this.query.getParameters()) {
            result.put(parameter.getVarName(), parameter.getValue());
        }
        return result;
    }

    @Nullable
    public DBPImage getObjectImage() {
        return DBIcon.TREE_FILE;
    }

    public boolean equals(Object obj) {
        return obj instanceof SQLQueryDataContainer && CommonUtils.equalObjects((Object)this.query, (Object)((SQLQueryDataContainer)obj).query);
    }
}

