/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScope;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.stm.STMUtils;
import org.jkiss.dbeaver.utils.ListNode;

public abstract class SQLQueryNodeModel {
    @NotNull
    private final Interval region;
    @NotNull
    private final STMTreeNode syntaxNode;
    @Nullable
    private List<SQLQueryNodeModel> subnodes;
    @Nullable
    private List<SQLQueryLexicalScope> lexicalScopes = null;
    @Nullable
    private SQLQuerySymbolOrigin tailOrigin = null;

    protected SQLQueryNodeModel(@NotNull Interval region, @NotNull STMTreeNode syntaxNode, SQLQueryNodeModel ... subnodes) {
        this.region = region;
        this.syntaxNode = syntaxNode;
        if (subnodes == null || subnodes.length == 0) {
            this.subnodes = null;
        } else {
            this.subnodes = Stream.of(subnodes).filter(Objects::nonNull).collect(Collectors.toCollection(() -> new ArrayList(subnodes.length)));
            this.subnodes.sort(Comparator.comparingInt(n -> n.region.a));
        }
    }

    @Nullable
    public SQLQuerySymbolClass getAssociatedSymbolClass() {
        return null;
    }

    protected void setTailOrigin(SQLQuerySymbolOrigin tailOrigin) {
        this.tailOrigin = tailOrigin;
    }

    @Nullable
    public SQLQuerySymbolOrigin getTailOrigin() {
        return this.tailOrigin;
    }

    public void registerLexicalScope(@NotNull SQLQueryLexicalScope lexicalScope) {
        List<SQLQueryLexicalScope> scopes = this.lexicalScopes;
        if (scopes == null) {
            this.lexicalScopes = scopes = new ArrayList<SQLQueryLexicalScope>();
        }
        scopes.add(lexicalScope);
    }

    public SQLQueryLexicalScope findLexicalScope(int position) {
        List<SQLQueryLexicalScope> scopes = this.lexicalScopes;
        if (scopes != null) {
            for (SQLQueryLexicalScope s : scopes) {
                Interval region = s.getInterval();
                if (region.a > position || region.b < position) continue;
                return s;
            }
        }
        return null;
    }

    protected void registerSubnode(@NotNull SQLQueryNodeModel subnode) {
        this.subnodes = STMUtils.orderedInsert(this.subnodes, n -> n.region.a, (Object)subnode, Comparator.comparingInt(x -> x));
    }

    @NotNull
    public final Interval getInterval() {
        return this.region;
    }

    @NotNull
    public final STMTreeNode getSyntaxNode() {
        return this.syntaxNode;
    }

    public final <T, R> R apply(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return this.applyImpl(visitor, arg);
    }

    protected abstract <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> var1, T var2);

    protected SQLQueryNodeModel findChildNodeContaining(int position) {
        if (this.subnodes != null) {
            if (this.subnodes.size() == 1) {
                SQLQueryNodeModel node = this.subnodes.get(0);
                return node.region.a <= position ? node : null;
            }
            int index = STMUtils.binarySearchByKey(this.subnodes, n -> n.region.a, (Object)position, Comparator.comparingInt(x -> x));
            if (index >= 0) {
                SQLQueryNodeModel node = this.subnodes.get(index);
                for (int i = index + 1; i < this.subnodes.size(); ++i) {
                    SQLQueryNodeModel next = this.subnodes.get(i++);
                    if (next.region.a > position - 1) break;
                    node = next;
                }
                return node;
            }
            if (~index == 0) {
                return null;
            }
            if (~index == this.subnodes.size()) {
                SQLQueryNodeModel node = this.subnodes.getLast();
                return node.region.a <= position ? node : null;
            }
            for (int i = (index ^ 0xFFFFFFFF) - 1; i >= 0; --i) {
                SQLQueryNodeModel node = this.subnodes.get(i);
                if (node.region.a <= position && node.region.b >= position - 1) {
                    return node;
                }
                if (node.region.b < position) break;
            }
        }
        return null;
    }

    protected static <N extends SQLQueryNodeModel, C> void traverseSubtreeSmart(@NotNull N subroot, @NotNull Class<N> childrenType, @Nullable C context, @NotNull BiConsumer<N, C> action, @NotNull BooleanSupplier cancellationChecker) {
        HashSet<SQLQueryNodeModel> queued = new HashSet<SQLQueryNodeModel>();
        queued.add(subroot);
        ListNode queue = ListNode.of(new NodeEntry(null, subroot));
        while (queue != null && !cancellationChecker.getAsBoolean()) {
            ListNode stack = ListNode.of((Object)((NodeEntry)queue.data));
            queue = queue.next;
            while (stack != null) {
                if (stack.data != null) {
                    NodeEntry entry = (NodeEntry)stack.data;
                    Object node = entry.node;
                    List<SQLQueryNodeModel> subnodes = ((SQLQueryNodeModel)node).subnodes;
                    if (subnodes != null) {
                        List<SQLQueryNodeModel> children;
                        boolean delayChildren;
                        NodeSubtreeTraverseControl localContextProvider;
                        stack = ListNode.push((ListNode)stack, null);
                        if (node instanceof NodeSubtreeTraverseControl) {
                            NodeSubtreeTraverseControl c;
                            localContextProvider = c = (NodeSubtreeTraverseControl)node;
                            delayChildren = c.delayRestChildren();
                            children = c.getChildren();
                            if (children == null) {
                                children = subnodes;
                            }
                        } else {
                            localContextProvider = null;
                            delayChildren = false;
                            children = subnodes;
                        }
                        if (!delayChildren) {
                            children = new ArrayList<SQLQueryNodeModel>(children);
                            Collections.reverse(children);
                        }
                        int index = 0;
                        for (SQLQueryNodeModel childNode : children) {
                            if (childrenType.isInstance(childNode)) {
                                SQLQueryNodeModel child = childNode;
                                NodeExtraContext extraContext = localContextProvider != null && localContextProvider.overridesContextForChild(child) ? new NodeExtraContext(localContextProvider, child) : entry.context;
                                NodeEntry childEntry = new NodeEntry(extraContext, child);
                                if (delayChildren) {
                                    if (index == 0) {
                                        stack = ListNode.push((ListNode)stack, childEntry);
                                    } else if (queued.add(child)) {
                                        queue = ListNode.push((ListNode)queue, childEntry);
                                    }
                                } else {
                                    stack = ListNode.push((ListNode)stack, childEntry);
                                }
                            }
                            ++index;
                        }
                        continue;
                    }
                    SQLQueryNodeModel.applyActionForNode((NodeEntry)stack.data, context, action);
                    stack = stack.next;
                    continue;
                }
                stack = stack.next;
                SQLQueryNodeModel.applyActionForNode((NodeEntry)stack.data, context, action);
                stack = stack.next;
            }
        }
    }

    private static <N extends SQLQueryNodeModel, C> void applyActionForNode(@NotNull NodeEntry<N, C> entry, @Nullable C context, @NotNull BiConsumer<N, C> action) {
        C currContext = entry.context == null ? context : entry.context.provider.getContextForChild(entry.context.key, context);
        action.accept(entry.node, currContext);
    }

    protected static <N extends SQLQueryNodeModel, C> void traverseSubtreeSimple(@NotNull N subroot, @NotNull Class<N> childrenType, @NotNull Consumer<N> action, @NotNull BooleanSupplier cancellationChecker) {
        ListNode stack = ListNode.of(subroot);
        while (stack != null && !cancellationChecker.getAsBoolean()) {
            if (stack.data != null) {
                SQLQueryNodeModel node = (SQLQueryNodeModel)stack.data;
                if (node.subnodes != null) {
                    stack = ListNode.push((ListNode)stack, null);
                    for (SQLQueryNodeModel child : node.subnodes) {
                        if (!childrenType.isInstance(child)) continue;
                        stack = ListNode.push((ListNode)stack, (Object)child);
                    }
                    continue;
                }
                action.accept((SQLQueryNodeModel)stack.data);
                stack = stack.next;
                continue;
            }
            stack = stack.next;
            action.accept((SQLQueryNodeModel)stack.data);
            stack = stack.next;
        }
    }

    private record NodeEntry<N extends SQLQueryNodeModel, C>(@Nullable NodeExtraContext<N, C> context, @NotNull N node) {
    }

    private record NodeExtraContext<N extends SQLQueryNodeModel, C>(@NotNull NodeSubtreeTraverseControl<N, C> provider, @NotNull N key) {
    }

    public static interface NodeSubtreeTraverseControl<N extends SQLQueryNodeModel, C> {
        default public boolean delayRestChildren() {
            return false;
        }

        @Nullable
        default public List<SQLQueryNodeModel> getChildren() {
            return null;
        }

        default public boolean overridesContextForChild(@NotNull N child) {
            return false;
        }

        @Nullable
        default public C getContextForChild(@NotNull N child, @Nullable C defaultContext) {
            return defaultContext;
        }
    }
}

