/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.wizard;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewDescriptor;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskContext;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTTaskFolder;
import org.jkiss.dbeaver.model.task.DBTTaskSettings;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.model.task.DBTaskUtils;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorDescriptor;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorRegistry;
import org.jkiss.dbeaver.registry.task.TaskRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.internal.TaskUIMessages;
import org.jkiss.dbeaver.tasks.ui.registry.TaskUIRegistry;
import org.jkiss.dbeaver.tasks.ui.wizard.EditTaskConfigurationDialog;
import org.jkiss.dbeaver.tasks.ui.wizard.EditTaskVariablesDialog;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWIzardActionConfigurator;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizardDialog;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizardPageSettings;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizardPageTask;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskWizardExecutor;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseWizard;
import org.jkiss.dbeaver.ui.dialogs.IWizardPageActive;
import org.jkiss.dbeaver.ui.dialogs.IWizardPageNavigable;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.utils.CommonUtils;

public abstract class TaskConfigurationWizard<SETTINGS extends DBTTaskSettings>
extends BaseWizard
implements IWorkbenchWizard {
    private static final Log log = Log.getLog(TaskConfigurationWizard.class);
    private static final String TASKS_VIEW_ID = "org.jkiss.dbeaver.tasks";
    private DBTTask currentTask;
    private IStructuredSelection currentSelection;
    private TaskConfigurationWIzardActionConfigurator<SETTINGS> actionsConfigurator;
    private Map<String, Object> variables;
    private boolean promptVariables;
    private DBTTaskContext taskContext;
    @Nullable
    private DBTTaskFolder currentSelectedTaskFolder;

    protected TaskConfigurationWizard() {
    }

    protected TaskConfigurationWizard(@Nullable DBTTask task) {
        this.currentTask = task;
    }

    protected void initializeWizard(Composite parent) {
    }

    protected abstract SETTINGS getSettings();

    protected abstract String getDefaultWindowTitle();

    public boolean isTaskEditor() {
        return this.currentTask != null;
    }

    public abstract String getTaskTypeId();

    public abstract void saveTaskState(DBRRunnableContext var1, DBTTask var2, Map<String, Object> var3) throws DBException;

    public boolean isRunTaskOnFinish() {
        return this.getCurrentTask() != null && !this.getCurrentTask().isTemporary() && !this.getContainer().isSelectorMode();
    }

    protected boolean isToolTask() {
        return this.getCurrentTask() != null && ((Object)this.getCurrentTask().getProperties().getOrDefault("isToolTask", false)).equals(true);
    }

    public IStructuredSelection getCurrentSelection() {
        return this.currentSelection;
    }

    @Nullable
    public DBTTask getCurrentTask() {
        return this.currentTask;
    }

    public void setCurrentTask(DBTTask currentTask) {
        this.currentTask = currentTask;
        this.updateWizardTitle();
        this.getContainer().updateButtons();
    }

    @Nullable
    public DBTTaskFolder getCurrentSelectedTaskFolder() {
        return this.currentSelectedTaskFolder;
    }

    public void setCurrentSelectedTaskFolder(@Nullable DBTTaskFolder taskFolder) {
        this.currentSelectedTaskFolder = taskFolder;
    }

    public DBPProject getProject() {
        return this.currentTask != null ? this.currentTask.getProject() : NavigatorUtils.getSelectedProject();
    }

    public DBTTaskType getTaskType() {
        return TaskRegistry.getInstance().getTaskType(this.getTaskTypeId());
    }

    protected void updateWizardTitle() {
        Object wizTitle = this.getDefaultWindowTitle();
        if (this.isTaskEditor()) {
            TaskConfigurationWizardPageTask taskPage = this.getContainer() == null ? null : this.getContainer().getTaskPage();
            wizTitle = (String)wizTitle + " - [" + (taskPage == null ? this.currentTask.getName() : taskPage.getTaskName()) + "]";
        }
        this.setWindowTitle((String)wizTitle);
    }

    public TaskConfigurationWizardDialog getContainer() {
        return (TaskConfigurationWizardDialog)super.getContainer();
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.updateWizardTitle();
        this.setNeedsProgressMonitor(true);
        this.currentSelection = currentSelection;
        this.getContainer().addPageChangedListener(event -> this.updateWizardTitle());
    }

    public void addPages() {
        super.addPages();
        this.addTaskConfigPages();
    }

    protected boolean isTaskConfigPage(IWizardPage page) {
        return page instanceof TaskConfigurationWizardPageTask || page instanceof TaskConfigurationWizardPageSettings;
    }

    protected void addTaskConfigPages() {
        if (this.isTaskEditor() && !this.currentTask.isTemporary()) {
            this.addPage((IWizardPage)new TaskConfigurationWizardPageTask(this.getCurrentTask()));
            this.addPage((IWizardPage)new TaskConfigurationWizardPageSettings(this.getCurrentTask()));
        }
    }

    public boolean isNewTaskEditor() {
        return this.currentTask != null && this.getProject().getTaskManager().getTaskById(this.currentTask.getId()) == null;
    }

    public boolean isCurrentTaskSaved() {
        return this.getCurrentTask() != null && this.getCurrentTask().getProject().getTaskManager().getTaskById(this.getCurrentTask().getId()) != null;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        if (nextPage instanceof TaskConfigurationWizardPageSettings && page instanceof TaskConfigurationWizardPageTask && !TaskUIRegistry.getInstance().supportsConfiguratorPage(this.getContainer().getTaskPage().getSelectedTaskType())) {
            return this.getNextPage(nextPage);
        }
        return nextPage;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage prevPage = super.getPreviousPage(page);
        if (prevPage instanceof TaskConfigurationWizardPageSettings && !TaskUIRegistry.getInstance().supportsConfiguratorPage(this.getContainer().getTaskPage().getSelectedTaskType())) {
            return this.getPreviousPage(prevPage);
        }
        return prevPage;
    }

    public boolean canFinish() {
        if (this.isCurrentTaskSaved()) {
            return true;
        }
        for (IWizardPage page : this.getPages()) {
            if (!this.isPageNeedsCompletion(page) || !this.isPageValid(page) || page.isPageComplete()) continue;
            return false;
        }
        TaskConfigurationWizardPageTask taskPage = this.getContainer().getTaskPage();
        return taskPage == null || taskPage.isPageComplete();
    }

    protected boolean isPageNeedsCompletion(IWizardPage page) {
        IWizardPageNavigable pageNavigable;
        if (page instanceof TaskConfigurationWizardPageTask) {
            return false;
        }
        return !(page instanceof IWizardPageNavigable) || (pageNavigable = (IWizardPageNavigable)page).isPageApplicable();
    }

    public boolean performFinish() {
        if (this.currentTask != null && !this.currentTask.isTemporary() && !this.saveTask()) {
            return false;
        }
        if (this.isRunTaskOnFinish()) {
            return this.runTask();
        }
        return true;
    }

    protected boolean runTask() {
        try {
            DBTTask task = this.getCurrentTask();
            if (task == null) {
                task = this.getProject().getTaskManager().createTemporaryTask(this.getTaskType(), this.getWindowTitle());
                this.saveConfigurationToTask(task);
            }
            TaskWizardExecutor executor = new TaskWizardExecutor(this.getRunnableContext(), task, log, System.out);
            if (this.getCurrentTask() == null) {
                executor.executeTask();
            } else {
                task.getProject().getTaskManager().scheduleTask(task, (DBTTaskExecutionListener)executor);
            }
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Task run error", e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    protected boolean isPageValid(IWizardPage page) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean saveTask() {
        DBTTask currentTask;
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage instanceof IWizardPageActive) {
            ((IWizardPageActive)currentPage).deactivatePage();
            ((IWizardPageActive)currentPage).activatePage();
        }
        if ((currentTask = this.getCurrentTask()) == null || currentTask.isTemporary()) {
            DBTTaskType taskType = this.getTaskType();
            if (taskType == null) {
                DBWorkbench.getPlatformUI().showError("No task type", "Can't find task type " + this.getTaskTypeId());
                return false;
            }
            EditTaskConfigurationDialog dialog = new EditTaskConfigurationDialog(this.getContainer().getShell(), this.getProject(), taskType, currentTask != null ? currentTask.getMaxExecutionTime() : Duration.ZERO);
            if (dialog.open() != 0) return false;
            currentTask = dialog.getTask();
            this.setCurrentTask(currentTask);
        } else {
            TaskConfigurationWizardPageTask taskPage = this.getContainer().getTaskPage();
            if (taskPage != null) {
                taskPage.saveSettings();
            }
        }
        DBTTask theTask = currentTask;
        return this.saveConfigurationToTask(theTask);
    }

    protected boolean saveConfigurationToTask(DBTTask theTask) {
        try {
            LinkedHashMap<String, Object> state = new LinkedHashMap<String, Object>();
            this.saveTaskState(this.getRunnableContext(), theTask, state);
            DBTTaskContext context = this.getTaskContext();
            if (context != null) {
                DBTaskUtils.saveTaskContext(state, (DBTTaskContext)context);
            }
            if (theTask.getType().supportsVariables()) {
                DBTaskUtils.setVariables(state, this.getTaskVariables());
                if (this.promptVariables) {
                    state.put("promptTaskVariables", true);
                }
            }
            theTask.setProperties(state);
            theTask.getProject().getTaskManager().updateTaskConfiguration(theTask);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Task save error", "Error saving task configuration", (Throwable)e);
            return false;
        }
        return true;
    }

    public void createTaskActions(Composite parent, int hSpan) {
        if (!DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("database-developer")) {
            return;
        }
        IViewDescriptor tasksViewDescriptor = PlatformUI.getWorkbench().getViewRegistry().find(TASKS_VIEW_ID);
        if (tasksViewDescriptor == null || this.getContainer().isSelectorMode()) {
            UIUtils.createEmptyLabel((Composite)parent, (int)hSpan, (int)1);
        } else {
            Composite panel = new Composite(parent, 0);
            panel.setBackground(parent.getBackground());
            if (parent.getLayout() instanceof GridLayout) {
                GridData gd = new GridData(768);
                gd.horizontalSpan = hSpan;
                panel.setLayoutData((Object)gd);
            }
            boolean supportsVariables = false;
            GridLayout layout = new GridLayout(1, false);
            panel.setLayout((Layout)layout);
            if (supportsVariables) {
                ++layout.numColumns;
                UIUtils.createPushButton((Composite)panel, null, null, (DBPImage)UIIcon.SQL_VARIABLE, (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TaskConfigurationWizard.this.configureVariables();
                    }
                });
            }
            ++layout.numColumns;
            Button taskViewButton = UIUtils.createPushButton((Composite)panel, null, (String)TaskUIMessages.task_config_wizard_link_open_tasks_view, null, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> {
                try {
                    UIUtils.getActiveWorkbenchWindow().getActivePage().showView(tasksViewDescriptor.getId());
                }
                catch (PartInitException e1) {
                    DBWorkbench.getPlatformUI().showError("Show view", "Error opening database tasks view", (Throwable)e1);
                }
            }));
            Image viewImage = tasksViewDescriptor.getImageDescriptor().createImage();
            taskViewButton.setImage(viewImage);
            taskViewButton.addDisposeListener(e -> viewImage.dispose());
            taskViewButton.setLayoutData((Object)new GridData(128));
            if (this.actionsConfigurator == null) {
                IObjectPropertyConfigurator configurator = null;
                UIPropertyConfiguratorDescriptor descriptor = UIPropertyConfiguratorRegistry.getInstance().getDescriptor(TaskConfigurationWIzardActionConfigurator.class.getName());
                if (descriptor != null) {
                    try {
                        configurator = descriptor.createConfigurator();
                    }
                    catch (DBException e2) {
                        log.debug((Object)"Error creating actions configurator", (Throwable)e2);
                    }
                }
                if (configurator instanceof TaskConfigurationWIzardActionConfigurator) {
                    TaskConfigurationWIzardActionConfigurator configurator1;
                    TaskConfigurationWIzardActionConfigurator actionsConfigurator;
                    this.actionsConfigurator = actionsConfigurator = (configurator1 = (TaskConfigurationWIzardActionConfigurator)configurator);
                }
            }
            if (this.actionsConfigurator != null) {
                this.actionsConfigurator.createControl(panel, (Object)this, this::updateTaskButtons);
            }
        }
    }

    public void createVariablesEditButton(Composite parent) {
        Composite group = UIUtils.createTitledComposite((Composite)parent, (String)TaskUIMessages.task_config_wizard_button_variables, (int)1, (int)34);
        UIUtils.createDialogButton((Composite)group, (String)TaskUIMessages.task_config_wizard_button_variables_configure, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> this.configureVariables()));
        final Button promptTaskVariablesCheckbox = UIUtils.createCheckbox((Composite)group, (String)TaskUIMessages.task_config_wizard_button_variables_prompt, (String)TaskUIMessages.task_config_wizard_button_variables_prompt_tip, (this.currentTask != null && CommonUtils.toBoolean(this.currentTask.getProperties().get("promptTaskVariables")) ? 1 : 0) != 0, (int)1);
        promptTaskVariablesCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskConfigurationWizard.this.promptVariables = promptTaskVariablesCheckbox.getSelection();
            }
        });
        promptTaskVariablesCheckbox.notifyListeners(13, new Event());
    }

    private void configureVariables() {
        Map<String, Object> variables = this.getTaskVariables();
        EditTaskVariablesDialog dialog = new EditTaskVariablesDialog(this.getContainer().getShell(), Map.of(this.currentTask, variables));
        if (dialog.open() == 0) {
            this.variables = dialog.getVariables(this.currentTask);
        }
    }

    protected Map<String, Object> getTaskVariables() {
        if (this.variables == null) {
            this.variables = this.currentTask != null ? DBTaskUtils.getVariables((DBTTask)this.currentTask) : new LinkedHashMap<String, Object>();
        }
        return this.variables;
    }

    public DBTTaskContext getTaskContext() {
        if (this.taskContext == null && this.currentTask != null) {
            this.taskContext = DBTaskUtils.loadTaskContext((Map)this.currentTask.getProperties());
        }
        return this.taskContext;
    }

    protected void saveTaskContext(DBCExecutionContext executionContext) {
        this.taskContext = DBTaskUtils.extractContext((DBCExecutionContext)executionContext);
    }

    void enableTaskButtons(boolean enable) {
        if (this.actionsConfigurator != null) {
            this.actionsConfigurator.enableActions(enable);
        }
        if (enable) {
            this.updateTaskButtons();
        }
    }

    public void updateTaskButtons() {
        if (this.actionsConfigurator != null) {
            this.actionsConfigurator.updateActions();
        }
    }

    public IWizardPage getStartingPage() {
        IWizardPage startingPage = super.getStartingPage();
        if (this.getContainer().isEditMode()) {
            return this.getNextPage(startingPage);
        }
        return startingPage;
    }

    public void onWizardActivation() {
    }

    @NotNull
    public TaskConfigurationWizardDialog createWizardDialog(@NotNull IWorkbenchWindow window, @NotNull IStructuredSelection selection, @NotNull Map<String, Object> options) {
        return new TaskConfigurationWizardDialog(window, this, selection, options);
    }
}

