/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.AIAssistant;
import org.jkiss.dbeaver.model.ai.AIAssistantResponse;
import org.jkiss.dbeaver.model.ai.AIFunctionContext;
import org.jkiss.dbeaver.model.ai.AIFunctionResult;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.AIMessageMeta;
import org.jkiss.dbeaver.model.ai.AIMessageType;
import org.jkiss.dbeaver.model.ai.AIPromptGenerator;
import org.jkiss.dbeaver.model.ai.AISqlFormatter;
import org.jkiss.dbeaver.model.ai.AIUsage;
import org.jkiss.dbeaver.model.ai.engine.AIDatabaseContext;
import org.jkiss.dbeaver.model.ai.engine.AIEngine;
import org.jkiss.dbeaver.model.ai.engine.AIEngineProperties;
import org.jkiss.dbeaver.model.ai.engine.AIEngineRequest;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponse;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponseConsumer;
import org.jkiss.dbeaver.model.ai.engine.AIFunctionCall;
import org.jkiss.dbeaver.model.ai.engine.TooManyRequestsException;
import org.jkiss.dbeaver.model.ai.impl.AIDatabaseSnapshotService;
import org.jkiss.dbeaver.model.ai.impl.AIEngineRequestFactory;
import org.jkiss.dbeaver.model.ai.impl.AIPromptUtils;
import org.jkiss.dbeaver.model.ai.impl.DummyTokenCounter;
import org.jkiss.dbeaver.model.ai.impl.SimpleSqlFormatterImpl;
import org.jkiss.dbeaver.model.ai.internal.AIMessages;
import org.jkiss.dbeaver.model.ai.registry.AIAssistantRegistry;
import org.jkiss.dbeaver.model.ai.registry.AIEngineDescriptor;
import org.jkiss.dbeaver.model.ai.registry.AIEngineRegistry;
import org.jkiss.dbeaver.model.ai.registry.AIFunctionDescriptor;
import org.jkiss.dbeaver.model.ai.registry.AIFunctionRegistry;
import org.jkiss.dbeaver.model.ai.registry.AISettingsManager;
import org.jkiss.dbeaver.model.ai.utils.ThrowableSupplier;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.exec.DBCMessageException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class AIAssistantImpl
implements AIAssistant {
    private static final Log log = Log.getLog(AIAssistantImpl.class);
    private static final int MANY_REQUESTS_RETRIES = 3;
    private static final int MANY_REQUESTS_TIMEOUT = 500;
    public static final String LOG_INDENT = "\t";
    protected static final int MAX_FUNCTION_CALLS = 5;
    protected final DBPWorkspace workspace;
    protected final AIEngineRequestFactory requestFactory;
    protected AISqlFormatter sqlFormatter;

    public AIAssistantImpl(@NotNull DBPWorkspace workspace) {
        this.workspace = workspace;
        this.requestFactory = this.createRequestFactory();
        this.sqlFormatter = this.createSqlFormatter();
    }

    protected AISqlFormatter createSqlFormatter() {
        try {
            return AIAssistantRegistry.getInstance().getDescriptor().createSqlFormatter();
        }
        catch (DBException e) {
            log.error((Object)"Error creating SQL formatter", (Throwable)e);
            return new SimpleSqlFormatterImpl();
        }
    }

    protected AIEngineRequestFactory createRequestFactory() {
        return new AIEngineRequestFactory(new AIDatabaseSnapshotService(), new DummyTokenCounter());
    }

    @Override
    @NotNull
    public AIAssistantResponse generateText(@NotNull DBRProgressMonitor monitor, @Nullable AIDatabaseContext context, @NotNull AIPromptGenerator systemGenerator, @NotNull List<AIMessage> messages) throws DBException {
        this.checkAiEnablement();
        AIEngineDescriptor engineDescriptor = this.getEngineDescriptor();
        try (AIEngine engine = engineDescriptor.createEngineInstance();){
            AIEngineRequest completionRequest = this.buildAiEngineRequest(monitor, context, systemGenerator, messages, engine, engineDescriptor);
            AIFunctionContext functionContext = AIAssistantImpl.createAiFunctionContext(monitor, context, systemGenerator, messages);
            AIEngineRequest request = completionRequest;
            for (int tryIndex = 0; tryIndex < 5; ++tryIndex) {
                String stringValue;
                block14: {
                    AIMessageMeta requestMeta;
                    block13: {
                        AIEngineResponse completionResponse;
                        block12: {
                            Instant now = Instant.now();
                            completionResponse = this.requestCompletion(engine, monitor, request);
                            int systemPromptLength = AIPromptUtils.calcSystemPromptLength(completionRequest.getMessages());
                            AIUsage usage = completionResponse.getUsage() != null ? completionResponse.getUsage() : new AIUsage(0, 0, 0, 0);
                            requestMeta = new AIMessageMeta("prompt", engineDescriptor.getId(), engine.getProperties().getModel(), usage, Duration.between(now, Instant.now()), systemPromptLength);
                            if (completionResponse.getType() != AIMessageType.FUNCTION) break block12;
                            AIFunctionCall functionCall = completionResponse.getFunctionCall();
                            if (functionCall == null) break block13;
                            functionContext.addFunctionCall(functionCall);
                            AIFunctionResult result = this.callFunction(functionContext, functionCall);
                            stringValue = CommonUtils.toString(result.getValue());
                            if (result.getType() == AIFunctionResult.FunctionType.ACTION) {
                                AIAssistantResponse aIAssistantResponse = new AIAssistantResponse(AIAssistantResponse.Type.FUNCTION, stringValue, List.of(requestMeta));
                                return aIAssistantResponse;
                            }
                            break block14;
                        }
                        List<String> variants = completionResponse.getVariants();
                        if (variants != null && !variants.isEmpty()) {
                            AIAssistantResponse aIAssistantResponse = new AIAssistantResponse(AIAssistantResponse.Type.TEXT, variants.getFirst(), List.of(requestMeta));
                            return aIAssistantResponse;
                        }
                    }
                    AIAssistantResponse aIAssistantResponse = new AIAssistantResponse(AIAssistantResponse.Type.ERROR, AIMessages.ai_empty_engine_response, List.of(requestMeta));
                    return aIAssistantResponse;
                }
                ArrayList<AIMessage> newMessages = new ArrayList<AIMessage>(request.getMessages());
                newMessages.add(new AIMessage(AIMessageType.USER, stringValue, null));
                AIEngineRequest newRequest = new AIEngineRequest(newMessages);
                newRequest.setFunctions(request.getFunctions());
                request = newRequest;
            }
            throw new DBException("Too many AI function calls (5)");
        }
    }

    @NotNull
    public AIEngineRequest buildAiEngineRequest(@NotNull DBRProgressMonitor monitor, @Nullable AIDatabaseContext context, @NotNull AIPromptGenerator systemGenerator, @NotNull List<AIMessage> messages, @NotNull AIEngine<?> engine, @NotNull AIEngineDescriptor engineDescriptor) throws DBException {
        return this.requestFactory.build(monitor, engine, engineDescriptor, systemGenerator, context, messages);
    }

    @NotNull
    private static AIFunctionContext createAiFunctionContext(@NotNull DBRProgressMonitor monitor, @Nullable AIDatabaseContext context, @NotNull AIPromptGenerator systemGenerator, @NotNull List<AIMessage> messages) {
        return new AIFunctionContext(monitor, context, systemGenerator, messages);
    }

    @NotNull
    protected AIFunctionResult callFunction(@NotNull AIFunctionContext context, @NotNull AIFunctionCall functionCall) throws DBException {
        AIFunctionRegistry registry = AIFunctionRegistry.getInstance();
        String functionName = functionCall.getFunctionName();
        if (CommonUtils.isEmpty((String)functionName)) {
            throw new DBCMessageException("Function name not specified");
        }
        AIFunctionDescriptor function = registry.getFunction(functionName);
        if (function == null) {
            throw new DBCMessageException("Function '" + functionName + "' not found");
        }
        functionCall.setFunction(function);
        log.debug((Object)("Call AI function '" + function.getId() + "'"));
        Map<String, Object> arguments = functionCall.getArguments();
        if (arguments == null) {
            arguments = Map.of();
        }
        return registry.callFunction(context, function, arguments);
    }

    protected void checkAiEnablement() throws DBException {
        if (AISettingsManager.getInstance().getSettings().isAiDisabled()) {
            throw new DBException("AI integration is disabled");
        }
    }

    public static String getActiveEngineId() {
        return AISettingsManager.getInstance().getSettings().activeEngine();
    }

    public boolean isEngineSupports(Class<?> api) {
        return AIEngineRegistry.getInstance().isEngineSupports(AIAssistantImpl.getActiveEngineId(), api);
    }

    @NotNull
    public AIEngine<?> createEngine() throws DBException {
        return AIEngineRegistry.getInstance().createEngine(AIAssistantImpl.getActiveEngineId());
    }

    @NotNull
    public AIEngineDescriptor getEngineDescriptor() throws DBException {
        AIEngineDescriptor descriptor = AIEngineRegistry.getInstance().getEngineDescriptor(AIAssistantImpl.getActiveEngineId());
        if (descriptor == null) {
            log.trace((Object)"Active engine is not present in the configuration, switching to default active engine");
            AIEngineDescriptor defaultCompletionEngineDescriptor = AIEngineRegistry.getInstance().getDefaultCompletionEngineDescriptor();
            if (defaultCompletionEngineDescriptor == null) {
                throw new DBException("AI engine  not found");
            }
            descriptor = defaultCompletionEngineDescriptor;
        }
        return descriptor;
    }

    @NotNull
    protected AIEngineResponse requestCompletion(@NotNull AIEngine<?> engine, @NotNull DBRProgressMonitor monitor, @NotNull AIEngineRequest request) throws DBException {
        try {
            boolean loggingEnabled = this.isLoggingEnabled();
            if (loggingEnabled) {
                log.debug((Object)("AI request:\n" + CommonUtils.addTextIndent((String)request.getMessages().toString(), (String)LOG_INDENT)));
            }
            AIEngineResponse completionResponse = AIAssistantImpl.callWithRetry(() -> engine.requestCompletion(monitor, request));
            if (loggingEnabled) {
                log.debug((Object)("AI response:\n" + CommonUtils.addTextIndent((String)completionResponse.toString(), (String)LOG_INDENT)));
            }
            return completionResponse;
        }
        catch (Exception e) {
            if (e instanceof DBException) {
                DBException dbe = (DBException)((Object)e);
                throw dbe;
            }
            throw new DBException("Error requesting completion", (Throwable)e);
        }
    }

    protected boolean isLoggingEnabled() {
        try {
            AIEngineProperties activeEngineConfiguration = this.getActiveEngineConfiguration();
            if (activeEngineConfiguration == null) {
                log.warn((Object)"No active AI engine configuration found");
                return false;
            }
            return activeEngineConfiguration.isLoggingEnabled();
        }
        catch (DBException e) {
            log.debug((Object)("Error getting AI configuration: " + e.getMessage()));
            return false;
        }
    }

    @Nullable
    private AIEngineProperties getActiveEngineConfiguration() throws DBException {
        AISettingsManager settingsManager = AISettingsManager.getInstance();
        String activeEngine = settingsManager.getSettings().activeEngine();
        if (activeEngine == null || activeEngine.isEmpty()) {
            log.warn((Object)"No active AI engine configured");
            return null;
        }
        return settingsManager.getSettings().getEngineConfiguration(activeEngine);
    }

    protected static <T> T callWithRetry(ThrowableSupplier<T, DBException> supplier) throws DBException {
        return AIAssistantImpl.callWithRetry(null, supplier);
    }

    protected static <T> T callWithRetry(@Nullable AIEngineResponseConsumer listener, @NotNull ThrowableSupplier<T, DBException> supplier) throws DBException {
        int retry = 0;
        while (retry < 3) {
            try {
                return supplier.get();
            }
            catch (TooManyRequestsException e) {
                if (++retry >= 3) continue;
                log.debug((Object)"Too many engine requests. Retry after 500ms");
                RuntimeUtils.pause((int)500);
            }
        }
        DBException dbException = new DBException("Request failed after 3 attempts");
        if (listener != null) {
            listener.error(dbException);
        }
        throw new DBException("Request failed after 3 attempts");
    }
}

