/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerSerializable;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLPlanViewProvider;
import org.jkiss.dbeaver.utils.GeneralUtils;

public abstract class SQLPlanSaveProvider
implements SQLPlanViewProvider {
    public static final String[] EXT = new String[]{"*.dbplan", "*"};
    private static final String[] NAMES = new String[]{"DBeaver Plan File", "All files"};
    private Viewer viewer;
    private SQLQuery query;
    private DBCPlan plan;
    private SaveAction saveAction = new SaveAction("Save plan", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SAVE_AS), this);
    private DBCQueryPlanner planner;

    protected abstract void showPlan(Viewer var1, SQLQuery var2, DBCPlan var3);

    protected void doSave() {
        if (this.query != null) {
            if (this.planner instanceof DBCQueryPlannerSerializable) {
                File filePath = DialogUtils.selectFileForSave((Shell)this.viewer.getControl().getShell(), (String)"Save execution plan as", (String[])EXT, (String[])NAMES, null);
                if (filePath == null) {
                    return;
                }
                try (FileWriter w = new FileWriter(filePath);){
                    ((DBCQueryPlannerSerializable)this.planner).serialize((Writer)w, this.plan);
                }
                catch (IOException | InvocationTargetException e) {
                    DBWorkbench.getPlatformUI().showError("Load plan", "Error loading plan", (Throwable)e);
                }
            } else {
                this.saveAction.setEnabled(false);
            }
        }
    }

    protected void fillPlan(SQLQuery query, DBCPlan plan) {
        this.query = query;
        this.plan = plan;
        this.planner = (DBCQueryPlanner)GeneralUtils.adapt((Object)query.getDataSource(), DBCQueryPlanner.class);
    }

    @Override
    public void contributeActions(Viewer viewer, IContributionManager contributionManager, SQLQuery lastQuery, DBCPlan lastPlan) {
        this.viewer = viewer;
        if (this.saveAction.isEnabled()) {
            contributionManager.add((IAction)this.saveAction);
            contributionManager.add((IContributionItem)new Separator());
        }
    }

    class SaveAction
    extends Action {
        SQLPlanSaveProvider provider;

        public SaveAction(String text, ImageDescriptor image, SQLPlanSaveProvider provider) {
            super(text, image);
            this.provider = provider;
        }

        public boolean isEnabled() {
            return SQLPlanSaveProvider.this.planner instanceof DBCQueryPlannerSerializable;
        }

        public void run() {
            this.provider.doSave();
        }
    }
}

