/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.jobs.DataSourceJob;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.dialogs.GenerateSQLDialog;
import org.jkiss.dbeaver.ui.editors.sql.dialogs.SQLScriptProgressListener;

public abstract class GenerateMultiSQLDialog<T extends DBSObject>
extends GenerateSQLDialog {
    private static final Log log = Log.getLog(GenerateMultiSQLDialog.class);
    private static final String DIALOG_ID = "GenerateMultiSQLDialog";
    private final Collection<T> selectedObjects;
    private Table objectsTable;

    public GenerateMultiSQLDialog(IWorkbenchPartSite partSite, String title, Collection<T> objects, boolean meta) {
        this(partSite, GenerateMultiSQLDialog.getContextFromObjects(objects, meta), title, objects);
    }

    private GenerateMultiSQLDialog(IWorkbenchPartSite partSite, DBCExecutionContext context, String title, Collection<T> objects) {
        super(partSite, context, title, null);
        this.selectedObjects = objects;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String dialogClassName = ((Object)((Object)this)).getClass().getName();
        int divPos = dialogClassName.lastIndexOf(46);
        dialogClassName = divPos == -1 ? dialogClassName : dialogClassName.substring(divPos + 1);
        return UIUtils.getDialogSettings((String)("GenerateMultiSQLDialog." + dialogClassName));
    }

    protected abstract SQLScriptProgressListener<T> getScriptListener();

    @Override
    protected String[] generateSQLScript() {
        List<T> checkedObjects = this.getCheckedObjects();
        ArrayList<String> lines = new ArrayList<String>();
        for (DBSObject object : checkedObjects) {
            this.generateObjectCommand(lines, object);
        }
        return lines.toArray(new String[0]);
    }

    public List<T> getCheckedObjects() {
        ArrayList<Object> checkedObjects = new ArrayList<Object>();
        if (this.objectsTable != null) {
            for (TableItem item : this.objectsTable.getItems()) {
                if (!item.getChecked()) continue;
                checkedObjects.add((DBSObject)item.getData());
            }
        } else {
            checkedObjects.addAll(this.selectedObjects);
        }
        return checkedObjects;
    }

    protected void createObjectsSelector(Composite parent) {
        if (this.selectedObjects.size() < 2) {
            return;
        }
        UIUtils.createControlLabel((Composite)parent, (String)"Tables");
        this.objectsTable = new Table(parent, 2080);
        GridData gd = new GridData(768);
        gd.heightHint = 100;
        this.objectsTable.setLayoutData((Object)gd);
        for (DBSObject table : this.selectedObjects) {
            TableItem item = new TableItem(this.objectsTable, 0);
            item.setText(DBUtils.getObjectFullName((DBPNamedObject)table, (DBPEvaluationContext)DBPEvaluationContext.UI));
            item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_TABLE));
            item.setChecked(true);
            item.setData((Object)table);
        }
        this.objectsTable.addSelectionListener(this.SQL_CHANGE_LISTENER);
        this.objectsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean hasChecked = !GenerateMultiSQLDialog.this.getCheckedObjects().isEmpty();
                GenerateMultiSQLDialog.this.getButton(0).setEnabled(hasChecked);
                GenerateMultiSQLDialog.this.getButton(13).setEnabled(hasChecked);
            }
        });
    }

    @Override
    protected void executeSQL() {
        final String jobName = this.getShell().getText();
        final SQLScriptProgressListener<T> scriptListener = this.getScriptListener();
        final List<T> objects = this.getCheckedObjects();
        final LinkedHashMap<DBSObject, ArrayList<String>> objectsSQL = new LinkedHashMap<DBSObject, ArrayList<String>>();
        for (DBSObject object : objects) {
            ArrayList<String> lines = new ArrayList<String>();
            this.generateObjectCommand(lines, object);
            objectsSQL.put(object, lines);
        }
        DataSourceJob job = new DataSourceJob(jobName, this.getExecutionContext()){
            Exception objectProcessingError;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            protected IStatus run(@NotNull DBRProgressMonitor monitor) {
                2 curJob = this;
                UIUtils.asyncExec(() -> scriptListener.beginScriptProcessing((Job)curJob, objects));
                monitor.beginTask(jobName, objects.size());
                try (DBCSession session = this.getExecutionContext().openSession(monitor, DBCExecutionPurpose.UTIL, jobName);){
                    if (GenerateMultiSQLDialog.this.isRunInSeparateTransaction()) {
                        GenerateMultiSQLDialog.this.commitChanges(session);
                    }
                    for (int i = 0; i < objects.size() && !monitor.isCanceled(); ++i) {
                        int objectNumber = i;
                        DBSObject object = (DBSObject)objects.get(i);
                        monitor.subTask("Process " + DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.UI));
                        this.objectProcessingError = null;
                        UIUtils.asyncExec(() -> scriptListener.beginObjectProcessing(object, objectNumber));
                        try {
                            List lines = (List)objectsSQL.get(object);
                            for (String line : lines) {
                                DBCStatement statement = DBUtils.makeStatement((DBCSession)session, (String)line, (boolean)false);
                                try {
                                    if (statement.executeStatement()) {
                                        try (DBCResultSet resultSet = statement.openResultSet();){
                                            UIUtils.syncExec(() -> {
                                                try {
                                                    scriptListener.processObjectResults(object, statement, resultSet);
                                                }
                                                catch (DBCException e) {
                                                    this.objectProcessingError = e;
                                                }
                                            });
                                        }
                                        if (this.objectProcessingError == null) continue;
                                        break;
                                    }
                                    UIUtils.syncExec(() -> {
                                        try {
                                            scriptListener.processObjectResults(object, statement, null);
                                        }
                                        catch (DBCException e) {
                                            this.objectProcessingError = e;
                                        }
                                    });
                                }
                                finally {
                                    if (statement == null) continue;
                                    statement.close();
                                }
                            }
                        }
                        catch (Exception e) {
                            this.objectProcessingError = e;
                        }
                        finally {
                            UIUtils.asyncExec(() -> scriptListener.endObjectProcessing(object, this.objectProcessingError));
                        }
                        monitor.worked(1);
                    }
                    if (GenerateMultiSQLDialog.this.isRunInSeparateTransaction()) {
                        GenerateMultiSQLDialog.this.commitChanges(session);
                    }
                }
                finally {
                    monitor.done();
                    UIUtils.asyncExec(scriptListener::endScriptProcessing);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (GenerateMultiSQLDialog.this.needsRefreshOnFinish()) {
                    ArrayList objectToRefresh = new ArrayList(GenerateMultiSQLDialog.this.selectedObjects);
                    UIUtils.asyncExec(() -> {
                        try {
                            UIUtils.runInProgressDialog(monitor -> {
                                monitor.beginTask("Refresh objects", objectToRefresh.size());
                                for (DBSObject object : objectToRefresh) {
                                    try {
                                        DBNDatabaseNode objectNode = DBNUtils.getNodeByObject((DBSObject)object);
                                        if (objectNode == null) continue;
                                        objectNode.refreshNode(monitor, DBNEvent.FORCE_REFRESH);
                                    }
                                    catch (Exception e) {
                                        log.error((Object)("Error refreshing object '" + object.getName() + "'"), (Throwable)e);
                                    }
                                }
                                monitor.done();
                            });
                        }
                        catch (InvocationTargetException e) {
                            DBWorkbench.getPlatformUI().showError("Objects refresh", "Error refreshing navigator objects", (Throwable)e);
                        }
                    });
                }
            }
        });
        job.schedule();
    }

    protected boolean isRunInSeparateTransaction() {
        return false;
    }

    protected boolean needsRefreshOnFinish() {
        return false;
    }

    protected abstract void generateObjectCommand(List<String> var1, T var2);

    private static <T extends DBSObject> DBCExecutionContext getContextFromObjects(@NotNull Collection<T> objects, boolean meta) {
        DBSObject object;
        Iterator<T> iterator = objects.iterator();
        if (iterator.hasNext() && (object = (DBSObject)iterator.next()) != null) {
            return DBUtils.getDefaultContext((DBSObject)object, (boolean)meta);
        }
        return null;
    }

    private void commitChanges(DBCSession session) {
        try {
            DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)session.getExecutionContext());
            if (txnManager != null && txnManager.isSupportsTransactions() && !txnManager.isAutoCommit()) {
                txnManager.commit(session);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error committing transactions", e);
        }
    }
}

