/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions;

import java.util.Objects;
import org.eclipse.core.expressions.PropertyTester;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.struct.DBStructUtils;

public class DataSourceContainerPropertyTester
extends PropertyTester {
    protected static final Log log = Log.getLog(DataSourceContainerPropertyTester.class);
    public static final String PROP_DRIVER_ID = "driverId";
    public static final String PROP_DRIVER_CLASS = "driverClass";
    public static final String PROP_CONNECTED = "connected";
    public static final String PROP_CONNECTING = "connecting";
    public static final String PROP_SUPPORTS_SCHEMAS = "supportsSchemas";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!(receiver instanceof DBPDataSourceContainer)) {
            return false;
        }
        DBPDataSourceContainer container = (DBPDataSourceContainer)receiver;
        return switch (property) {
            case PROP_DRIVER_ID -> container.getDriver().getId().equals(expectedValue);
            case PROP_DRIVER_CLASS -> Objects.equals(container.getDriver().getDriverClassName(), expectedValue);
            case PROP_CONNECTED -> container.isConnected();
            case PROP_CONNECTING -> container.isConnecting();
            case PROP_SUPPORTS_SCHEMAS -> DBStructUtils.isSchemasSupported((DBPDataSourceContainer)container);
            default -> false;
        };
    }
}

