/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablespace;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreCreateTablespaceDialog
extends BaseDialog {
    private static final String DIALOG_ID = "DBeaver.PostgreCreateTablespaceDialog";
    private final PostgreTablespace newTablespace;
    private List<PostgreRole> allUsers;
    private PostgreRole owner;
    private String name = null;
    private String loc = null;
    private String options = null;

    public PostgreCreateTablespaceDialog(Shell parentShell, PostgreTablespace tablespace) {
        super(parentShell, PostgreMessages.dialog_create_tablespace_title, null);
        this.newTablespace = tablespace;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    private void checkEnabled() {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(CommonUtils.isNotEmpty((String)this.name) && (!this.newTablespace.getDataSource().getServerType().supportsTablespaceLocation() || this.loc != null && !this.loc.isEmpty()));
        }
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Composite group = new Composite(composite, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        gd.widthHint = 600;
        gd.heightHint = 200;
        gd.verticalIndent = 0;
        gd.horizontalIndent = 0;
        group.setLayoutData((Object)gd);
        UIUtils.createLabelText((Composite)group, (String)PostgreMessages.dialog_create_tablespace_database, (String)this.newTablespace.getDatabase().getName(), (int)2056);
        final Text nameText = UIUtils.createLabelText((Composite)group, (String)PostgreMessages.dialog_create_tablespace_name, (String)"");
        nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PostgreCreateTablespaceDialog.this.name = nameText.getText().trim();
                PostgreCreateTablespaceDialog.this.checkEnabled();
            }
        });
        final Combo userCombo = UIUtils.createLabelCombo((Composite)group, (String)PostgreMessages.dialog_create_tablespace_owner, (int)2060);
        userCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PostgreCreateTablespaceDialog.this.owner = PostgreCreateTablespaceDialog.this.allUsers.get(userCombo.getSelectionIndex());
                PostgreCreateTablespaceDialog.this.checkEnabled();
            }
        });
        if (this.newTablespace.getDataSource().getServerType().supportsTablespaceLocation()) {
            Text locText = UIUtils.createLabelText((Composite)group, (String)PostgreMessages.dialog_create_tablespace_loc, (String)"");
            locText.addModifyListener(e -> {
                this.loc = locText.getText();
                this.checkEnabled();
            });
        }
        UIUtils.createControlLabel((Composite)group, (String)PostgreMessages.dialog_create_tablespace_options);
        Text optionsText = new Text(group, 2626);
        GridData gd1 = new GridData(1808);
        gd1.heightHint = optionsText.getLineHeight() * 6;
        gd1.widthHint = optionsText.getLineHeight() * 30;
        optionsText.setLayoutData((Object)gd1);
        optionsText.addModifyListener(e -> {
            this.options = optionsText.getText();
        });
        new AbstractJob("Load users"){

            @NotNull
            protected IStatus run(@NotNull DBRProgressMonitor monitor) {
                try {
                    PostgreCreateTablespaceDialog.this.allUsers = new ArrayList<PostgreRole>(PostgreCreateTablespaceDialog.this.newTablespace.getDatabase().getUsers(monitor));
                    PostgreRole dba = PostgreCreateTablespaceDialog.this.newTablespace.getDatabase().getDBA(monitor);
                    String defUserName = dba == null ? "" : dba.getName();
                    UIUtils.syncExec(() -> {
                        for (PostgreRole authId : PostgreCreateTablespaceDialog.this.allUsers) {
                            String name = authId.getName();
                            userCombo.add(name);
                            if (!name.equals(defUserName)) continue;
                            PostgreCreateTablespaceDialog.this.owner = authId;
                        }
                        userCombo.setText(defUserName);
                    });
                }
                catch (DBException e) {
                    return GeneralUtils.makeExceptionStatus((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    public PostgreRole getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public String getLoc() {
        return this.loc;
    }

    public String getOptions() {
        return this.options;
    }
}

