/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.program.Program;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBIconBinary;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class ProgramInfo {
    private static final Map<String, ProgramInfo> programMap = new HashMap<String, ProgramInfo>();
    private final Program program;
    private final String fileExtension;
    private DBIconBinary image;

    public ProgramInfo(Program program, String fileExtension) {
        this.fileExtension = fileExtension;
        this.program = program;
    }

    public Program getProgram() {
        return this.program;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public DBPImage getImage() {
        return this.image;
    }

    public static ProgramInfo getProgram(IResource resource) {
        String fileExtension;
        if (resource instanceof IFile && !CommonUtils.isEmpty((String)(fileExtension = CommonUtils.notEmpty((String)resource.getFileExtension())))) {
            return ProgramInfo.getProgram(fileExtension);
        }
        return null;
    }

    public static ProgramInfo getProgram(String fileExtension) {
        ProgramInfo programInfo = programMap.get(fileExtension);
        if (programInfo == null) {
            Program program = Program.findProgram((String)fileExtension);
            programInfo = new ProgramInfo(program, fileExtension);
            if (program != null) {
                ImageData[] imageData = new ImageData[1];
                UIUtils.syncExec(() -> {
                    imageData[0] = program.getImageData();
                });
                if (imageData[0] != null) {
                    programInfo.image = new DBIconBinary(program.getName(), imageData[0]);
                }
            }
            programMap.put(fileExtension, programInfo);
        }
        return programInfo.program == null ? null : programInfo;
    }
}

