/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.BoldStylerProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public abstract class SearchCellLabelProvider
extends StyledCellLabelProvider
implements ILabelProvider,
IFontProvider {
    protected final Font boldFont = UIUtils.makeBoldFont(Display.getCurrent().getSystemFont());

    public static boolean matches(@NotNull String pattern, @NotNull String value) {
        return SearchCellLabelProvider.match(pattern, value) != null;
    }

    public void update(@NotNull ViewerCell cell) {
        String pattern = this.getPattern();
        Object element = cell.getElement();
        String text = this.getText(element);
        cell.setText(text);
        cell.setImage(this.getImage(element));
        cell.setFont(this.getFont(element));
        List<Object> ranges = CommonUtils.isEmpty((String)pattern) ? List.of() : SearchCellLabelProvider.match(pattern, text);
        if (CommonUtils.isEmpty(ranges)) {
            cell.setStyleRanges(null);
        } else {
            StyledString.Styler styler = new BoldStylerProvider(this.getMatchFont(element)).getBoldStyler();
            StyledString ss = new StyledString(text);
            for (int[] nArray : ranges) {
                ss.setStyle(nArray[0], nArray[1], styler);
            }
            cell.setStyleRanges(ss.getStyleRanges());
        }
        super.update(cell);
    }

    @Nullable
    public Font getFont(Object element) {
        return null;
    }

    @NotNull
    public Font getMatchFont(@NotNull Object element) {
        return this.boldFont;
    }

    @Nullable
    public abstract Image getImage(Object var1);

    @NotNull
    public abstract String getText(Object var1);

    @Nullable
    public abstract String getPattern();

    public void dispose() {
        this.boldFont.dispose();
    }

    @Nullable
    private static List<int[]> match(@NotNull String pattern, @NotNull String value) {
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        int p = 0;
        int start = -1;
        for (int v = 0; p <= pattern.length() && v <= value.length(); ++v) {
            if (p != pattern.length() && v == value.length()) {
                return null;
            }
            if (p < pattern.length() && Character.toLowerCase(pattern.charAt(p)) == Character.toLowerCase(value.charAt(v))) {
                if (start < 0) {
                    start = v;
                }
                ++p;
                continue;
            }
            if (start < 0) continue;
            ranges.add(new int[]{start, v - start});
            start = -1;
        }
        return ranges;
    }
}

