/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.notifications;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.notifications.AbstractNotification;
import org.jkiss.dbeaver.ui.notifications.DatabaseNotificationPopup;
import org.jkiss.dbeaver.ui.notifications.NotificationSinkEvent;

public class DatabaseNotificationSink {
    private static final long DELAY_OPEN = 200L;
    private static final boolean runSystem = true;
    private final WeakHashMap<Object, Object> cancelledTokens = new WeakHashMap();
    private final Set<AbstractNotification> notifications = new HashSet<AbstractNotification>();
    private final Set<AbstractNotification> currentlyNotifying = Collections.synchronizedSet(this.notifications);
    private final Job openJob = new Job("Database notifications"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            try {
                if (Platform.isRunning()) {
                    if (!PlatformUI.isWorkbenchRunning()) {
                        this.schedule(1000L);
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    Display display = PlatformUI.getWorkbench().getDisplay();
                    if (display == null || display.isDisposed()) {
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    display.asyncExec(() -> {
                        DatabaseNotificationSink.this.collectNotifications();
                        if (DatabaseNotificationSink.this.popup != null && DatabaseNotificationSink.this.popup.getReturnCode() == 1) {
                            List<AbstractNotification> notifications = DatabaseNotificationSink.this.popup.getNotifications();
                            for (AbstractNotification notification2 : notifications) {
                                if (notification2.getToken() == null) continue;
                                DatabaseNotificationSink.this.cancelledTokens.put(notification2.getToken(), null);
                            }
                        }
                        DatabaseNotificationSink.this.currentlyNotifying.removeIf(notification -> notification.getToken() != null && DatabaseNotificationSink.this.cancelledTokens.containsKey(notification.getToken()));
                        Class<DatabaseNotificationSink> clazz = DatabaseNotificationSink.class;
                        synchronized (DatabaseNotificationSink.class) {
                            if (!DatabaseNotificationSink.this.currentlyNotifying.isEmpty()) {
                                DatabaseNotificationSink.this.showPopup();
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    });
                }
            }
            finally {
                if (DatabaseNotificationSink.this.popup != null && !DBWorkbench.getPlatform().isShuttingDown()) {
                    this.schedule(DatabaseNotificationSink.this.popup.getDelayClose() / 2L);
                }
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    };
    private DatabaseNotificationPopup popup;

    public DatabaseNotificationSink() {
        this.openJob.setSystem(true);
    }

    private void cleanNotified() {
        this.currentlyNotifying.clear();
    }

    private void collectNotifications() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AbstractNotification> getNotifications() {
        Class<DatabaseNotificationSink> clazz = DatabaseNotificationSink.class;
        synchronized (DatabaseNotificationSink.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.currentlyNotifying;
        }
    }

    public void notify(NotificationSinkEvent event) {
        this.currentlyNotifying.addAll(event.getNotifications());
        if (!this.openJob.cancel()) {
            try {
                this.openJob.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.openJob.schedule(200L);
    }

    private void showPopup() {
        if (this.popup != null) {
            this.popup.close();
        }
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        Shell shell = new Shell(PlatformUI.getWorkbench().getDisplay());
        this.popup = new DatabaseNotificationPopup(shell);
        this.popup.setFadingEnabled(false);
        this.popup.setDelayClose(store.getInt("notifications.closeDelay"));
        ArrayList<AbstractNotification> toDisplay = new ArrayList<AbstractNotification>(this.currentlyNotifying);
        Collections.sort(toDisplay);
        this.popup.setContents(toDisplay);
        this.cleanNotified();
        this.popup.setBlockOnOpen(false);
        this.popup.open();
        if (store.getBoolean("screen.reader.force.focus")) {
            this.popup.setFocus();
        }
    }
}

